/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm.ldap;

import java.io.IOException;
import java.security.Provider;
import java.security.spec.InvalidKeySpecException;
import java.util.function.Supplier;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.NoSuchAttributeException;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.realm.ldap.CredentialPersister;
import org.wildfly.security.auth.realm.ldap.EvidenceVerifier;
import org.wildfly.security.auth.realm.ldap.IdentityCredentialPersister;
import org.wildfly.security.auth.realm.ldap.IdentityEvidenceVerifier;
import org.wildfly.security.auth.realm.ldap.UserPasswordPasswordUtil;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.password.Password;

class UserPasswordCredentialLoader
implements CredentialPersister {
    static final String DEFAULT_USER_PASSWORD_ATTRIBUTE_NAME = "userPassword";
    private final String userPasswordAttributeName;

    UserPasswordCredentialLoader(String userPasswordAttributeName) {
        Assert.checkNotNullParam((String)"userPasswordAttributeName", (Object)userPasswordAttributeName);
        this.userPasswordAttributeName = userPasswordAttributeName;
    }

    @Override
    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String credentialAlgorithm) throws RealmUnavailableException {
        if (credentialType == PasswordCredential.class) {
            if (credentialAlgorithm == null) {
                return SupportLevel.SUPPORTED;
            }
            if (UserPasswordPasswordUtil.isAlgorithmSupported(credentialAlgorithm)) {
                return SupportLevel.POSSIBLY_SUPPORTED;
            }
        }
        return SupportLevel.UNSUPPORTED;
    }

    @Override
    public IdentityCredentialPersister forIdentity(DirContext dirContext, String distinguishedName) {
        return new ForIdentityLoader(dirContext, distinguishedName);
    }

    EvidenceVerifier toEvidenceVerifier() {
        return new EvidenceVerifier(){

            @Override
            public SupportLevel getEvidenceVerifySupport(DirContext context, Class<? extends Evidence> evidenceType, String evidenceAlgorithm) throws RealmUnavailableException {
                if (!PasswordCredential.canVerifyEvidence(evidenceType, evidenceAlgorithm)) {
                    return SupportLevel.UNSUPPORTED;
                }
                return UserPasswordCredentialLoader.this.getCredentialAcquireSupport(PasswordCredential.class, evidenceAlgorithm);
            }

            @Override
            public IdentityEvidenceVerifier forIdentity(DirContext context, String distinguishedName) throws RealmUnavailableException {
                return new ForIdentityLoader(context, distinguishedName);
            }
        };
    }

    private class ForIdentityLoader
    implements IdentityCredentialPersister,
    IdentityEvidenceVerifier {
        private final DirContext context;
        private final String distinguishedName;

        public ForIdentityLoader(DirContext context, String distinguishedName) {
            this.context = context;
            this.distinguishedName = distinguishedName;
        }

        @Override
        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String credentialAlgorithm, Supplier<Provider[]> providers) {
            Credential credential = this.getCredential(credentialType, credentialAlgorithm, providers);
            if (credential != null) {
                return SupportLevel.SUPPORTED;
            }
            return SupportLevel.UNSUPPORTED;
        }

        @Override
        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String evidenceAlgorithm, Supplier<Provider[]> providers) throws RealmUnavailableException {
            if (!PasswordCredential.canVerifyEvidence(evidenceType, evidenceAlgorithm)) {
                return SupportLevel.UNSUPPORTED;
            }
            return this.getCredentialAcquireSupport(PasswordCredential.class, null, providers);
        }

        @Override
        public <C extends Credential> C getCredential(Class<C> credentialType, String credentialAlgorithm, Supplier<Provider[]> providers) {
            block5: {
                if (credentialType != PasswordCredential.class) {
                    return null;
                }
                try {
                    Attributes attributes = this.context.getAttributes(this.distinguishedName, new String[]{UserPasswordCredentialLoader.this.userPasswordAttributeName});
                    Attribute attribute = attributes.get(UserPasswordCredentialLoader.this.userPasswordAttributeName);
                    if (attribute != null) {
                        int size = attribute.size();
                        for (int i = 0; i < size; ++i) {
                            byte[] value = (byte[])attribute.get(i);
                            Password password = UserPasswordPasswordUtil.parseUserPassword(value);
                            if (!credentialType.isAssignableFrom(PasswordCredential.class) || credentialAlgorithm != null && !credentialAlgorithm.equals(password.getAlgorithm())) continue;
                            return (C)((Credential)credentialType.cast(new PasswordCredential(password)));
                        }
                    }
                }
                catch (InvalidKeySpecException | NamingException e) {
                    if (!ElytronMessages.log.isTraceEnabled()) break block5;
                    ElytronMessages.log.trace("Getting user-password credential " + credentialType.getName() + " failed. dn=" + this.distinguishedName, e);
                }
            }
            return null;
        }

        @Override
        public boolean verifyEvidence(Evidence evidence, Supplier<Provider[]> providers) throws RealmUnavailableException {
            PasswordCredential credential = this.getCredential(PasswordCredential.class, null, providers);
            if (credential == null) {
                return false;
            }
            return credential.verify(providers, evidence);
        }

        @Override
        public boolean getCredentialPersistSupport(Class<? extends Credential> credentialType, String credentialAlgorithm) {
            return credentialType == PasswordCredential.class && (credentialAlgorithm == null || UserPasswordPasswordUtil.isAlgorithmSupported(credentialAlgorithm));
        }

        @Override
        public void persistCredential(Credential credential) throws RealmUnavailableException {
            try {
                byte[] composedPassword = UserPasswordPasswordUtil.composeUserPassword(credential.castAndApply(PasswordCredential.class, PasswordCredential::getPassword));
                Assert.assertNotNull((Object)composedPassword);
                BasicAttributes attributes = new BasicAttributes();
                attributes.put(UserPasswordCredentialLoader.this.userPasswordAttributeName, composedPassword);
                this.context.modifyAttributes(this.distinguishedName, 1, (Attributes)attributes);
            }
            catch (IOException | NamingException e) {
                throw ElytronMessages.log.ldapRealmCredentialPersistingFailed(credential.toString(), this.distinguishedName, e);
            }
        }

        @Override
        public void clearCredentials() throws RealmUnavailableException {
            try {
                BasicAttributes attributes = new BasicAttributes();
                attributes.put(new BasicAttribute(UserPasswordCredentialLoader.this.userPasswordAttributeName));
                this.context.modifyAttributes(this.distinguishedName, 3, (Attributes)attributes);
            }
            catch (NoSuchAttributeException attributes) {
            }
            catch (NamingException e) {
                throw ElytronMessages.log.ldapRealmCredentialClearingFailed(this.distinguishedName, e);
            }
        }
    }
}

