/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import java.util.EnumSet;
import org.wildfly.security.ssl.CipherSuitePredicate;
import org.wildfly.security.ssl.KeyAgreement;
import org.wildfly.security.ssl.MechanismDatabase;

final class KeyAgreementCipherSuitePredicate
extends CipherSuitePredicate {
    private final EnumSet<KeyAgreement> set;

    KeyAgreementCipherSuitePredicate(EnumSet<KeyAgreement> set) {
        this.set = set;
    }

    @Override
    public boolean test(MechanismDatabase.Entry entry) {
        return this.set.contains((Object)entry.getKeyAgreement());
    }

    @Override
    boolean isAlwaysTrue() {
        return this.set.size() == KeyAgreement.fullSize;
    }

    @Override
    boolean isAlwaysFalse() {
        return this.set.isEmpty();
    }
}

