/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.entity;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import javax.security.auth.x500.X500Principal;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.asn1.ASN1Exception;
import org.wildfly.security.asn1.DERDecoder;
import org.wildfly.security.asn1.DEREncoder;
import org.wildfly.security.sasl.entity.Entity;
import org.wildfly.security.sasl.entity.GeneralName;
import org.wildfly.security.sasl.entity.TrustedAuthority;
import org.wildfly.security.x500.X500PrincipalUtil;
import org.wildfly.security.x500.X509CertificateCredentialDecoder;

class EntityUtil {
    private static final byte[] randomCharDictionary;

    EntityUtil() {
    }

    public static void encodeX509CertificateChain(DEREncoder encoder, X509Certificate[] certChain) throws ASN1Exception {
        try {
            int chainSize = certChain.length;
            encoder.startSetOf();
            for (int i = 0; i < chainSize; ++i) {
                encoder.writeEncoded(certChain[i].getEncoded());
            }
            encoder.endSetOf();
        }
        catch (CertificateEncodingException e) {
            throw new ASN1Exception(e);
        }
    }

    public static void encodeAlgorithmIdentifier(DEREncoder encoder, String objectIdentifier, boolean omitParametersField) throws ASN1Exception {
        encoder.startSequence();
        encoder.encodeObjectIdentifier(objectIdentifier);
        if (!omitParametersField) {
            encoder.encodeNull();
        }
        encoder.endSequence();
    }

    public static void encodeAlgorithmIdentifier(DEREncoder encoder, String algorithm) throws ASN1Exception {
        boolean omitParametersField;
        switch (algorithm) {
            case "SHA1withRSA": {
                omitParametersField = false;
                break;
            }
            case "SHA1withDSA": 
            case "SHA1withECDSA": {
                omitParametersField = true;
                break;
            }
            default: {
                throw ElytronMessages.log.asnUnrecognisedAlgorithm();
            }
        }
        EntityUtil.encodeAlgorithmIdentifier(encoder, Entity.algorithmOid(algorithm), omitParametersField);
    }

    public static void encodeGeneralName(DEREncoder encoder, GeneralName generalName) throws ASN1Exception {
        if (generalName instanceof GeneralName.OtherName) {
            encoder.encodeImplicit(generalName.getType());
            encoder.startSequence();
            encoder.encodeObjectIdentifier(((GeneralName.OtherName)generalName).getObjectIdentifier());
            encoder.writeEncoded(((GeneralName.OtherName)generalName).getEncodedValue());
            encoder.endSequence();
        } else if (generalName instanceof GeneralName.RFC822Name) {
            encoder.encodeImplicit(generalName.getType());
            encoder.encodeIA5String(((GeneralName.RFC822Name)generalName).getName());
        } else if (generalName instanceof GeneralName.DNSName) {
            encoder.encodeImplicit(generalName.getType());
            encoder.encodeIA5String(((GeneralName.DNSName)generalName).getName());
        } else if (generalName instanceof GeneralName.X400Address) {
            encoder.encodeImplicit(generalName.getType());
            encoder.writeEncoded(((GeneralName.X400Address)generalName).getName());
        } else if (generalName instanceof GeneralName.DirectoryName) {
            encoder.startExplicit(generalName.getType());
            encoder.writeEncoded(new X500Principal(((GeneralName.DirectoryName)generalName).getName()).getEncoded());
            encoder.endExplicit();
        } else if (generalName instanceof GeneralName.EDIPartyName) {
            encoder.encodeImplicit(generalName.getType());
            encoder.writeEncoded(((GeneralName.EDIPartyName)generalName).getName());
        } else if (generalName instanceof GeneralName.URIName) {
            encoder.encodeImplicit(generalName.getType());
            encoder.encodeIA5String(((GeneralName.URIName)generalName).getName());
        } else if (generalName instanceof GeneralName.IPAddress) {
            encoder.encodeImplicit(generalName.getType());
            encoder.encodeOctetString(((GeneralName.IPAddress)generalName).getName());
        } else if (generalName instanceof GeneralName.RegisteredID) {
            encoder.encodeImplicit(generalName.getType());
            encoder.encodeObjectIdentifier(((GeneralName.RegisteredID)generalName).getName());
        } else {
            throw ElytronMessages.log.asnInvalidGeneralNameType();
        }
    }

    public static void encodeGeneralNames(DEREncoder encoder, List<GeneralName> generalNames) throws ASN1Exception {
        encoder.startSequence();
        for (GeneralName generalName : generalNames) {
            EntityUtil.encodeGeneralName(encoder, generalName);
        }
        encoder.endSequence();
    }

    public static void encodeGeneralNames(DEREncoder encoder, GeneralName generalName) throws ASN1Exception {
        ArrayList<GeneralName> generalNames = new ArrayList<GeneralName>(1);
        generalNames.add(generalName);
        EntityUtil.encodeGeneralNames(encoder, generalNames);
    }

    public static void encodeGeneralNames(DEREncoder encoder, String subjectName, Collection<List<?>> subjectAltNames) throws ASN1Exception {
        encoder.startSequence();
        if (!subjectName.isEmpty()) {
            EntityUtil.encodeGeneralName(encoder, new GeneralName.DirectoryName(subjectName));
        }
        if (subjectAltNames != null) {
            for (List<?> altName : subjectAltNames) {
                EntityUtil.encodeGeneralName(encoder, EntityUtil.convertToGeneralName(altName));
            }
        }
        encoder.endSequence();
    }

    public static byte[] encodeRandomNumber(DEREncoder encoder, SecureRandom secureRandom) {
        Random random = secureRandom != null ? secureRandom : ThreadLocalRandom.current();
        byte[] randomA = EntityUtil.generateRandomString(48, random);
        encoder.encodeOctetString(randomA);
        return randomA;
    }

    public static byte[] generateRandomString(int length, Random random) {
        byte[] chars = new byte[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = randomCharDictionary[random.nextInt(93)];
        }
        return chars;
    }

    public static void encodeTrustedAuthority(DEREncoder encoder, TrustedAuthority trustedAuthority) throws ASN1Exception {
        if (trustedAuthority instanceof TrustedAuthority.NameTrustedAuthority) {
            encoder.startExplicit(trustedAuthority.getType());
            encoder.writeEncoded(new X500Principal(((TrustedAuthority.NameTrustedAuthority)trustedAuthority).getIdentifier()).getEncoded());
            encoder.endExplicit();
        } else if (trustedAuthority instanceof TrustedAuthority.HashTrustedAuthority) {
            encoder.encodeImplicit(trustedAuthority.getType());
            encoder.encodeOctetString(((TrustedAuthority.HashTrustedAuthority)trustedAuthority).getIdentifier());
        } else if (trustedAuthority instanceof TrustedAuthority.CertificateTrustedAuthority) {
            encoder.encodeImplicit(trustedAuthority.getType());
            try {
                encoder.writeEncoded(((TrustedAuthority.CertificateTrustedAuthority)trustedAuthority).getIdentifier().getEncoded());
            }
            catch (CertificateEncodingException e) {
                throw new ASN1Exception(e);
            }
        } else {
            throw ElytronMessages.log.asnInvalidTrustedAuthorityType();
        }
    }

    public static void encodeTrustedAuthorities(DEREncoder encoder, List<TrustedAuthority> trustedAuthorities) throws ASN1Exception {
        encoder.startSequence();
        for (TrustedAuthority trustedAuthority : trustedAuthorities) {
            EntityUtil.encodeTrustedAuthority(encoder, trustedAuthority);
        }
        encoder.endSequence();
    }

    public static List<GeneralName> decodeGeneralNames(DERDecoder decoder) throws ASN1Exception {
        ArrayList<GeneralName> generalNames = new ArrayList<GeneralName>();
        GeneralName generalName = null;
        decoder.startSequence();
        while (decoder.hasNextElement()) {
            block12: for (int generalNameType = 0; generalNameType <= 8; ++generalNameType) {
                switch (generalNameType) {
                    case 0: {
                        if (!decoder.isNextType(128, generalNameType, true)) continue block12;
                        decoder.decodeImplicit(generalNameType);
                        decoder.startSequence();
                        String typeId = decoder.decodeObjectIdentifier();
                        byte[] encodedValue = decoder.drainElement();
                        decoder.endSequence();
                        generalName = new GeneralName.OtherName(typeId, encodedValue);
                        break block12;
                    }
                    case 1: {
                        if (!decoder.isNextType(128, generalNameType, false)) continue block12;
                        decoder.decodeImplicit(generalNameType);
                        generalName = new GeneralName.RFC822Name(decoder.decodeIA5String());
                        break block12;
                    }
                    case 2: {
                        if (!decoder.isNextType(128, generalNameType, false)) continue block12;
                        decoder.decodeImplicit(generalNameType);
                        generalName = new GeneralName.DNSName(decoder.decodeIA5String());
                        break block12;
                    }
                    case 3: {
                        if (!decoder.isNextType(128, generalNameType, true)) continue block12;
                        decoder.decodeImplicit(generalNameType);
                        generalName = new GeneralName.X400Address(decoder.drainElementValue(), true);
                        break block12;
                    }
                    case 4: {
                        if (!decoder.isNextType(128, generalNameType, true)) continue block12;
                        byte[] encodedName = decoder.drainElementValue();
                        generalName = new GeneralName.DirectoryName(new X500Principal(encodedName).getName("CANONICAL"));
                        break block12;
                    }
                    case 5: {
                        if (!decoder.isNextType(128, generalNameType, true)) continue block12;
                        decoder.decodeImplicit(generalNameType);
                        generalName = new GeneralName.EDIPartyName(decoder.drainElementValue(), true);
                        break block12;
                    }
                    case 6: {
                        if (!decoder.isNextType(128, generalNameType, false)) continue block12;
                        decoder.decodeImplicit(generalNameType);
                        generalName = new GeneralName.URIName(decoder.decodeIA5String());
                        break block12;
                    }
                    case 7: {
                        if (!decoder.isNextType(128, generalNameType, false)) continue block12;
                        decoder.decodeImplicit(generalNameType);
                        generalName = new GeneralName.IPAddress(decoder.decodeOctetString());
                        break block12;
                    }
                    case 8: {
                        if (!decoder.isNextType(128, generalNameType, false)) continue block12;
                        decoder.decodeImplicit(generalNameType);
                        generalName = new GeneralName.RegisteredID(decoder.decodeObjectIdentifier());
                        break block12;
                    }
                    default: {
                        throw ElytronMessages.log.asnInvalidGeneralNameType();
                    }
                }
            }
            generalNames.add(generalName);
        }
        decoder.endSequence();
        return generalNames;
    }

    public static X509Certificate[] decodeX509CertificateChain(DERDecoder decoder) throws ASN1Exception {
        if (decoder.peekType() != 49) {
            throw ElytronMessages.log.asnUnexpectedTag();
        }
        byte[] certChain = decoder.drainElement();
        try {
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            certChain[0] = 48;
            CertPath certPath = certFactory.generateCertPath(new ByteArrayInputStream(certChain));
            List<? extends Certificate> certs = certPath.getCertificates();
            return certs.toArray(new X509Certificate[certs.size()]);
        }
        catch (CertificateException e) {
            throw new ASN1Exception(e);
        }
    }

    public static X509Certificate[] decodeCertificateData(DERDecoder decoder) throws ASN1Exception {
        X509Certificate[] peerCertChain;
        if (decoder.peekType() == 49) {
            peerCertChain = EntityUtil.decodeX509CertificateChain(decoder);
        } else if (decoder.peekType() == 22) {
            try {
                X509Certificate peerCert = EntityUtil.getCertificateFromUrl(decoder.decodeIA5String());
                peerCertChain = new X509Certificate[]{peerCert};
            }
            catch (IOException e) {
                throw ElytronMessages.log.asnUnableToReadCertificateData(e);
            }
        } else {
            throw ElytronMessages.log.asnUnexpectedTag();
        }
        return peerCertChain;
    }

    public static X509Certificate getCertificateFromUrl(String certUrl) throws IOException {
        X509Certificate cert;
        InputStream in = null;
        try {
            URL url = new URL(certUrl);
            in = url.openStream();
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            cert = (X509Certificate)certFactory.generateCertificate(in);
        }
        catch (CertificateException e) {
            try {
                throw ElytronMessages.log.asnUnableToReadCertificateFromUrl(certUrl, e);
            }
            catch (Throwable throwable) {
                EntityUtil.safeClose(in);
                throw throwable;
            }
        }
        EntityUtil.safeClose(in);
        return cert;
    }

    public static List<TrustedAuthority> decodeTrustedAuthorities(DERDecoder decoder) throws ASN1Exception {
        ArrayList<TrustedAuthority> trustedAuthorities = new ArrayList<TrustedAuthority>();
        TrustedAuthority trustedAuthority = null;
        decoder.startSequence();
        while (decoder.hasNextElement()) {
            block10: for (int trustedAuthorityType = 0; trustedAuthorityType <= 4; ++trustedAuthorityType) {
                switch (trustedAuthorityType) {
                    case 0: {
                        if (!decoder.isNextType(128, trustedAuthorityType, true)) continue block10;
                        byte[] encodedName = decoder.drainElementValue();
                        trustedAuthority = new TrustedAuthority.NameTrustedAuthority(new X500Principal(encodedName).getName("CANONICAL"));
                        break block10;
                    }
                    case 3: {
                        if (!decoder.isNextType(128, trustedAuthorityType, true)) continue block10;
                        decoder.decodeImplicit(trustedAuthorityType);
                        byte[] cert = decoder.drainElementValue();
                        try {
                            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                            trustedAuthority = new TrustedAuthority.CertificateTrustedAuthority((X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(cert)));
                            break block10;
                        }
                        catch (CertificateException e) {
                            throw new ASN1Exception(e);
                        }
                    }
                    case 1: {
                        if (!decoder.isNextType(128, trustedAuthorityType, false)) continue block10;
                        decoder.decodeImplicit(trustedAuthorityType);
                        trustedAuthority = new TrustedAuthority.IssuerNameHashTrustedAuthority(decoder.decodeOctetString());
                        break block10;
                    }
                    case 2: {
                        if (!decoder.isNextType(128, trustedAuthorityType, false)) continue block10;
                        decoder.decodeImplicit(trustedAuthorityType);
                        trustedAuthority = new TrustedAuthority.IssuerKeyHashTrustedAuthority(decoder.decodeOctetString());
                        break block10;
                    }
                    case 4: {
                        if (!decoder.isNextType(128, trustedAuthorityType, false)) continue block10;
                        decoder.decodeImplicit(trustedAuthorityType);
                        trustedAuthority = new TrustedAuthority.PKCS15KeyHashTrustedAuthority(decoder.decodeOctetString());
                        break block10;
                    }
                    default: {
                        throw ElytronMessages.log.asnInvalidGeneralNameType();
                    }
                }
            }
            trustedAuthorities.add(trustedAuthority);
        }
        decoder.endSequence();
        return trustedAuthorities;
    }

    public static boolean matchGeneralNames(List<GeneralName> generalNames, List<GeneralName> actualGeneralNames) {
        if (generalNames == null || actualGeneralNames == null) {
            return false;
        }
        for (GeneralName generalName : generalNames) {
            for (GeneralName actualGeneralName : actualGeneralNames) {
                if (!EntityUtil.matchGeneralName(generalName, actualGeneralName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean matchGeneralName(GeneralName generalName, GeneralName actualGeneralName) {
        if (generalName instanceof GeneralName.DNSName && actualGeneralName instanceof GeneralName.DirectoryName) {
            String[] cnValues = X500PrincipalUtil.getAttributeValues(new X500Principal(((GeneralName.DirectoryName)actualGeneralName).getName()), "2.5.4.3");
            String dnsName = ((GeneralName.DNSName)generalName).getName();
            return dnsName.equalsIgnoreCase(cnValues[0]);
        }
        return generalName.equals(actualGeneralName);
    }

    public static boolean matchGeneralNames(List<GeneralName> generalNames, X509Certificate cert) {
        X500Principal certSubjectName;
        block5: {
            certSubjectName = X509CertificateCredentialDecoder.getInstance().getPrincipalFromCredential(cert);
            try {
                if (EntityUtil.matchGeneralNames(generalNames, EntityUtil.convertToGeneralNames(cert.getSubjectAlternativeNames()))) {
                    return true;
                }
            }
            catch (CertificateParsingException e) {
                if (certSubjectName != null) break block5;
                throw ElytronMessages.log.unableToDetermineSubjectName(e);
            }
        }
        if (certSubjectName != null) {
            ArrayList<GeneralName> certNames = new ArrayList<GeneralName>(1);
            certNames.add(new GeneralName.DirectoryName(certSubjectName.getName("CANONICAL")));
            if (EntityUtil.matchGeneralNames(generalNames, certNames)) {
                return true;
            }
        }
        return false;
    }

    public static String getDistinguishedNameFromGeneralNames(List<GeneralName> generalNames) {
        for (GeneralName generalName : generalNames) {
            if (!(generalName instanceof GeneralName.DirectoryName)) continue;
            return ((GeneralName.DirectoryName)generalName).getName();
        }
        return null;
    }

    private static GeneralName convertToGeneralName(List<?> generalName) throws ASN1Exception {
        int type = (Integer)generalName.get(0);
        Object name = generalName.get(1);
        switch (type) {
            case 0: {
                return new GeneralName.OtherName((byte[])name);
            }
            case 1: {
                return new GeneralName.RFC822Name((String)name);
            }
            case 2: {
                return new GeneralName.DNSName((String)name);
            }
            case 3: {
                return new GeneralName.X400Address((byte[])name);
            }
            case 4: {
                return new GeneralName.DirectoryName((String)name);
            }
            case 5: {
                return new GeneralName.EDIPartyName((byte[])name);
            }
            case 6: {
                return new GeneralName.URIName((String)name);
            }
            case 7: {
                return new GeneralName.IPAddress((String)name);
            }
            case 8: {
                return new GeneralName.RegisteredID((String)name);
            }
        }
        throw ElytronMessages.log.asnInvalidGeneralNameType();
    }

    private static List<GeneralName> convertToGeneralNames(Collection<List<?>> generalNames) throws ASN1Exception {
        if (generalNames == null) {
            return null;
        }
        ArrayList<GeneralName> convertedGeneralNames = new ArrayList<GeneralName>();
        for (List<?> generalName : generalNames) {
            convertedGeneralNames.add(EntityUtil.convertToGeneralName(generalName));
        }
        return convertedGeneralNames;
    }

    private static void safeClose(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    static {
        int c;
        byte[] dict = new byte[93];
        int i = 0;
        for (c = 33; c < 44; c = (int)((byte)(c + 1))) {
            dict[i++] = c;
        }
        for (c = 45; c < 127; c = (int)((byte)(c + 1))) {
            dict[i++] = c;
        }
        assert (i == dict.length);
        randomCharDictionary = dict;
    }
}

