/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.function.Supplier;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;

public final class SecurityProviderSaslServerFactory
implements SaslServerFactory {
    private static final String serviceType = SaslServerFactory.class.getSimpleName();
    private final Supplier<Provider[]> providerSupplier;

    public SecurityProviderSaslServerFactory(Supplier<Provider[]> providerSupplier) {
        this.providerSupplier = providerSupplier;
    }

    @Override
    public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        for (Provider currentProvider : this.providerSupplier.get()) {
            for (Provider.Service service : currentProvider.getServices()) {
                if (!serviceType.equals(service.getType())) continue;
                try {
                    SaslServer saslServer = ((SaslServerFactory)service.newInstance(null)).createSaslServer(mechanism, protocol, serverName, props, cbh);
                    if (saslServer == null) continue;
                    return saslServer;
                }
                catch (ClassCastException | InvalidParameterException | NoSuchAlgorithmException exception) {
                }
            }
        }
        return null;
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        LinkedHashSet names = new LinkedHashSet();
        for (Provider currentProvider : this.providerSupplier.get()) {
            for (Provider.Service service : currentProvider.getServices()) {
                if (!serviceType.equals(service.getType())) continue;
                try {
                    Collections.addAll(names, ((SaslServerFactory)service.newInstance(null)).getMechanismNames(props));
                }
                catch (ClassCastException | InvalidParameterException | NoSuchAlgorithmException exception) {}
            }
        }
        return names.toArray(new String[names.size()]);
    }
}

