/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.security.Security;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.wildfly.common.Assert;
import org.wildfly.security.sasl.util.AggregateSaslClientFactory;
import org.wildfly.security.sasl.util.AggregateSaslServerFactory;
import org.wildfly.security.sasl.util.SecurityProviderSaslClientFactory;
import org.wildfly.security.sasl.util.SecurityProviderSaslServerFactory;
import org.wildfly.security.sasl.util.ServiceLoaderSaslClientFactory;
import org.wildfly.security.sasl.util.ServiceLoaderSaslServerFactory;

public final class SaslFactories {
    private static final SecurityProviderSaslClientFactory providerSaslClientFactory = new SecurityProviderSaslClientFactory(Security::getProviders);
    private static final SecurityProviderSaslServerFactory providerSaslServerFactory = new SecurityProviderSaslServerFactory(Security::getProviders);
    private static final String[] NO_STRINGS = new String[0];
    private static final SaslClientFactory EMPTY_SASL_CLIENT_FACTORY = new SaslClientFactory(){

        @Override
        public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
            return null;
        }

        @Override
        public String[] getMechanismNames(Map<String, ?> props) {
            return NO_STRINGS;
        }
    };
    private static final SaslServerFactory EMPTY_SASL_SERVER_FACTORY = new SaslServerFactory(){

        @Override
        public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
            return null;
        }

        @Override
        public String[] getMechanismNames(Map<String, ?> props) {
            return NO_STRINGS;
        }
    };

    private SaslFactories() {
    }

    public static SaslClientFactory getElytronSaslClientFactory() {
        return new ServiceLoaderSaslClientFactory(SaslFactories.class.getClassLoader());
    }

    public static SaslServerFactory getElytronSaslServerFactory() {
        return new ServiceLoaderSaslServerFactory(SaslFactories.class.getClassLoader());
    }

    public static SaslClientFactory getSearchSaslClientFactory(ClassLoader ... classLoaders) {
        Assert.checkNotNullParam((String)"classLoaders", (Object)classLoaders);
        SaslClientFactory[] factories = new SaslClientFactory[classLoaders.length];
        int classLoadersLength = classLoaders.length;
        for (int i = 0; i < classLoadersLength; ++i) {
            factories[i] = new ServiceLoaderSaslClientFactory(classLoaders[i]);
        }
        return new AggregateSaslClientFactory(factories);
    }

    public static SaslServerFactory getSearchSaslServerFactory(ClassLoader ... classLoaders) {
        Assert.checkNotNullParam((String)"classLoaders", (Object)classLoaders);
        SaslServerFactory[] factories = new SaslServerFactory[classLoaders.length];
        int classLoadersLength = classLoaders.length;
        for (int i = 0; i < classLoadersLength; ++i) {
            factories[i] = new ServiceLoaderSaslServerFactory(classLoaders[i]);
        }
        return new AggregateSaslServerFactory(factories);
    }

    public static SecurityProviderSaslClientFactory getProviderSaslClientFactory() {
        return providerSaslClientFactory;
    }

    public static SecurityProviderSaslServerFactory getProviderSaslServerFactory() {
        return providerSaslServerFactory;
    }

    public static SaslClientFactory getEmptySaslClientFactory() {
        return EMPTY_SASL_CLIENT_FACTORY;
    }

    public static SaslServerFactory getEmptySaslServerFactory() {
        return EMPTY_SASL_SERVER_FACTORY;
    }
}

