/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.wildfly.security.auth.callback.ChannelBindingCallback;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslClientFactory;

public final class ChannelBindingSaslClientFactory
extends AbstractDelegatingSaslClientFactory {
    private final String bindingType;
    private final byte[] bindingData;

    public ChannelBindingSaslClientFactory(SaslClientFactory delegate, String bindingType, byte[] bindingData) {
        super(delegate);
        this.bindingType = bindingType;
        this.bindingData = bindingData;
    }

    @Override
    public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        return this.delegate.createSaslClient(mechanisms, authorizationId, protocol, serverName, props, callbacks -> {
            for (Callback callback : callbacks) {
                if (!(callback instanceof ChannelBindingCallback)) continue;
                ((ChannelBindingCallback)callback).setBindingType(this.bindingType);
                ((ChannelBindingCallback)callback).setBindingData(this.bindingData);
            }
            cbh.handle(callbacks);
        });
    }
}

