/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.tool;

import java.io.BufferedReader;
import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Supplier;
import javax.crypto.SecretKey;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.SecretKeyCredential;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.CredentialStoreException;
import org.wildfly.security.credential.store.UnsupportedCredentialTypeException;
import org.wildfly.security.credential.store.impl.PropertiesCredentialStore;
import org.wildfly.security.encryption.SecretKeyUtil;
import org.wildfly.security.keystore.AtomicLoadKeyStore;
import org.wildfly.security.keystore.KeyStoreUtil;
import org.wildfly.security.keystore.WildFlyElytronKeyStoreProvider;
import org.wildfly.security.password.WildFlyElytronPasswordProvider;
import org.wildfly.security.provider.util.ProviderUtil;
import org.wildfly.security.tool.ElytronToolMessages;

public abstract class Command {
    public static final int GENERAL_CONFIGURATION_ERROR = 7;
    public static final int GENERAL_CONFIGURATION_WARNING = 1;
    public static final int INPUT_DATA_NOT_CONFIRMED = 3;
    public static Supplier<Provider[]> ELYTRON_KS_PASS_PROVIDERS = () -> new Provider[]{WildFlyElytronKeyStoreProvider.getInstance(), WildFlyElytronPasswordProvider.getInstance()};
    private int status = 255;
    private List<String> redirectionValues;
    private boolean enableDebug;
    private String toolCommand = "java -jar wildfly-elytron-tool.jar";
    public static final int WIDTH = 1024;

    public abstract void execute(String[] var1) throws Exception;

    public void help() {
    }

    public boolean isAlias(String alias) {
        return this.aliases().contains(alias);
    }

    protected Set<String> aliases() {
        return Collections.emptySet();
    }

    public int getStatus() {
        return this.status;
    }

    protected void setStatus(int status) {
        this.status = status;
    }

    public static boolean isWindows() {
        String opsys = System.getProperty("os.name").toLowerCase();
        return opsys.indexOf("win") >= 0;
    }

    protected String prompt(boolean echo, String prompt, boolean confirm, String confirmPrompt) throws Exception {
        Console console = System.console();
        if (echo || console == null) {
            String first;
            if (console == null && this.redirectionValues == null) {
                try (BufferedReader in = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));){
                    String value;
                    this.redirectionValues = new ArrayList<String>();
                    while ((value = in.readLine()) != null) {
                        this.redirectionValues.add(value);
                    }
                }
                catch (IOException e) {
                    this.setStatus(7);
                    throw new Exception(e);
                }
            }
            String string = console != null ? console.readLine(prompt, new Object[0]) : (first = this.redirectionValues.size() == 0 ? null : this.redirectionValues.remove(0));
            if (first != null && confirm) {
                String second;
                String string2 = console != null ? console.readLine(confirmPrompt, new Object[0]) : (second = this.redirectionValues.size() == 0 ? null : this.redirectionValues.remove(0));
                if (first.equals(second)) {
                    return first;
                }
                System.err.println(ElytronToolMessages.msg.inputDataNotConfirmed());
                System.exit(3);
                return null;
            }
            return first;
        }
        char[] inVisible = console.readPassword(prompt != null ? prompt : "Password:", new Object[0]);
        if (inVisible != null && confirm) {
            char[] inVisible2 = console.readPassword(confirmPrompt != null ? confirmPrompt : "Confirm password:", new Object[0]);
            if (Arrays.equals(inVisible, inVisible2)) {
                return new String(inVisible);
            }
            System.err.println(ElytronToolMessages.msg.inputDataNotConfirmed());
            System.exit(3);
            return null;
        }
        if (inVisible != null) {
            return new String(inVisible);
        }
        return null;
    }

    public void printDuplicatesWarning(CommandLine cmdLine) {
        ArrayList<Option> optionsList = new ArrayList<Option>(Arrays.asList(cmdLine.getOptions()));
        HashSet<Option> duplicatesSet = new HashSet<Option>();
        for (Option option : cmdLine.getOptions()) {
            if (Collections.frequency(optionsList, option) <= 1) continue;
            duplicatesSet.add(option);
        }
        for (Option option : duplicatesSet) {
            System.out.println(ElytronToolMessages.msg.duplicateOptionSpecified(option.getLongOpt()));
        }
    }

    public void printDuplicatesWarning(CommandLine cmdLine, List<String> duplicatesAllowed) {
        if (duplicatesAllowed == null) {
            return;
        }
        ArrayList<Option> optionsList = new ArrayList<Option>(Arrays.asList(cmdLine.getOptions()));
        HashSet<Option> duplicatesSet = new HashSet<Option>();
        for (Option option : cmdLine.getOptions()) {
            if (Collections.frequency(optionsList, option) <= 1 || duplicatesAllowed.contains(option.getLongOpt())) continue;
            duplicatesSet.add(option);
        }
        for (Option option : duplicatesSet) {
            System.out.println(ElytronToolMessages.msg.duplicateOptionSpecified(option.getLongOpt()));
        }
    }

    protected void warningHandler(String warning) {
        System.out.print("WARNING: ");
        System.out.println(warning);
    }

    protected void errorHandler(Exception e) throws Exception {
        this.setStatus(7);
        throw e;
    }

    public boolean isEnableDebug() {
        return this.enableDebug;
    }

    public void setEnableDebug(boolean enableDebug) {
        this.enableDebug = enableDebug;
    }

    public String getToolCommand() {
        return this.toolCommand;
    }

    public void setToolCommand(String toolCommand) {
        this.toolCommand = toolCommand;
    }

    protected Supplier<Provider[]> getProvidersSupplier(String providersList) {
        return () -> {
            if (providersList != null && !providersList.isEmpty()) {
                String[] providerNames = providersList.split(",");
                ArrayList<Provider> providers = new ArrayList<Provider>(providerNames.length);
                for (String p : providerNames) {
                    Provider provider = Security.getProvider(p.trim());
                    if (provider == null) continue;
                    providers.add(provider);
                }
                ServiceLoader<Provider> providerLoader = ServiceLoader.load(Provider.class);
                block1: for (Provider provider : providerLoader) {
                    for (String p : providerNames) {
                        if (!provider.getName().equals(p)) continue;
                        providers.add(provider);
                        continue block1;
                    }
                }
                if (providers.isEmpty()) {
                    throw ElytronToolMessages.msg.unknownProvider(providersList);
                }
                return providers.toArray(new Provider[providers.size()]);
            }
            ServiceLoader<Provider> providerLoader = ServiceLoader.load(Provider.class);
            Iterator<Provider> providerIterator = providerLoader.iterator();
            ArrayList<Provider> providers = new ArrayList<Provider>();
            while (providerIterator.hasNext()) {
                Provider provider = providerIterator.next();
                if (provider.getName().equals("WildFlyElytron")) continue;
                providers.add(provider);
            }
            return providers.toArray(new Provider[providers.size()]);
        };
    }

    SecretKey getSecretKey(Boolean createCredentialStore, String credentialStoreLocation, String alias, Boolean populate, int descriptorBlockCount) throws Exception {
        SecretKey key;
        SecretKeyCredential secretKeyCredential;
        CredentialStore credentialStore;
        String csType = PropertiesCredentialStore.NAME;
        try {
            credentialStore = CredentialStore.getInstance((String)csType);
        }
        catch (NoSuchAlgorithmException e) {
            credentialStore = CredentialStore.getInstance((String)csType, this.getProvidersSupplier(null));
        }
        HashMap<String, String> implProps = new HashMap<String, String>();
        implProps.put("create", String.valueOf(createCredentialStore));
        implProps.put("location", credentialStoreLocation);
        implProps.put("modifiable", Boolean.TRUE.toString());
        try {
            credentialStore.initialize(implProps);
        }
        catch (CredentialStoreException e) {
            this.warningHandler(ElytronToolMessages.msg.skippingDescriptorBlockCredentialStoreNotLoaded(descriptorBlockCount));
        }
        try {
            secretKeyCredential = (SecretKeyCredential)credentialStore.retrieve(alias, SecretKeyCredential.class);
        }
        catch (UnsupportedCredentialTypeException e) {
            this.warningHandler(ElytronToolMessages.msg.skippingDescriptorBlockSecretKeyUnsupported(credentialStoreLocation, descriptorBlockCount));
            return null;
        }
        if (secretKeyCredential != null) {
            System.out.println(ElytronToolMessages.msg.existingCredentialStore());
            key = secretKeyCredential.getSecretKey();
        } else if (populate.booleanValue()) {
            try {
                SecretKey newKey = SecretKeyUtil.generateSecretKey((int)256);
                SecretKeyCredential newKeyCredential = new SecretKeyCredential(newKey);
                credentialStore.store(alias, (Credential)newKeyCredential);
                credentialStore.flush();
                key = newKey;
            }
            catch (GeneralSecurityException e) {
                this.warningHandler(ElytronToolMessages.msg.skippingDescriptorBlockUnableToPopulateCredentialStore(credentialStoreLocation, descriptorBlockCount));
                return null;
            }
        } else {
            this.warningHandler(ElytronToolMessages.msg.cmdFileSystemEncryptionNoSecretKey(credentialStoreLocation, descriptorBlockCount));
            return null;
        }
        return key;
    }

    KeyPair getKeyPair(Path keyStorePath, String keyStoreType, String keyPairAlias, char[] password, int descriptorBlockCount) throws CertificateException, NoSuchAlgorithmException {
        Certificate publicKeyCert;
        PrivateKey privateKey;
        AtomicLoadKeyStore keyStore = null;
        if (keyStoreType != null) {
            keyStore = AtomicLoadKeyStore.newInstance((String)keyStoreType, (Provider)ProviderUtil.findProvider((Supplier)ProviderUtil.INSTALLED_PROVIDERS, null, KeyStore.class, (String)keyStoreType));
        }
        File resolvedPath = null;
        if (keyStorePath != null && keyStorePath.toFile().exists()) {
            try {
                resolvedPath = keyStorePath.toAbsolutePath().toFile();
            }
            catch (IOError | SecurityException e) {
                this.warningHandler(ElytronToolMessages.msg.skippingDescriptorBlockInvalidKeyStorePath(descriptorBlockCount));
                return null;
            }
        }
        if (resolvedPath == null) {
            this.warningHandler(ElytronToolMessages.msg.skippingDescriptorBlockInvalidKeyStorePath(descriptorBlockCount));
            return null;
        }
        try (FileInputStream is = new FileInputStream(resolvedPath);){
            if (keyStoreType != null) {
                keyStore.load((InputStream)is, password);
            } else {
                KeyStore detected = KeyStoreUtil.loadKeyStore((Supplier)ProviderUtil.INSTALLED_PROVIDERS, null, (FileInputStream)is, (String)resolvedPath.getPath(), (char[])password);
                keyStore = AtomicLoadKeyStore.atomize((KeyStore)detected);
            }
        }
        catch (IOException | KeyStoreException e) {
            this.warningHandler(ElytronToolMessages.msg.skippingDescriptorBlockKeyStoreNotLoaded(descriptorBlockCount));
            return null;
        }
        try {
            privateKey = (PrivateKey)keyStore.getKey(keyPairAlias, password);
            publicKeyCert = keyStore.getCertificate(keyPairAlias);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            this.warningHandler(ElytronToolMessages.msg.skippingDescriptorBlockKeyPairFail(descriptorBlockCount));
            return null;
        }
        if (privateKey == null) {
            this.warningHandler(ElytronToolMessages.msg.skippingDescriptorBlockMissingPrivateKey(descriptorBlockCount));
            return null;
        }
        if (publicKeyCert == null) {
            this.warningHandler(ElytronToolMessages.msg.skippingDescriptorBlockMissingPublicKey(descriptorBlockCount));
            return null;
        }
        return new KeyPair(publicKeyCert.getPublicKey(), privateKey);
    }
}

