/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.tool;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.crypto.SecretKey;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.wildfly.security.auth.realm.FileSystemRealmUtil;
import org.wildfly.security.auth.realm.FileSystemSecurityRealm;
import org.wildfly.security.auth.realm.FileSystemSecurityRealmBuilder;
import org.wildfly.security.password.spec.Encoding;
import org.wildfly.security.tool.Command;
import org.wildfly.security.tool.ElytronToolMessages;
import org.wildfly.security.tool.Params;

public class FileSystemRealmIntegrityCommand
extends Command {
    static final String FILE_SYSTEM_REALM_INTEGRITY_COMMAND = "filesystem-realm-integrity";
    static final String DEFAULT_FILESYSTEM_REALM_NAME = "filesystem-realm-with-integrity";
    static final String MISSING = "MISSING";
    private final List<Descriptor> descriptors = new ArrayList<Descriptor>();
    static final List<String> PARAMS_LIST = new ArrayList<String>(Arrays.asList("input-location", "output-location", "keystore", "password", "key-pair", "credential-store", "secret-key"));
    private final Options options = new Options();
    private final CommandLineParser parser = new DefaultParser();
    private boolean silentMode = false;
    private boolean summaryMode = false;
    private final StringBuilder summaryString = new StringBuilder();
    private boolean warningOccurred = false;

    FileSystemRealmIntegrityCommand() {
        this.options.addOption(Option.builder((String)"i").longOpt("input-location").desc(ElytronToolMessages.msg.cmdFileSystemEncryptInputLocationDesc()).hasArg().argName("directory").build());
        this.options.addOption(Option.builder((String)"o").longOpt("output-location").desc(ElytronToolMessages.msg.cmdFileSystemRealmIntegrityOutputLocationDesc()).hasArg().argName("directory").build());
        this.options.addOption(Option.builder((String)"r").longOpt("realm-name").desc(ElytronToolMessages.msg.cmdFileSystemRealmIntegrityNewRealmDesc()).hasArg().argName("name").build());
        this.options.addOption(Option.builder((String)"k").longOpt("keystore").desc(ElytronToolMessages.msg.cmdFileSystemRealmIntegrityKeyStoreDesc()).hasArg().argName("file").build());
        this.options.addOption(Option.builder((String)"t").longOpt("type").desc(ElytronToolMessages.msg.cmdFileSystemRealmIntegrityKeyStoreTypeDesc()).hasArg().argName("name").build());
        this.options.addOptionGroup(new OptionGroup().addOption(Option.builder((String)"p").longOpt("password").desc(ElytronToolMessages.msg.cmdLineKeyStorePassword()).hasArg().argName("password").build()).addOption(Option.builder((String)"pe").longOpt("password-env").desc(ElytronToolMessages.msg.cmdLineKeyStorePasswordEnv()).hasArg().argName("name").build()));
        this.options.addOption(Option.builder((String)"a").longOpt("key-pair").desc(ElytronToolMessages.msg.cmdFileSystemRealmIntegrityKeyPairAliasDesc()).hasArg().argName("name").build());
        this.options.addOption(Option.builder((String)"c").longOpt("credential-store").desc(ElytronToolMessages.msg.cmdFileSystemRealmIntegrityCredentialStoreDesc()).hasArg().argName("file").build());
        this.options.addOption(Option.builder((String)"s").longOpt("secret-key").desc(ElytronToolMessages.msg.cmdFileSystemRealmIntegritySecretKeyDesc()).hasArg().argName("name").build());
        this.options.addOption(Option.builder((String)"l").longOpt("levels").desc(ElytronToolMessages.msg.cmdFileSystemRealmIntegrityLevelsDesc()).hasArg().argName("number").build());
        this.options.addOption(Option.builder((String)"e").longOpt("hash-encoding").desc(ElytronToolMessages.msg.cmdFileSystemRealmIntegrityHashEncodingDesc()).hasArg().argName("name").build());
        this.options.addOption(Option.builder((String)"u").longOpt("hash-charset").desc(ElytronToolMessages.msg.cmdFileSystemRealmIntegrityHashCharsetDesc()).hasArg().argName("name").build());
        this.options.addOption(Option.builder((String)"f").longOpt("encoded").desc(ElytronToolMessages.msg.cmdFileSystemRealmIntegrityEncodedDesc()).hasArg().argName("true/false").build());
        this.options.addOption(Option.builder((String)"b").longOpt("bulk-convert").desc(ElytronToolMessages.msg.cmdFileSystemRealmIntegrityBulkConvertDesc()).hasArg().argName("file").build());
        this.options.addOption(Option.builder((String)"h").longOpt("help").desc(ElytronToolMessages.msg.cmdLineHelp()).build());
        this.options.addOption(Option.builder((String)"d").longOpt("debug").desc(ElytronToolMessages.msg.cmdLineDebug()).build());
        this.options.addOption(Option.builder().longOpt("silent").desc(ElytronToolMessages.msg.cmdFileSystemRealmSilentDesc()).build());
        this.options.addOption(Option.builder().longOpt("summary").desc(ElytronToolMessages.msg.cmdFileSystemRealmSummaryDesc()).build());
    }

    @Override
    public void execute(String[] args) throws Exception {
        this.setStatus(7);
        CommandLine cmdLine = this.parser.parse(this.options, args, false);
        this.setEnableDebug(cmdLine.hasOption("debug"));
        if (cmdLine.hasOption("help")) {
            this.help();
            this.setStatus(0);
            return;
        }
        if (cmdLine.hasOption("silent")) {
            this.silentMode = true;
        }
        if (cmdLine.hasOption("summary")) {
            this.summaryMode = true;
            this.summaryString.append(Params.SUMMARY_DIVIDER);
            this.summaryString.append(Params.LINE_SEPARATOR);
            this.summaryString.append("Summary for execution of Elytron Tool command filesystem-realm-integrity");
            this.summaryString.append(Params.LINE_SEPARATOR);
            this.summaryString.append(Params.SUMMARY_DIVIDER);
            this.summaryString.append(Params.LINE_SEPARATOR);
        }
        this.printDuplicatesWarning(cmdLine);
        String inputRealmPathOption = cmdLine.getOptionValue("i");
        String outputRealmPathOption = cmdLine.getOptionValue("o");
        String realmNameOption = cmdLine.getOptionValue("r");
        String keyStorePathOption = cmdLine.getOptionValue("k");
        String keyStoreTypeOption = cmdLine.getOptionValue("t");
        String passwordOption = cmdLine.getOptionValue("p");
        String passwordEnvOption = cmdLine.getOptionValue("pe");
        String keyPairAliasOption = cmdLine.getOptionValue("a");
        String credentialStorePathOption = cmdLine.getOptionValue("c");
        String secretKeyAliasOption = cmdLine.getOptionValue("s");
        String levelsOption = cmdLine.getOptionValue("l");
        String hashEncodingOption = cmdLine.getOptionValue("e");
        String hashCharsetOption = cmdLine.getOptionValue("u");
        String encodedOption = cmdLine.getOptionValue("f");
        String bulkConvertOption = cmdLine.getOptionValue("b");
        if (bulkConvertOption == null) {
            if (this.summaryMode) {
                this.summaryString.append("Options were specified via CLI, converting single users-roles combination");
                this.summaryString.append(Params.LINE_SEPARATOR);
            }
            Descriptor descriptor = new Descriptor();
            if (inputRealmPathOption == null) {
                this.errorHandler((Exception)ElytronToolMessages.msg.inputLocationNotSpecified());
            } else {
                Path inputPath = Paths.get(inputRealmPathOption, new String[0]).normalize().toAbsolutePath();
                if (Files.notExists(inputPath, new LinkOption[0])) {
                    this.errorHandler((Exception)ElytronToolMessages.msg.inputLocationDoesNotExist());
                }
                descriptor.setInputRealmPath(inputPath);
            }
            if (outputRealmPathOption != null) {
                Path outputPath = Paths.get(outputRealmPathOption, new String[0]).normalize().toAbsolutePath();
                Files.createDirectories(outputPath, new FileAttribute[0]);
                descriptor.setOutputRealmPath(outputPath);
            }
            if (realmNameOption != null) {
                descriptor.setFileSystemRealmName(realmNameOption);
            } else {
                descriptor.setFileSystemRealmName(DEFAULT_FILESYSTEM_REALM_NAME);
            }
            if (keyStorePathOption == null) {
                throw ElytronToolMessages.msg.keyStorePathNotSpecified();
            }
            Path keyStorePath = Paths.get(keyStorePathOption, new String[0]);
            if (Files.notExists(keyStorePath, new LinkOption[0])) {
                throw ElytronToolMessages.msg.keyStoreDoesNotExist();
            }
            descriptor.setKeyStorePath(keyStorePath);
            descriptor.setKeyStoreType(keyStoreTypeOption);
            if (passwordOption == null && passwordEnvOption == null) {
                passwordOption = this.prompt(false, ElytronToolMessages.msg.keyStorePasswordPrompt(), false, null);
                if (passwordOption == null) {
                    throw ElytronToolMessages.msg.optionNotSpecified("password or password-env");
                }
            } else if (passwordEnvOption != null) {
                descriptor.setPasswordEnv(passwordEnvOption);
                passwordOption = System.getenv(passwordEnvOption);
            }
            descriptor.setPassword(passwordOption);
            descriptor.setKeyPairAlias(keyPairAliasOption);
            if (credentialStorePathOption != null) {
                Path credentialStorePath = Paths.get(credentialStorePathOption, new String[0]);
                descriptor.setCredentialStorePath(credentialStorePath);
            }
            descriptor.setSecretKeyAlias(secretKeyAliasOption);
            if (levelsOption != null) {
                try {
                    descriptor.setLevels(levelsOption);
                }
                catch (NumberFormatException e) {
                    this.errorHandler(e);
                }
            }
            if (hashEncodingOption == null) {
                descriptor.setHashEncoding(Encoding.BASE64);
            } else {
                try {
                    descriptor.setHashEncoding(hashEncodingOption);
                }
                catch (IllegalArgumentException e) {
                    this.errorHandler(e);
                }
            }
            if (hashCharsetOption == null) {
                descriptor.setHashCharset(StandardCharsets.UTF_8);
            } else {
                try {
                    descriptor.setHashCharset(hashCharsetOption);
                }
                catch (IllegalArgumentException e) {
                    this.errorHandler(e);
                }
            }
            if (encodedOption == null) {
                descriptor.setEncoded(true);
            } else {
                if (!Params.BOOLEAN_ARG_REGEX.matcher(encodedOption).find()) {
                    throw ElytronToolMessages.msg.encodedMustBeBoolean();
                }
                descriptor.setEncoded(Boolean.parseBoolean(encodedOption));
            }
            this.descriptors.add(descriptor);
            this.findMissingRequiredValuesAndSetValues(0, descriptor);
        } else {
            if (this.nonBulkConvertOptionSet(inputRealmPathOption, outputRealmPathOption, realmNameOption, keyStorePathOption, keyStoreTypeOption, passwordOption, passwordEnvOption, keyPairAliasOption, credentialStorePathOption, secretKeyAliasOption, levelsOption, hashEncodingOption, hashCharsetOption, encodedOption)) {
                throw ElytronToolMessages.msg.mutuallyExclusiveOptionsIntegritySpecified();
            }
            if (this.summaryMode) {
                this.summaryString.append(String.format("Options were specified via descriptor file: %s, converting multiple old filesystem realm", bulkConvertOption));
                this.summaryString.append(Params.LINE_SEPARATOR);
            }
            this.parseDescriptorFile(bulkConvertOption);
        }
        this.upgradeFileSystemRealm();
        this.createWildFlyScript();
        if (this.summaryMode) {
            this.summaryString.append(Params.SUMMARY_DIVIDER);
            this.summaryString.append(Params.LINE_SEPARATOR);
            this.summaryString.append("End of summary");
            this.summaryString.append(Params.LINE_SEPARATOR);
            this.summaryString.append(Params.SUMMARY_DIVIDER);
            System.out.println(this.summaryString);
        }
        if (this.warningOccurred) {
            this.setStatus(1);
        } else {
            this.setStatus(0);
        }
    }

    @Override
    public void help() {
        HelpFormatter help = new HelpFormatter();
        help.setWidth(1024);
        help.printHelp(ElytronToolMessages.msg.cmdHelp(this.getToolCommand(), FILE_SYSTEM_REALM_INTEGRITY_COMMAND), ElytronToolMessages.msg.cmdFileSystemIntegrityHelpHeader(), this.options, "", true);
    }

    @Override
    protected void warningHandler(String warning) {
        this.warningOccurred = true;
        if (!this.silentMode) {
            System.out.print("WARNING: ");
            System.out.println(warning);
        }
        if (this.summaryMode) {
            this.summaryString.append("WARNING: ");
            this.summaryString.append(warning);
            this.summaryString.append(Params.LINE_SEPARATOR);
        }
    }

    @Override
    protected void errorHandler(Exception e) throws Exception {
        this.setStatus(7);
        if (this.summaryMode) {
            this.summaryString.append("Error was thrown during execution:");
            this.summaryString.append(Params.LINE_SEPARATOR);
            this.summaryString.append(e.getMessage());
            System.out.println(Params.LINE_SEPARATOR + this.summaryString);
        }
        throw e;
    }

    private void printDescriptorBlocks(int count) {
        this.summaryString.append(Params.LINE_SEPARATOR);
        this.summaryString.append(Params.LINE_SEPARATOR);
        this.summaryString.append("Found following filesystem realm combinations - MISSING indicates missing required parameter:");
        this.summaryString.append(Params.LINE_SEPARATOR);
        for (int i = 0; i < count; ++i) {
            StringBuilder summary = new StringBuilder();
            summary.append("\tPrinting summary for block ");
            summary.append(i + 1);
            summary.append(Params.LINE_SEPARATOR);
            Descriptor descriptor = this.descriptors.get(i);
            for (String param : PARAMS_LIST) {
                String paramValue = descriptor.getString(param);
                summary.append("\t\t");
                summary.append(param);
                summary.append(" - ");
                if (param.equals("password")) {
                    summary.append(this.printPasswordSummary(paramValue));
                } else {
                    summary.append(descriptor.getString(param));
                }
                summary.append(Params.LINE_SEPARATOR);
            }
            this.summaryString.append((CharSequence)summary);
        }
        this.summaryString.append(Params.LINE_SEPARATOR);
    }

    private String printPasswordSummary(String paramValue) {
        if (paramValue == null) {
            return null;
        }
        if (paramValue.equals(MISSING)) {
            return MISSING;
        }
        return "<masked>";
    }

    private boolean nonBulkConvertOptionSet(String ... optionValues) {
        return Arrays.stream(optionValues).anyMatch(Objects::nonNull);
    }

    private void parseDescriptorFile(String file) throws Exception {
        Path path = Paths.get(file, new String[0]);
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            this.errorHandler(ElytronToolMessages.msg.fileNotFound(file));
        }
        Descriptor descriptor = new Descriptor();
        AtomicInteger count = new AtomicInteger(1);
        try (Stream<String> stream = Files.lines(path);){
            stream.forEach(line -> {
                if (line.isEmpty()) {
                    if (descriptor.getPasswordEnv() != null) {
                        descriptor.setPassword(System.getenv(descriptor.getPasswordEnv()));
                    }
                    this.copyAddResetDescriptor(count.intValue(), descriptor);
                    count.getAndIncrement();
                } else {
                    String[] parts = line.split(":");
                    String option = parts[0];
                    String arg = parts[1];
                    switch (option) {
                        case "input-location": {
                            descriptor.setInputRealmPath(arg);
                            break;
                        }
                        case "output-location": {
                            descriptor.setOutputRealmPath(arg);
                            break;
                        }
                        case "realm-name": {
                            descriptor.setFileSystemRealmName(arg);
                            break;
                        }
                        case "keystore": {
                            descriptor.setKeyStorePath(arg);
                            break;
                        }
                        case "type": {
                            descriptor.setKeyStoreType(arg);
                            break;
                        }
                        case "password": {
                            descriptor.setPassword(arg);
                            break;
                        }
                        case "password-env": {
                            descriptor.setPasswordEnv(arg);
                            break;
                        }
                        case "key-pair": {
                            descriptor.setKeyPairAlias(arg);
                            break;
                        }
                        case "credential-store": {
                            descriptor.setCredentialStorePath(arg);
                            break;
                        }
                        case "secret-key": {
                            descriptor.setSecretKeyAlias(arg);
                            break;
                        }
                        case "levels": {
                            descriptor.setLevels(arg);
                            break;
                        }
                        case "hash-encoding": {
                            descriptor.setHashEncoding(arg);
                            break;
                        }
                        case "hash-charset": {
                            descriptor.setHashCharset(arg);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            this.errorHandler(e);
        }
        this.copyAddResetDescriptor(count.intValue(), descriptor);
        if (this.summaryMode) {
            this.printDescriptorBlocks(count.intValue());
        }
        count.getAndIncrement();
    }

    private void copyAddResetDescriptor(int count, Descriptor original) {
        this.findMissingRequiredValuesAndSetValues(count, original);
        this.descriptors.add(new Descriptor(original));
        original.reset(true);
    }

    private void findMissingRequiredValuesAndSetValues(int count, Descriptor descriptor) {
        if (descriptor.getInputRealmPath() == null) {
            this.warningHandler(ElytronToolMessages.msg.skippingDescriptorBlockInputLocation(count));
            descriptor.setInputRealmPath(MISSING);
            descriptor.setMissingRequiredValue();
        }
        if (descriptor.getKeyStorePath() == null) {
            this.warningHandler(ElytronToolMessages.msg.skippingDescriptorBlockKeyStorePath(count));
            descriptor.setKeyStorePath(MISSING);
            descriptor.setMissingRequiredValue();
        }
        if (descriptor.getPassword() == null) {
            this.warningHandler(ElytronToolMessages.msg.skippingDescriptorBlockPassword(count));
            descriptor.setPassword(MISSING);
            descriptor.setMissingRequiredValue();
        }
        if (descriptor.getFileSystemRealmName() == null) {
            if (count == 0) {
                descriptor.setFileSystemRealmName(DEFAULT_FILESYSTEM_REALM_NAME);
            } else {
                descriptor.setFileSystemRealmName("filesystem-realm-with-integrity-" + UUID.randomUUID());
            }
        }
        if (descriptor.getKeyPairAlias() == null) {
            descriptor.setKeyPairAlias("integrity-key");
        }
        if (descriptor.getLevels() == null) {
            descriptor.setLevels(Params.DEFAULT_LEVELS);
        }
        if (descriptor.getHashEncoding() == null) {
            descriptor.setHashEncoding(Encoding.BASE64);
        }
        if (descriptor.getHashCharset() == null) {
            descriptor.setHashCharset(StandardCharsets.UTF_8);
        }
        if (descriptor.getEncoded() == null) {
            descriptor.setEncoded(true);
        }
        if (descriptor.getOutputRealmPath() == null) {
            descriptor.setUpgradeInPlace(true);
        }
        if (descriptor.getMissingRequiredValue().booleanValue()) {
            descriptor.reset(false);
        }
    }

    private void upgradeFileSystemRealm() throws Exception {
        int count = 0;
        for (Descriptor descriptor : this.descriptors) {
            FileSystemSecurityRealm inputRealm;
            ++count;
            if (descriptor.getMissingRequiredValue().booleanValue()) {
                this.warningHandler(ElytronToolMessages.msg.skippingDescriptorBlock(count, "missing required parameter"));
                continue;
            }
            System.out.println(ElytronToolMessages.msg.fileSystemRealmIntegrityCreatingRealm(descriptor.getString("input-location")));
            KeyPair keyPair = this.getKeyPair(descriptor.getKeyStorePath(), descriptor.getKeyStoreType(), descriptor.getKeyPairAlias(), descriptor.getPassword(), count);
            if (keyPair == null) continue;
            Path inputPath = descriptor.getInputRealmPath();
            Path outputPath = descriptor.getOutputRealmPath();
            if (inputPath == null) {
                this.warningHandler(ElytronToolMessages.msg.skippingDescriptorBlockInputLocation(count));
                continue;
            }
            if (descriptor.getUpgradeInPlace().booleanValue()) {
                Path backupPath = this.backupInputFileSystemRealm(descriptor, count);
                if (backupPath == null) {
                    outputPath = Paths.get(inputPath.toString().replaceFirst(Pattern.quote(Params.FILE_SEPARATOR + "*$"), "") + "-with-integrity", new String[0]);
                    descriptor.setUpgradeInPlace(false);
                    this.warningHandler(ElytronToolMessages.msg.unableToUpgradeInPlace(inputPath.toString(), outputPath.toString()));
                } else {
                    outputPath = inputPath;
                    inputPath = backupPath;
                }
                descriptor.setOutputRealmPath(outputPath);
            } else {
                outputPath = outputPath.resolve(descriptor.getFileSystemRealmName());
            }
            FileSystemSecurityRealmBuilder inputFileSystemRealmBuilder = FileSystemSecurityRealm.builder().setRoot(inputPath).setLevels(descriptor.getLevels().intValue()).setHashEncoding(descriptor.getHashEncoding()).setHashCharset(descriptor.getHashCharset()).setEncoded(descriptor.getEncoded().booleanValue()).setProviders(ELYTRON_KS_PASS_PROVIDERS);
            FileSystemSecurityRealmBuilder outputFileSystemRealmBuilder = FileSystemSecurityRealm.builder().setRoot(outputPath).setPrivateKey(keyPair.getPrivate()).setPublicKey(keyPair.getPublic()).setLevels(descriptor.getLevels().intValue()).setHashCharset(descriptor.getHashCharset()).setProviders(ELYTRON_KS_PASS_PROVIDERS);
            if (descriptor.getCredentialStorePath() != null) {
                SecretKey secretKey = this.getSecretKey(false, descriptor.getString("credential-store"), descriptor.getSecretKeyAlias(), false, count);
                if (secretKey == null) continue;
                inputFileSystemRealmBuilder.setSecretKey(secretKey);
                outputFileSystemRealmBuilder.setSecretKey(secretKey);
            }
            if (!(inputRealm = inputFileSystemRealmBuilder.build()).getRealmIdentityIterator().hasNext()) {
                this.warningHandler(ElytronToolMessages.msg.skippingDescriptorBlockEmptyRealm(count));
                continue;
            }
            FileSystemRealmUtil.cloneIdentitiesToNewRealm((FileSystemSecurityRealm)inputRealm, (FileSystemSecurityRealm)outputFileSystemRealmBuilder.build());
            descriptor.setRealmUpgraded();
        }
    }

    private void createWildFlyScript() throws Exception {
        int counter = 0;
        for (Descriptor descriptor : this.descriptors) {
            boolean overwriteScript;
            ++counter;
            if (!descriptor.getRealmUpgraded().booleanValue()) continue;
            String fileSystemRealmName = descriptor.getFileSystemRealmName();
            Path outputRealmPath = descriptor.getOutputRealmPath();
            boolean upgradeInPlace = descriptor.getUpgradeInPlace();
            String createScriptCheck = "";
            Path scriptPath = Paths.get(String.format("%s/%s.cli", outputRealmPath, fileSystemRealmName), new String[0]);
            if (scriptPath.toFile().exists() && (createScriptCheck = this.prompt(true, ElytronToolMessages.msg.shouldFileBeOverwritten(scriptPath.toString()), false, null)).trim().isEmpty()) {
                createScriptCheck = "n";
            }
            boolean bl = overwriteScript = createScriptCheck.isEmpty() || createScriptCheck.toLowerCase().startsWith("y");
            if (!overwriteScript) {
                while ((scriptPath = Paths.get(String.format("%s/%s.cli", outputRealmPath, fileSystemRealmName + "-" + UUID.randomUUID()), new String[0])).toFile().exists()) {
                }
            }
            if (this.summaryMode) {
                this.summaryString.append(String.format("Configured script for WildFly named %s.cli at %s.", fileSystemRealmName, outputRealmPath));
                this.summaryString.append(Params.LINE_SEPARATOR);
                this.summaryString.append(String.format("Name of filesystem-realm: %s", fileSystemRealmName));
                this.summaryString.append(Params.LINE_SEPARATOR);
            }
            ArrayList<String> scriptLines = new ArrayList<String>(Arrays.asList(String.format("/subsystem=elytron/key-store=%s:add(path=%s, credential-reference={clear-text=\"%s\"}%s)", "mykeystore" + counter, descriptor.getKeyStorePath(), descriptor.getString("password"), descriptor.getKeyStoreType() != null ? ", type=" + descriptor.getKeyStoreType() : ""), String.format("/subsystem=elytron/filesystem-realm=%s:add(path=%s%s%s, key-store=%s, key-store-alias=%s%s%s)", fileSystemRealmName, upgradeInPlace ? outputRealmPath : outputRealmPath.toString() + Params.FILE_SEPARATOR + fileSystemRealmName, descriptor.getCredentialStorePath() != null ? ", credential-store=mycredstore" + counter : "", descriptor.getSecretKeyAlias() != null ? ", secret-key=" + descriptor.getSecretKeyAlias() : "", "mykeystore" + counter, descriptor.getKeyPairAlias(), !descriptor.getLevels().equals(Params.DEFAULT_LEVELS) ? ", levels=" + descriptor.getLevels() : "", descriptor.getHashCharset() != StandardCharsets.UTF_8 ? ", hash-charset=" + descriptor.getHashCharset() : "")));
            if (descriptor.getCredentialStorePath() != null) {
                scriptLines.add(1, String.format("/subsystem=elytron/secret-key-credential-store=%s:add(path=%s)", "mycredstore" + counter, descriptor.getCredentialStorePath()));
            }
            if (overwriteScript) {
                Files.write(scriptPath, scriptLines, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                continue;
            }
            Files.write(scriptPath, scriptLines, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
    }

    private Path backupInputFileSystemRealm(Descriptor descriptor, int count) throws Exception {
        final Path originalDirectory = descriptor.getInputRealmPath();
        Path backupDirectory = Paths.get(descriptor.getString("input-location").replaceFirst(Pattern.quote(Params.FILE_SEPARATOR + "*$"), "") + "-backup", new String[0]);
        if (backupDirectory.toFile().exists()) {
            Path numBackupDirectory;
            while ((numBackupDirectory = Paths.get(backupDirectory + "-" + UUID.randomUUID(), new String[0])).toFile().exists()) {
            }
            backupDirectory = numBackupDirectory;
        }
        try {
            final Path finalBackupDirectory = backupDirectory;
            Files.walkFileTree(originalDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    Files.createDirectories(finalBackupDirectory.resolve(originalDirectory.relativize(dir)), new FileAttribute[0]);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.copy(file, finalBackupDirectory.resolve(originalDirectory.relativize(file)), new CopyOption[0]);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException | RuntimeException e) {
            return null;
        }
        try {
            Files.walkFileTree(originalDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.toFile().delete()) {
                        return FileVisitResult.CONTINUE;
                    }
                    throw new IOException("Unable to delete " + file);
                }
            });
        }
        catch (IOException | RuntimeException e) {
            this.errorHandler(e);
        }
        System.out.println(ElytronToolMessages.msg.fileSystemRealmIntegrityInPlaceBackup(count, backupDirectory.toString()));
        return backupDirectory;
    }

    private static final class Descriptor {
        private Path inputRealmPath;
        private Path outputRealmPath;
        private String fileSystemRealmName;
        private Path keyStorePath;
        private String keyStoreType;
        private char[] password;
        private String passwordEnv;
        private String keyPairAlias;
        private Path credentialStorePath;
        private String secretKeyAlias;
        private Integer levels;
        private Encoding hashEncoding;
        private Charset hashCharset;
        private Boolean encoded;
        private Boolean upgradeInPlace;
        private Boolean missingRequiredValue;
        private Boolean realmUpgraded;

        Descriptor() {
            this.upgradeInPlace = false;
            this.missingRequiredValue = false;
            this.realmUpgraded = false;
        }

        Descriptor(Descriptor descriptor) {
            this.inputRealmPath = descriptor.inputRealmPath;
            this.outputRealmPath = descriptor.outputRealmPath;
            this.fileSystemRealmName = descriptor.fileSystemRealmName;
            this.keyStorePath = descriptor.keyStorePath;
            this.keyStoreType = descriptor.keyStoreType;
            this.password = descriptor.password;
            this.passwordEnv = descriptor.passwordEnv;
            this.keyPairAlias = descriptor.keyPairAlias;
            this.credentialStorePath = descriptor.credentialStorePath;
            this.secretKeyAlias = descriptor.secretKeyAlias;
            this.levels = descriptor.levels;
            this.hashEncoding = descriptor.hashEncoding;
            this.hashCharset = descriptor.hashCharset;
            this.encoded = descriptor.encoded;
            this.upgradeInPlace = descriptor.upgradeInPlace;
            this.missingRequiredValue = descriptor.missingRequiredValue;
            this.realmUpgraded = descriptor.realmUpgraded;
        }

        public String getString(String param) {
            switch (param) {
                case "input-location": {
                    if (this.inputRealmPath == null) {
                        return null;
                    }
                    if (this.inputRealmPath.endsWith(FileSystemRealmIntegrityCommand.MISSING)) {
                        return FileSystemRealmIntegrityCommand.MISSING;
                    }
                    return this.inputRealmPath.toString();
                }
                case "output-location": {
                    return this.outputRealmPath != null ? this.outputRealmPath.toString() : null;
                }
                case "realm-name": {
                    return this.fileSystemRealmName;
                }
                case "keystore": {
                    if (this.keyStorePath == null) {
                        return null;
                    }
                    if (this.keyStorePath.endsWith(FileSystemRealmIntegrityCommand.MISSING)) {
                        return FileSystemRealmIntegrityCommand.MISSING;
                    }
                    return this.keyStorePath.toString();
                }
                case "type": {
                    return this.keyStoreType;
                }
                case "password": {
                    return this.password != null ? new String(this.password) : null;
                }
                case "password-env": {
                    return this.passwordEnv;
                }
                case "key-pair": {
                    return this.keyPairAlias;
                }
                case "credential-store": {
                    return this.credentialStorePath != null ? this.credentialStorePath.toString() : null;
                }
                case "secret-key": {
                    return this.secretKeyAlias;
                }
                case "levels": {
                    return this.levels != null ? this.levels.toString() : null;
                }
                case "hash-encoding": {
                    return this.hashEncoding != null ? this.hashEncoding.name() : null;
                }
                case "hash-charset": {
                    return this.hashCharset != null ? this.hashCharset.name() : null;
                }
                case "encoded": {
                    return this.encoded != null ? this.encoded.toString() : null;
                }
            }
            return null;
        }

        public Path getInputRealmPath() {
            return this.inputRealmPath;
        }

        public Path getOutputRealmPath() {
            return this.outputRealmPath;
        }

        public String getFileSystemRealmName() {
            return this.fileSystemRealmName;
        }

        public Path getKeyStorePath() {
            return this.keyStorePath;
        }

        public String getKeyStoreType() {
            return this.keyStoreType;
        }

        public char[] getPassword() {
            return this.password;
        }

        public String getPasswordEnv() {
            return this.passwordEnv;
        }

        public String getKeyPairAlias() {
            return this.keyPairAlias;
        }

        public Path getCredentialStorePath() {
            return this.credentialStorePath;
        }

        public String getSecretKeyAlias() {
            return this.secretKeyAlias;
        }

        public Integer getLevels() {
            return this.levels;
        }

        public Encoding getHashEncoding() {
            return this.hashEncoding;
        }

        public Charset getHashCharset() {
            return this.hashCharset;
        }

        public Boolean getEncoded() {
            return this.encoded;
        }

        public Boolean getUpgradeInPlace() {
            return this.upgradeInPlace;
        }

        public Boolean getMissingRequiredValue() {
            return this.missingRequiredValue;
        }

        public Boolean getRealmUpgraded() {
            return this.realmUpgraded;
        }

        public void setInputRealmPath(String inputRealmPath) {
            this.setInputRealmPath(Paths.get(inputRealmPath, new String[0]).normalize().toAbsolutePath());
        }

        public void setInputRealmPath(Path inputRealmPath) {
            this.inputRealmPath = inputRealmPath.normalize().toAbsolutePath();
        }

        public void setOutputRealmPath(String outputRealmPath) {
            this.setOutputRealmPath(Paths.get(outputRealmPath, new String[0]).normalize().toAbsolutePath());
        }

        public void setOutputRealmPath(Path outputRealmPath) {
            this.outputRealmPath = outputRealmPath.normalize().toAbsolutePath();
        }

        public void setFileSystemRealmName(String fileSystemRealmName) {
            this.fileSystemRealmName = fileSystemRealmName;
        }

        public void setKeyStorePath(String keyStorePath) {
            this.setKeyStorePath(Paths.get(keyStorePath, new String[0]).normalize().toAbsolutePath());
        }

        public void setKeyStorePath(Path keyStorePath) {
            this.keyStorePath = keyStorePath.normalize().toAbsolutePath();
        }

        public void setKeyStoreType(String keyStoreType) {
            this.keyStoreType = keyStoreType;
        }

        public void setPassword(String password) {
            if (password != null) {
                this.setPassword(password.toCharArray());
            } else {
                this.setPassword((char[])null);
            }
        }

        public void setPassword(char[] password) {
            this.password = password;
        }

        public void setPasswordEnv(String passwordEnv) {
            this.passwordEnv = passwordEnv;
        }

        public void setKeyPairAlias(String keyPairAlias) {
            this.keyPairAlias = keyPairAlias;
        }

        public void setCredentialStorePath(String credentialStorePath) {
            this.setCredentialStorePath(Paths.get(credentialStorePath, new String[0]).normalize().toAbsolutePath());
        }

        public void setCredentialStorePath(Path credentialStorePath) {
            this.credentialStorePath = credentialStorePath.normalize().toAbsolutePath();
        }

        public void setSecretKeyAlias(String secretKeyAlias) {
            this.secretKeyAlias = secretKeyAlias;
        }

        public void setLevels(String levels) throws NumberFormatException {
            this.setLevels(Integer.parseInt(levels));
        }

        public void setLevels(Integer levels) {
            this.levels = levels;
        }

        public void setHashEncoding(String hashEncoding) throws IllegalArgumentException {
            this.setHashEncoding(Encoding.valueOf((String)hashEncoding.toUpperCase()));
        }

        public void setHashEncoding(Encoding hashEncoding) {
            this.hashEncoding = hashEncoding;
        }

        public void setHashCharset(String hashCharset) {
            this.setHashCharset(Charset.forName(hashCharset.toUpperCase()));
        }

        public void setHashCharset(Charset hashCharset) {
            this.hashCharset = hashCharset;
        }

        public void setEncoded(String encoded) throws IllegalArgumentException {
            if (!Params.BOOLEAN_ARG_REGEX.matcher(encoded).find()) {
                throw ElytronToolMessages.msg.encodedMustBeBoolean();
            }
            this.setEncoded(Boolean.parseBoolean(encoded));
        }

        public void setEncoded(Boolean encoded) {
            this.encoded = encoded;
        }

        public void setUpgradeInPlace(Boolean upgradeInPlace) {
            this.upgradeInPlace = upgradeInPlace;
        }

        public void setMissingRequiredValue() {
            this.missingRequiredValue = true;
        }

        public void setRealmUpgraded() {
            this.realmUpgraded = true;
        }

        void reset(boolean resetMissingValues) {
            if (!Objects.equals(this.getString("input-location"), FileSystemRealmIntegrityCommand.MISSING)) {
                this.inputRealmPath = null;
            }
            if (!Objects.equals(this.getString("keystore"), FileSystemRealmIntegrityCommand.MISSING)) {
                this.keyStorePath = null;
            }
            if (!Objects.equals(this.getString("password"), FileSystemRealmIntegrityCommand.MISSING)) {
                this.password = null;
            }
            this.outputRealmPath = null;
            this.fileSystemRealmName = null;
            this.keyStoreType = null;
            this.passwordEnv = null;
            this.keyPairAlias = null;
            this.credentialStorePath = null;
            this.secretKeyAlias = null;
            this.levels = null;
            this.hashEncoding = null;
            this.hashCharset = null;
            this.encoded = null;
            this.upgradeInPlace = false;
            this.realmUpgraded = false;
            if (resetMissingValues) {
                this.missingRequiredValue = false;
            }
        }
    }
}

