/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.impl;

import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.credential._private.ElytronMessages;
import org.wildfly.security.password.impl.AbstractPasswordImpl;
import org.wildfly.security.password.impl.DigestUtil;
import org.wildfly.security.password.interfaces.DigestPassword;
import org.wildfly.security.password.spec.DigestPasswordAlgorithmSpec;
import org.wildfly.security.password.spec.DigestPasswordSpec;
import org.wildfly.security.password.spec.EncryptablePasswordSpec;

class DigestPasswordImpl
extends AbstractPasswordImpl
implements DigestPassword {
    private static final long serialVersionUID = -8454721263222529136L;
    private final String algorithm;
    private final String username;
    private final String realm;
    private final byte[] digest;

    DigestPasswordImpl(String algorithm, String username, String realm, byte[] digest) {
        this.algorithm = algorithm;
        this.username = username;
        this.realm = realm;
        this.digest = digest;
    }

    DigestPasswordImpl(String algorithm, DigestPasswordSpec spec) {
        this(algorithm, spec.getUsername(), spec.getRealm(), (byte[])spec.getDigest().clone());
    }

    DigestPasswordImpl(DigestPassword password) {
        this(password.getAlgorithm(), password.getUsername(), password.getRealm(), (byte[])password.getDigest().clone());
    }

    DigestPasswordImpl(String algorithm, EncryptablePasswordSpec spec) throws InvalidKeySpecException {
        this(algorithm, spec.getPassword(), (DigestPasswordAlgorithmSpec)spec.getAlgorithmParameterSpec());
    }

    DigestPasswordImpl(String algorithm, char[] password, DigestPasswordAlgorithmSpec spec) throws InvalidKeySpecException {
        this.algorithm = algorithm;
        this.username = spec.getUsername();
        this.realm = spec.getRealm();
        try {
            this.digest = DigestUtil.userRealmPasswordDigest(DigestPasswordImpl.getMessageDigest(algorithm), spec.getUsername(), spec.getRealm(), password);
        }
        catch (NoSuchAlgorithmException e) {
            throw ElytronMessages.log.invalidKeySpecNoSuchMessageDigestAlgorithm(algorithm);
        }
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getRealm() {
        return this.realm;
    }

    @Override
    public byte[] getDigest() {
        return (byte[])this.digest.clone();
    }

    @Override
    <S extends KeySpec> S getKeySpec(Class<S> keySpecType) throws InvalidKeySpecException {
        if (keySpecType.isAssignableFrom(DigestPasswordSpec.class)) {
            return (S)((KeySpec)keySpecType.cast(new DigestPasswordSpec(this.username, this.realm, (byte[])this.digest.clone())));
        }
        throw new InvalidKeySpecException();
    }

    @Override
    boolean verify(char[] guess) throws InvalidKeyException {
        try {
            byte[] guessDigest = DigestUtil.userRealmPasswordDigest(DigestPasswordImpl.getMessageDigest(this.algorithm), this.username, this.realm, guess);
            return Arrays.equals(this.digest, guessDigest);
        }
        catch (NoSuchAlgorithmException e) {
            throw ElytronMessages.log.invalidKeyNoSuchMessageDigestAlgorithm(this.algorithm);
        }
    }

    @Override
    <T extends KeySpec> boolean convertibleTo(Class<T> keySpecType) {
        return keySpecType.isAssignableFrom(DigestPasswordSpec.class);
    }

    private static MessageDigest getMessageDigest(String algorithm) throws NoSuchAlgorithmException {
        switch (algorithm) {
            case "digest-md5": {
                return MessageDigest.getInstance("MD5");
            }
            case "digest-sha": {
                return MessageDigest.getInstance("SHA-1");
            }
            case "digest-sha-256": {
                return MessageDigest.getInstance("SHA-256");
            }
            case "digest-sha-384": {
                return MessageDigest.getInstance("SHA-384");
            }
            case "digest-sha-512": {
                return MessageDigest.getInstance("SHA-512");
            }
            case "digest-sha-512-256": {
                return MessageDigest.getInstance("SHA-512-256");
            }
        }
        throw ElytronMessages.log.noSuchAlgorithmInvalidAlgorithm(algorithm);
    }

    @Override
    public int hashCode() {
        return HashMath.multiHashOrdered(HashMath.multiHashOrdered(HashMath.multiHashOrdered(Arrays.hashCode(this.digest), this.username.hashCode()), this.realm.hashCode()), this.algorithm.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof DigestPasswordImpl)) {
            return false;
        }
        DigestPasswordImpl other = (DigestPasswordImpl)obj;
        return Arrays.equals(this.digest, other.digest) && this.username.equals(other.username) && this.realm.equals(other.realm) && this.algorithm.equals(other.algorithm);
    }

    private void readObject(ObjectInputStream ignored) throws NotSerializableException {
        throw new NotSerializableException();
    }

    Object writeReplace() {
        return DigestPassword.createRaw(this.algorithm, this.username, this.realm, this.digest);
    }

    @Override
    public DigestPasswordImpl clone() {
        return this;
    }
}

