/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import java.io.InputStream;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CRL;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import org.wildfly.common.Assert;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.x500.X500;

public final class X509CRLExtendedTrustManager
extends X509ExtendedTrustManager {
    private static final int DEFAULT_MAX_CERT_PATH_LENGTH = 5;
    private final X509TrustManager trustManager;
    private final X509Certificate[] acceptedIssuers;

    public X509CRLExtendedTrustManager(KeyStore trustStore, TrustManagerFactory trustManagerFactory, InputStream crlStream, int maxCertPath, X509Certificate[] acceptedIssuers) {
        Assert.checkNotNullParam("trustStore", trustStore);
        Assert.checkNotNullParam("trustManagerFactory", trustManagerFactory);
        Assert.checkMinimumParameter("maxCertPath", 1, maxCertPath);
        try {
            PKIXBuilderParameters params = new PKIXBuilderParameters(trustStore, (CertSelector)new X509CertSelector());
            if (crlStream != null) {
                CollectionCertStoreParameters csp = new CollectionCertStoreParameters(this.getCRLs(crlStream));
                CertStore store = CertStore.getInstance("Collection", csp);
                params.addCertStore(store);
            }
            params.setRevocationEnabled(true);
            params.setMaxPathLength(maxCertPath);
            trustManagerFactory.init(new CertPathTrustManagerParameters(params));
            X509TrustManager[] trustManagers = (X509TrustManager[])Stream.of(trustManagerFactory.getTrustManagers()).map(trustManager -> trustManager instanceof X509TrustManager ? (X509TrustManager)trustManager : null).filter(Objects::nonNull).toArray(X509TrustManager[]::new);
            if (trustManagers.length == 0) {
                throw ElytronMessages.log.noDefaultTrustManager();
            }
            this.trustManager = trustManagers[0];
        }
        catch (GeneralSecurityException e) {
            throw ElytronMessages.log.sslErrorCreatingTrustManager(this.getClass().getName(), e);
        }
        this.acceptedIssuers = acceptedIssuers != null ? acceptedIssuers : X500.NO_CERTIFICATES;
    }

    public X509CRLExtendedTrustManager(KeyStore trustStore, InputStream crlStream) throws NoSuchAlgorithmException {
        this(trustStore, TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm()), crlStream, 5, null);
    }

    public X509CRLExtendedTrustManager(KeyStore trustStore) throws NoSuchAlgorithmException {
        this(trustStore, null);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.trustManager.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.trustManager.checkServerTrusted(chain, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.acceptedIssuers;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.trustManager.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.trustManager.checkServerTrusted(chain, authType);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine sslEngine) throws CertificateException {
        this.trustManager.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine sslEngine) throws CertificateException {
        this.trustManager.checkServerTrusted(chain, authType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<? extends CRL> getCRLs(InputStream crlStream) throws GeneralSecurityException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        try {
            Collection<? extends CRL> collection = cf.generateCRLs(crlStream);
            return collection;
        }
        finally {
            try {
                crlStream.close();
            }
            catch (Exception exception) {}
        }
    }
}

