/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.spec;

import java.util.Arrays;
import org.wildfly.common.Assert;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.password.spec.PasswordSpec;

public class IteratedSaltedHashPasswordSpec
implements PasswordSpec {
    private final byte[] hash;
    private final byte[] salt;
    private final int iterationCount;

    public IteratedSaltedHashPasswordSpec(byte[] hash, byte[] salt, int iterationCount) {
        Assert.checkNotNullParam("hash", hash);
        Assert.checkNotNullParam("salt", salt);
        this.hash = hash;
        this.salt = salt;
        this.iterationCount = iterationCount;
    }

    public byte[] getHash() {
        return this.hash;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public int getIterationCount() {
        return this.iterationCount;
    }

    public boolean equals(Object other) {
        if (!(other instanceof IteratedSaltedHashPasswordSpec)) {
            return false;
        }
        IteratedSaltedHashPasswordSpec o = (IteratedSaltedHashPasswordSpec)other;
        return Arrays.equals(this.hash, o.hash) && Arrays.equals(this.salt, o.salt) && this.iterationCount == o.iterationCount;
    }

    public int hashCode() {
        return HashMath.multiHashOrdered(HashMath.multiHashOrdered(Arrays.hashCode(this.hash), Arrays.hashCode(this.salt)), this.iterationCount);
    }
}

