/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.wildfly.common.Assert;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslClientFactory;

public class SortedMechanismClientServerFactory
extends AbstractDelegatingSaslClientFactory {
    private final Comparator<String> mechanismNameComparator;

    public SortedMechanismClientServerFactory(SaslClientFactory delegate, Comparator<String> mechanismNameComparator) {
        super(delegate);
        this.mechanismNameComparator = Assert.checkNotNullParam("mechanismComparator", mechanismNameComparator);
    }

    @Override
    public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        String[] sortedMechanisms = (String[])mechanisms.clone();
        Arrays.sort(sortedMechanisms, this.mechanismNameComparator);
        return super.createSaslClient(sortedMechanisms, authorizationId, protocol, serverName, props, cbh);
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        String[] mechanismNames = super.getMechanismNames(props);
        Arrays.sort(mechanismNames, this.mechanismNameComparator);
        return mechanismNames;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof SortedMechanismClientServerFactory && this.equals((SortedMechanismClientServerFactory)other);
    }

    @Override
    public boolean equals(AbstractDelegatingSaslClientFactory other) {
        return other instanceof SortedMechanismClientServerFactory && this.equals((SortedMechanismClientServerFactory)other);
    }

    public boolean equals(SortedMechanismClientServerFactory other) {
        return super.equals(other) && this.mechanismNameComparator.equals(other.mechanismNameComparator);
    }

    @Override
    protected int calculateHashCode() {
        return HashMath.multiHashOrdered(HashMath.multiHashOrdered(super.calculateHashCode(), this.getClass().hashCode()), this.mechanismNameComparator.hashCode());
    }
}

