/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.tool;

import java.security.Provider;
import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.wildfly.security.auth.server.IdentityCredentials;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.impl.KeyStoreCredentialStore;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.security.tool.Command;
import org.wildfly.security.tool.ElytronTool;
import org.wildfly.security.tool.ElytronToolMessages;
import org.wildfly.security.tool.MaskCommand;

class CredentialStoreCommand
extends Command {
    public static int ACTION_NOT_DEFINED = 5;
    public static int ALIAS_NOT_FOUND = 6;
    public static int GENERAL_CONFIGURATION_ERROR = 7;
    public static final String CREDENTIAL_STORE_COMMAND = "credential-store";
    public static final String STORE_LOCATION_PARAM = "location";
    public static final String IMPLEMENTATION_PROPERTIES_PARAM = "properties";
    public static final String CREDENTIAL_STORE_PASSWORD_PARAM = "password";
    public static final String CREDENTIAL_STORE_TYPE_PARAM = "type";
    public static final String SALT_PARAM = "salt";
    public static final String ITERATION_PARAM = "iteration";
    public static final String PASSWORD_CREDENTIAL_VALUE_PARAM = "secret";
    public static final String ADD_ALIAS_PARAM = "add";
    public static final String CHECK_ALIAS_PARAM = "exists";
    public static final String ALIASES_PARAM = "aliases";
    public static final String REMOVE_ALIAS_PARAM = "remove";
    public static final String CREATE_CREDENTIAL_STORE_PARAM = "create";
    public static final String HELP_PARAM = "help";
    public static final String PRINT_SUMMARY_PARAM = "summary";
    public static final String ENTRY_TYPE_PARAM = "entry-type";
    public static final String OTHER_PROVIDERS_PARAM = "other-providers";
    private final Options options;
    private CommandLineParser parser = new DefaultParser();
    private CommandLine cmdLine = null;

    CredentialStoreCommand() {
        this.options = new Options();
        Option opt = new Option("l", STORE_LOCATION_PARAM, true, ElytronToolMessages.msg.cmdLineStoreLocationDesc());
        opt.setArgName("loc");
        opt.setOptionalArg(false);
        this.options.addOption(opt);
        opt = new Option("u", IMPLEMENTATION_PROPERTIES_PARAM, true, ElytronToolMessages.msg.cmdLineImplementationPropertiesDesc());
        this.options.addOption(opt);
        opt = new Option("p", CREDENTIAL_STORE_PASSWORD_PARAM, true, ElytronToolMessages.msg.cmdLineCredentialStorePassword());
        opt.setArgName("pwd");
        this.options.addOption(opt);
        this.options.addOption("s", SALT_PARAM, true, ElytronToolMessages.msg.cmdLineSaltDesc());
        this.options.addOption("i", ITERATION_PARAM, true, ElytronToolMessages.msg.cmdLineIterationCountDesc());
        opt = new Option("x", PASSWORD_CREDENTIAL_VALUE_PARAM, true, ElytronToolMessages.msg.cmdLinePasswordCredentialValueDesc());
        opt.setArgName("secret to store");
        opt.setOptionalArg(true);
        this.options.addOption(opt);
        opt = new Option("n", ENTRY_TYPE_PARAM, true, ElytronToolMessages.msg.cmdLineEntryTypeDesc());
        opt.setArgName(CREDENTIAL_STORE_TYPE_PARAM);
        opt.setOptionalArg(true);
        this.options.addOption(opt);
        opt = new Option("o", OTHER_PROVIDERS_PARAM, true, ElytronToolMessages.msg.cmdLineOtherProvidersDesc());
        opt.setArgName("providers");
        opt.setOptionalArg(true);
        this.options.addOption(opt);
        this.options.addOption("c", CREATE_CREDENTIAL_STORE_PARAM, false, ElytronToolMessages.msg.cmdLineCreateCredentialStoreDesc());
        opt = new Option("t", CREDENTIAL_STORE_TYPE_PARAM, true, ElytronToolMessages.msg.cmdLineCredentialStoreTypeDesc());
        opt.setArgName(CREDENTIAL_STORE_TYPE_PARAM);
        this.options.addOption(opt);
        this.options.addOption("f", PRINT_SUMMARY_PARAM, false, ElytronToolMessages.msg.cmdLinePrintSummary());
        OptionGroup og = new OptionGroup();
        Option a = new Option("a", ADD_ALIAS_PARAM, true, ElytronToolMessages.msg.cmdLineAddAliasDesc());
        a.setArgName("alias");
        Option e = new Option("e", CHECK_ALIAS_PARAM, true, ElytronToolMessages.msg.cmdLineCheckAliasDesc());
        e.setArgName("alias");
        Option r = new Option("r", REMOVE_ALIAS_PARAM, true, ElytronToolMessages.msg.cmdLineRemoveAliasDesc());
        r.setArgName("alias");
        Option v = new Option("v", ALIASES_PARAM, false, ElytronToolMessages.msg.cmdLineAliasesDesc());
        Option h = new Option("h", HELP_PARAM, false, ElytronToolMessages.msg.cmdLineHelp());
        og.addOption(a);
        og.addOption(e);
        og.addOption(r);
        og.addOption(v);
        this.options.addOptionGroup(og);
        this.options.addOption(h);
    }

    @Override
    public void execute(String[] args) throws Exception {
        String alias;
        this.setStatus(GENERAL_CONFIGURATION_ERROR);
        this.cmdLine = this.parser.parse(this.options, args, false);
        if (this.cmdLine.hasOption(HELP_PARAM)) {
            this.help();
            this.setStatus(ElytronTool.ElytronToolExitStatus_OK);
            return;
        }
        this.printDuplicatesWarning(this.cmdLine);
        String location = this.cmdLine.getOptionValue(STORE_LOCATION_PARAM);
        if (location == null) {
            this.setStatus(GENERAL_CONFIGURATION_ERROR);
            throw ElytronToolMessages.msg.optionNotSpecified(STORE_LOCATION_PARAM);
        }
        String csPassword = this.cmdLine.getOptionValue(CREDENTIAL_STORE_PASSWORD_PARAM);
        String salt = this.cmdLine.getOptionValue(SALT_PARAM);
        String csType = this.cmdLine.getOptionValue(CREDENTIAL_STORE_TYPE_PARAM, KeyStoreCredentialStore.KEY_STORE_CREDENTIAL_STORE);
        int iterationCount = this.getArgumentAsInt(this.cmdLine.getOptionValue(ITERATION_PARAM));
        String entryType = this.cmdLine.getOptionValue(ENTRY_TYPE_PARAM);
        String otherProviders = this.cmdLine.getOptionValue(OTHER_PROVIDERS_PARAM);
        boolean createStorage = this.cmdLine.hasOption(CREATE_CREDENTIAL_STORE_PARAM);
        if (createStorage && this.cmdLine.getArgs().length > 0) {
            this.setStatus(GENERAL_CONFIGURATION_ERROR);
            throw ElytronToolMessages.msg.noArgumentOption(CREATE_CREDENTIAL_STORE_PARAM);
        }
        boolean printSummary = this.cmdLine.hasOption(PRINT_SUMMARY_PARAM);
        String secret = this.cmdLine.getOptionValue(PASSWORD_CREDENTIAL_VALUE_PARAM);
        Map<String, String> implProps = CredentialStoreCommand.parseCredentialStoreProperties(this.cmdLine.getOptionValue(IMPLEMENTATION_PROPERTIES_PARAM));
        CredentialStore credentialStore = CredentialStore.getInstance(csType);
        implProps.put(STORE_LOCATION_PARAM, location);
        implProps.putIfAbsent("modifiable", Boolean.TRUE.toString());
        implProps.putIfAbsent(CREATE_CREDENTIAL_STORE_PARAM, Boolean.valueOf(createStorage).toString());
        implProps.putIfAbsent("keyStoreType", "JCEKS");
        CredentialStore.CredentialSourceProtectionParameter credentialSourceProtectionParameter = null;
        if (csPassword == null) {
            csPassword = this.prompt(false, ElytronToolMessages.msg.credentialStorePasswordPrompt(), true, ElytronToolMessages.msg.credentialStorePasswordPromptConfirm());
        }
        if (csPassword != null) {
            credentialSourceProtectionParameter = new CredentialStore.CredentialSourceProtectionParameter(IdentityCredentials.NONE.withCredential(new PasswordCredential(ClearPassword.createRaw("clear", csPassword.toCharArray()))));
        }
        credentialStore.initialize(implProps, credentialSourceProtectionParameter, this.getProviders(otherProviders));
        if (this.cmdLine.hasOption(ADD_ALIAS_PARAM)) {
            alias = this.cmdLine.getOptionValue(ADD_ALIAS_PARAM);
            if (alias.length() == 0) {
                this.setStatus(GENERAL_CONFIGURATION_ERROR);
                throw ElytronToolMessages.msg.optionNotSpecified(ADD_ALIAS_PARAM);
            }
            if (secret == null && (secret = this.prompt(false, ElytronToolMessages.msg.secretToStorePrompt(), true, ElytronToolMessages.msg.secretToStorePromptConfirm())) == null) {
                this.setStatus(GENERAL_CONFIGURATION_ERROR);
                throw ElytronToolMessages.msg.optionNotSpecified(PASSWORD_CREDENTIAL_VALUE_PARAM);
            }
            credentialStore.store(alias, this.createCredential(secret, entryType));
            credentialStore.flush();
            System.out.println(ElytronToolMessages.msg.aliasStored(alias));
            this.setStatus(ElytronTool.ElytronToolExitStatus_OK);
        } else if (this.cmdLine.hasOption(REMOVE_ALIAS_PARAM)) {
            alias = this.cmdLine.getOptionValue(REMOVE_ALIAS_PARAM);
            if (credentialStore.exists(alias, this.entryTypeToCredential(entryType))) {
                credentialStore.remove(alias, this.entryTypeToCredential(entryType));
                credentialStore.flush();
                System.out.println(ElytronToolMessages.msg.aliasRemoved(alias));
                this.setStatus(ElytronTool.ElytronToolExitStatus_OK);
            } else {
                System.out.println(ElytronToolMessages.msg.aliasDoesNotExist(alias));
                this.setStatus(ALIAS_NOT_FOUND);
            }
        } else if (this.cmdLine.hasOption(CHECK_ALIAS_PARAM)) {
            alias = this.cmdLine.getOptionValue(CHECK_ALIAS_PARAM);
            if (credentialStore.exists(alias, this.entryTypeToCredential(entryType))) {
                this.setStatus(ElytronTool.ElytronToolExitStatus_OK);
                System.out.println(ElytronToolMessages.msg.aliasExists(alias));
            } else {
                this.setStatus(ALIAS_NOT_FOUND);
                System.out.println(ElytronToolMessages.msg.aliasDoesNotExist(alias));
            }
        } else if (this.cmdLine.hasOption(ALIASES_PARAM)) {
            Set<String> aliases = credentialStore.getAliases();
            if (aliases.size() != 0) {
                StringBuilder list = new StringBuilder();
                for (String alias2 : aliases) {
                    list.append(alias2).append(" ");
                }
                System.out.println(ElytronToolMessages.msg.aliases(list.toString()));
            } else {
                System.out.println(ElytronToolMessages.msg.noAliases());
            }
            this.setStatus(ElytronTool.ElytronToolExitStatus_OK);
        } else if (this.cmdLine.hasOption(CREATE_CREDENTIAL_STORE_PARAM)) {
            credentialStore.flush();
            System.out.println(ElytronToolMessages.msg.credentialStoreCreated());
            this.setStatus(ElytronTool.ElytronToolExitStatus_OK);
        } else {
            this.setStatus(ACTION_NOT_DEFINED);
            throw ElytronToolMessages.msg.actionToPerformNotDefined();
        }
        if (printSummary) {
            String password;
            StringBuilder com = new StringBuilder();
            String string = password = csPassword == null ? "" : csPassword;
            if (this.cmdLine.hasOption(ADD_ALIAS_PARAM)) {
                if (csPassword != null && !csPassword.startsWith("MASK-") && salt != null && iterationCount > -1) {
                    password = MaskCommand.computeMasked(csPassword, salt, iterationCount);
                }
                if (createStorage) {
                    CredentialStoreCommand.getCreateSummary(implProps, com, password);
                    com.append("\n");
                }
                com.append("/subsystem=elytron/credential-store=test/alias=");
                com.append(this.cmdLine.getOptionValue(ADD_ALIAS_PARAM));
                com.append(":add(secret-value=\"");
                com.append(secret);
                com.append("\")");
            } else if (this.cmdLine.hasOption(REMOVE_ALIAS_PARAM)) {
                com.append("/subsystem=elytron/credential-store=test/alias=");
                com.append(this.cmdLine.getOptionValue(REMOVE_ALIAS_PARAM));
                com.append(":remove()");
            } else if (this.cmdLine.hasOption(ALIASES_PARAM)) {
                com.append("/subsystem=elytron/credential-store=test:read-children-names(child-type=alias)");
            } else if (this.cmdLine.hasOption(CHECK_ALIAS_PARAM)) {
                com.append("ls /subsystem=elytron/credential-store=test1/alias=");
                com.append(this.cmdLine.getOptionValue(CHECK_ALIAS_PARAM));
            } else if (this.cmdLine.hasOption(CREATE_CREDENTIAL_STORE_PARAM)) {
                CredentialStoreCommand.getCreateSummary(implProps, com, password);
            }
            System.out.println(ElytronToolMessages.msg.commandSummary(com.toString()));
        }
    }

    private Credential createCredential(String secret, String entryType) {
        if (entryType == null || PasswordCredential.class.getName().equals(entryType)) {
            return new PasswordCredential(ClearPassword.createRaw("clear", secret.toCharArray()));
        }
        throw ElytronToolMessages.msg.unknownEntryType(entryType);
    }

    private Class<? extends Credential> entryTypeToCredential(String entryType) {
        if (entryType == null || PasswordCredential.class.getName().equals(entryType)) {
            return PasswordCredential.class;
        }
        throw ElytronToolMessages.msg.unknownEntryType(entryType);
    }

    private Provider[] getProviders(String otherProviders) {
        if (otherProviders != null && !otherProviders.isEmpty()) {
            String[] providerNames = otherProviders.split(",");
            Provider[] providers = new Provider[providerNames.length];
            int i = 0;
            for (String p : providerNames) {
                Provider provider = Security.getProvider(p.trim());
                if (provider == null) {
                    throw ElytronToolMessages.msg.unknownProvider(p.trim());
                }
                providers[i++] = provider;
            }
            return providers;
        }
        return null;
    }

    @Override
    protected Set<String> aliases() {
        return Stream.of("cs", "credstore").collect(Collectors.toSet());
    }

    @Override
    public void help() {
        HelpFormatter help = new HelpFormatter();
        help.setWidth(WIDTH);
        help.printHelp(ElytronToolMessages.msg.cmdHelp("wildfly-elytron-tool.jar", CREDENTIAL_STORE_COMMAND), ElytronToolMessages.msg.cmdLineCredentialStoreHelpHeader(), this.options, "", true);
    }

    static Map<String, String> parseCredentialStoreProperties(String attributeString) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        if (attributeString != null) {
            for (String pair : attributeString.split(";")) {
                String[] parts = pair.split("=");
                if (parts[0] == null || parts[0].isEmpty() || parts[1] == null) {
                    throw ElytronToolMessages.msg.cannotParseProps();
                }
                attributes.put(parts[0], parts[1]);
            }
        }
        return attributes;
    }

    static String formatPropertiesForCli(Map<String, String> properties) {
        if (properties != null || !properties.isEmpty()) {
            properties.remove(CREATE_CREDENTIAL_STORE_PARAM);
            properties.remove(STORE_LOCATION_PARAM);
            properties.remove("modifiable");
            boolean first = true;
            StringBuilder attr = new StringBuilder("implementation-properties={");
            for (String name : properties.keySet()) {
                if (!first) {
                    attr.append(",");
                } else {
                    first = false;
                }
                attr.append("\"" + name + "\"=>\"" + properties.get(name) + "\"");
            }
            attr.append("}");
            return attr.toString();
        }
        return "";
    }

    private int getArgumentAsInt(String argument) throws Exception {
        if (argument != null && !argument.isEmpty()) {
            try {
                return Integer.parseInt(argument);
            }
            catch (NumberFormatException e) {
                this.setStatus(GENERAL_CONFIGURATION_ERROR);
                throw new Exception(e);
            }
        }
        return -1;
    }

    static void getCreateSummary(Map<String, String> implProps, StringBuilder com, String password) {
        String props;
        com.append("/subsystem=elytron/credential-store=cs:add(");
        com.append("relative-to=jboss.server.data.dir,");
        com.append("create=true,");
        if (implProps.get("modifiable") != null) {
            com.append("modifiable=" + implProps.get("modifiable") + ",");
        }
        if (implProps.get(STORE_LOCATION_PARAM) != null) {
            com.append("location=\"" + implProps.get(STORE_LOCATION_PARAM) + "\",");
        }
        if (!(props = CredentialStoreCommand.formatPropertiesForCli(implProps)).isEmpty()) {
            com.append(props);
            com.append(",");
        }
        com.append("credential-reference={");
        com.append("clear-text=\"");
        com.append(password);
        com.append("\"})");
    }
}

