/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.function.UnaryOperator;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.wildfly.common.Assert;
import org.wildfly.security.SecurityFactory;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.RuleNode;
import org.wildfly.security.auth.principal.AnonymousPrincipal;
import org.wildfly.security.permission.ElytronPermission;

public final class AuthenticationContextConfigurationClient {
    private static final ElytronPermission CREATE_PERMISSION = new ElytronPermission("createAuthenticationContextConfigurationClient");
    public static final PrivilegedAction<AuthenticationContextConfigurationClient> ACTION = AuthenticationContextConfigurationClient::new;

    public AuthenticationContextConfigurationClient() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CREATE_PERMISSION);
        }
    }

    public AuthenticationConfiguration getAuthenticationConfiguration(URI uri, AuthenticationContext authenticationContext) {
        return this.getAuthenticationConfiguration(uri, authenticationContext, -1);
    }

    public AuthenticationConfiguration getAuthenticationConfiguration(URI uri, AuthenticationContext authenticationContext, int protocolDefaultPort) {
        return this.getAuthenticationConfiguration(uri, authenticationContext, protocolDefaultPort, null, null);
    }

    public AuthenticationConfiguration getAuthenticationConfiguration(URI uri, AuthenticationContext authenticationContext, int protocolDefaultPort, String abstractType, String abstractTypeAuthority) {
        return this.getAuthenticationConfiguration(uri, authenticationContext, protocolDefaultPort, abstractType, abstractTypeAuthority, null);
    }

    public AuthenticationConfiguration getAuthenticationConfiguration(URI uri, AuthenticationContext authenticationContext, int protocolDefaultPort, String abstractType, String abstractTypeAuthority, String purpose) {
        String userInfo;
        int port;
        Assert.checkNotNullParam("uri", uri);
        Assert.checkNotNullParam("authenticationContext", authenticationContext);
        RuleNode<AuthenticationConfiguration> node = authenticationContext.authRuleMatching(uri, abstractType, abstractTypeAuthority, purpose);
        AuthenticationConfiguration configuration = node != null ? node.getConfiguration() : AuthenticationConfiguration.EMPTY;
        String uriHost = uri.getHost();
        if (uriHost != null && configuration.setHost == null) {
            configuration = configuration.useHost(uriHost);
        }
        if ((port = uri.getPort()) == -1) {
            port = protocolDefaultPort;
        }
        if (port != -1 && configuration.setPort == -1) {
            configuration = configuration.usePort(port);
        }
        if ((userInfo = uri.getUserInfo()) != null && configuration.getPrincipal() == AnonymousPrincipal.getInstance()) {
            configuration = configuration.useName(userInfo);
        }
        ElytronMessages.log.tracef("getAuthenticationConfiguration uri=%s, protocolDefaultPort=%d, abstractType=%s, abstractTypeAuthority=%s, purpose=%s, MatchRule=[%s], AuthenticationConfiguration=[%s]", uri, protocolDefaultPort, abstractType, abstractTypeAuthority, purpose, node != null ? node.rule : null, configuration);
        return configuration;
    }

    public SSLContext getSSLContext(URI uri, AuthenticationContext authenticationContext) throws GeneralSecurityException {
        return this.getSSLContext(uri, authenticationContext, null, null);
    }

    public SSLContext getSSLContext(URI uri, AuthenticationContext authenticationContext, String abstractType, String abstractTypeAuthority) throws GeneralSecurityException {
        return this.getSSLContext(uri, authenticationContext, abstractType, abstractTypeAuthority, null);
    }

    public SSLContext getSSLContext(URI uri, AuthenticationContext authenticationContext, String abstractType, String abstractTypeAuthority, String purpose) throws GeneralSecurityException {
        return this.getSSLContextFactory(uri, authenticationContext, abstractType, abstractTypeAuthority, purpose).create();
    }

    public SecurityFactory<SSLContext> getSSLContextFactory(URI uri, AuthenticationContext authenticationContext, String abstractType, String abstractTypeAuthority, String purpose) {
        Assert.checkNotNullParam("uri", uri);
        Assert.checkNotNullParam("authenticationContext", authenticationContext);
        RuleNode<SecurityFactory<SSLContext>> node = authenticationContext.sslRuleMatching(uri, abstractType, abstractTypeAuthority, purpose);
        if (node == null) {
            return SSLContext::getDefault;
        }
        return node.getConfiguration();
    }

    public CallbackHandler getCallbackHandler(AuthenticationConfiguration configuration) {
        Assert.checkNotNullParam("configuration", configuration);
        CallbackHandler callbackHandler = configuration.getUserCallbackHandler();
        return callbackHandler == null ? configuration.createCallbackHandler() : callbackHandler;
    }

    public String getRealHost(URI uri, AuthenticationConfiguration configuration) {
        Assert.checkNotNullParam("uri", uri);
        Assert.checkNotNullParam("configuration", configuration);
        String configurationHost = configuration.getHost();
        return configurationHost == null ? uri.getHost() : configurationHost;
    }

    public String getRealHost(AuthenticationConfiguration configuration) {
        Assert.checkNotNullParam("configuration", configuration);
        return configuration.getHost();
    }

    public int getRealPort(URI uri, AuthenticationConfiguration configuration) {
        Assert.checkNotNullParam("uri", uri);
        Assert.checkNotNullParam("configuration", configuration);
        int configurationPort = configuration.getPort();
        return configurationPort == -1 ? uri.getPort() : configurationPort;
    }

    public int getRealPort(AuthenticationConfiguration configuration) {
        Assert.checkNotNullParam("configuration", configuration);
        return configuration.getPort();
    }

    public String getRealProtocol(URI uri, AuthenticationConfiguration configuration) {
        Assert.checkNotNullParam("uri", uri);
        Assert.checkNotNullParam("configuration", configuration);
        String protocol = configuration.getProtocol();
        return protocol == null ? uri.getScheme() : protocol;
    }

    public String getRealProtocol(AuthenticationConfiguration configuration) {
        Assert.checkNotNullParam("configuration", configuration);
        return configuration.getProtocol();
    }

    public Principal getPrincipal(AuthenticationConfiguration configuration) {
        Assert.checkNotNullParam("configuration", configuration);
        return configuration.getPrincipal();
    }

    public Principal getAuthorizationPrincipal(AuthenticationConfiguration configuration) {
        Assert.checkNotNullParam("configuration", configuration);
        return configuration.getAuthorizationPrincipal();
    }

    public SaslClient createSaslClient(URI uri, AuthenticationConfiguration configuration, Collection<String> offeredMechanisms) throws SaslException {
        return this.createSaslClient(uri, configuration, offeredMechanisms, UnaryOperator.identity());
    }

    public SaslClient createSaslClient(URI uri, AuthenticationConfiguration configuration, Collection<String> offeredMechanisms, UnaryOperator<SaslClientFactory> factoryOperator) throws SaslException {
        return this.createSaslClient(uri, configuration, offeredMechanisms, factoryOperator, null);
    }

    public SaslClient createSaslClient(URI uri, AuthenticationConfiguration configuration, Collection<String> offeredMechanisms, UnaryOperator<SaslClientFactory> factoryOperator, SSLSession sslSession) throws SaslException {
        return configuration.createSaslClient(uri, offeredMechanisms, factoryOperator, sslSession);
    }

    public InetSocketAddress getDestinationInetSocketAddress(URI uri, AuthenticationConfiguration configuration, int protocolDefaultPort) {
        int port;
        Assert.checkNotNullParam("uri", uri);
        Assert.checkNotNullParam("configuration", configuration);
        String host = configuration.getHost();
        if (host == null) {
            host = uri.getHost();
        }
        if ((port = configuration.getPort()) == -1) {
            port = uri.getPort();
        }
        if (port == -1) {
            port = protocolDefaultPort;
        }
        return new InetSocketAddress(host, port);
    }

    public InetSocketAddress getDestinationInetSocketAddress(AuthenticationConfiguration configuration) {
        Assert.checkNotNullParam("configuration", configuration);
        return new InetSocketAddress(configuration.getHost(), configuration.getPort());
    }

    public Socket connect(URI uri, AuthenticationConfiguration configuration, int protocolDefaultPort) throws IOException {
        InetSocketAddress address = this.getDestinationInetSocketAddress(uri, configuration, protocolDefaultPort);
        return new Socket(address.getAddress(), address.getPort());
    }
}

