/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.Security;
import java.util.Map;
import javax.xml.stream.Location;
import org.wildfly.client.config.ConfigXMLParseException;
import org.wildfly.client.config.XMLLocation;
import org.wildfly.common.Assert;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.security._private.ElytronMessages;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.impl.KeyStoreCredentialStore;

final class CredentialStoreFactory
implements ExceptionSupplier<CredentialStore, ConfigXMLParseException> {
    private final String name;
    private final String type;
    private final Map<String, String> attributes;
    private final Provider provider;
    private final XMLLocation location;
    private final ExceptionSupplier<CredentialSource, ConfigXMLParseException> credentialSource;

    private CredentialStoreFactory(String name, String type, Map<String, String> attributes, Provider provider, String providerName, XMLLocation location, ExceptionSupplier<CredentialSource, ConfigXMLParseException> supplier) {
        Assert.checkNotNullParam("name", name);
        Assert.checkNotNullParam("attributes", attributes);
        this.name = name;
        this.type = type == null ? KeyStoreCredentialStore.KEY_STORE_CREDENTIAL_STORE : type;
        this.attributes = attributes;
        this.provider = provider != null ? provider : Security.getProvider(providerName);
        this.location = location;
        this.credentialSource = supplier == null ? null : supplier;
    }

    CredentialStoreFactory(String name, String type, Map<String, String> attributes, String providerName, XMLLocation location, ExceptionSupplier<CredentialSource, ConfigXMLParseException> supplier) {
        this(name, type, attributes, null, providerName, location, supplier);
    }

    @Override
    public CredentialStore get() throws ConfigXMLParseException {
        CredentialStore credentialStore;
        try {
            credentialStore = this.provider != null ? CredentialStore.getInstance(this.type, this.provider) : CredentialStore.getInstance(this.type);
            credentialStore.initialize(this.attributes, this.credentialSource == null ? null : new CredentialStore.CredentialSourceProtectionParameter(this.credentialSource.get()));
        }
        catch (GeneralSecurityException e) {
            throw ElytronMessages.xmlLog.xmlFailedToCreateCredentialStore((Location)this.location, e);
        }
        return credentialStore;
    }

    public String getName() {
        return this.name;
    }
}

