/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.tool;

import java.security.GeneralSecurityException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.wildfly.security.tool.Command;
import org.wildfly.security.tool.ElytronTool;
import org.wildfly.security.tool.ElytronToolMessages;
import org.wildfly.security.util.PasswordBasedEncryptionUtil;

class MaskCommand
extends Command {
    public static final String MASK_COMMAND = "mask";
    static final String SALT_PARAM = "salt";
    static final String ITERATION_PARAM = "iteration";
    static final String SECRET_PARAM = "secret";
    static final String HELP_PARAM = "help";
    private final Options options;
    private CommandLineParser parser = new DefaultParser();
    private CommandLine cmdLine = null;

    MaskCommand() {
        Option salt = new Option("s", SALT_PARAM, true, ElytronToolMessages.msg.cmdMaskSaltDesc());
        Option iteration = new Option("i", ITERATION_PARAM, true, ElytronToolMessages.msg.cmdMaskIterationCountDesc());
        OptionGroup og = new OptionGroup();
        Option x = new Option("x", SECRET_PARAM, true, ElytronToolMessages.msg.cmdMaskSecretDesc());
        x.setArgName("to encrypt");
        Option h = new Option("h", HELP_PARAM, false, ElytronToolMessages.msg.cmdLineHelp());
        og.addOption(x);
        og.addOption(h);
        og.setRequired(true);
        this.options = new Options();
        this.options.addOptionGroup(og);
        this.options.addOption(salt);
        this.options.addOption(iteration);
    }

    @Override
    public void execute(String[] args) throws Exception {
        String secret;
        this.setStatus(GENERAL_CONFIGURATION_ERROR);
        this.cmdLine = this.parser.parse(this.options, args, false);
        if (this.cmdLine.hasOption(HELP_PARAM)) {
            this.help();
            this.setStatus(ElytronTool.ElytronToolExitStatus_OK);
            return;
        }
        String salt = this.cmdLine.getOptionValue(SALT_PARAM);
        if (salt == null) {
            this.setStatus(GENERAL_CONFIGURATION_ERROR);
            throw ElytronToolMessages.msg.saltNotSpecified();
        }
        String sIteration = this.cmdLine.getOptionValue(ITERATION_PARAM);
        int iterationCount = -1;
        if (sIteration != null && !sIteration.isEmpty()) {
            try {
                iterationCount = Integer.parseInt(sIteration);
            }
            catch (NumberFormatException e) {
                this.setStatus(GENERAL_CONFIGURATION_ERROR);
                throw new Exception(e);
            }
        }
        if ((secret = this.cmdLine.getOptionValue(SECRET_PARAM)) == null) {
            this.setStatus(GENERAL_CONFIGURATION_ERROR);
            throw ElytronToolMessages.msg.secretNotSpecified();
        }
        String masked = MaskCommand.computeMasked(secret, salt, iterationCount);
        this.setStatus(ElytronTool.ElytronToolExitStatus_OK);
        System.out.println(masked);
    }

    static String computeMasked(String secret, String salt, int iteration) throws GeneralSecurityException {
        PasswordBasedEncryptionUtil encryptUtil = new PasswordBasedEncryptionUtil.Builder().picketBoxCompatibility().salt(salt).iteration(iteration).encryptMode().build();
        return "MASK-" + encryptUtil.encryptAndEncode(secret.toCharArray()) + ";" + salt + ";" + String.valueOf(iteration);
    }

    @Override
    public void help() {
        HelpFormatter help = new HelpFormatter();
        help.setWidth(WIDTH);
        help.printHelp(ElytronToolMessages.msg.cmdHelp("wildfly-elytron-tool.jar", MASK_COMMAND), ElytronToolMessages.msg.cmdMaskHelpHeader(), this.options, "", true);
    }
}

