/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.tool;

import java.io.Console;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.wildfly.security.tool.ElytronToolMessages;

public abstract class Command {
    public static int GENERAL_CONFIGURATION_ERROR = 7;
    public static int INPUT_DATA_NOT_CONFIRMED = 3;
    private int status = 255;
    public static int WIDTH = 1024;

    public abstract void execute(String[] var1) throws Exception;

    public void help() {
    }

    public boolean isAlias(String alias) {
        return this.aliases().contains(alias);
    }

    protected Set<String> aliases() {
        return Collections.emptySet();
    }

    public int getStatus() {
        return this.status;
    }

    protected void setStatus(int status) {
        this.status = status;
    }

    public static boolean isWindows() {
        String opsys = System.getProperty("os.name").toLowerCase();
        return opsys.indexOf("win") >= 0;
    }

    protected String prompt(boolean echo, String prompt, boolean confirm, String confirmPrompt) {
        Console console = System.console();
        if (console == null) {
            System.err.println(ElytronToolMessages.msg.cannotPromptConsoleMissing());
            System.exit(GENERAL_CONFIGURATION_ERROR);
        }
        if (echo) {
            String first = console.readLine(prompt, new Object[0]);
            if (first != null && confirm) {
                String second = console.readLine(confirmPrompt, new Object[0]);
                if (first.equals(second)) {
                    return first;
                }
                System.err.println(ElytronToolMessages.msg.inputDataNotConfirmed());
                System.exit(INPUT_DATA_NOT_CONFIRMED);
                return null;
            }
            return first;
        }
        char[] inVisible = console.readPassword(prompt != null ? prompt : "Password:", new Object[0]);
        if (inVisible != null && confirm) {
            char[] inVisible2 = console.readPassword(confirmPrompt != null ? confirmPrompt : "Confirm password:", new Object[0]);
            if (Arrays.equals(inVisible, inVisible2)) {
                return new String(inVisible);
            }
            System.err.println(ElytronToolMessages.msg.inputDataNotConfirmed());
            System.exit(INPUT_DATA_NOT_CONFIRMED);
            return null;
        }
        if (inVisible != null) {
            return new String(inVisible);
        }
        return null;
    }
}

