/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.security.Provider;
import java.util.Objects;
import java.util.function.Supplier;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.auth.client.AuthenticationConfiguration;

class ProvidersAuthenticationConfiguration
extends AuthenticationConfiguration {
    private final Supplier<Provider[]> providerSupplier;

    ProvidersAuthenticationConfiguration(AuthenticationConfiguration parent, Supplier<Provider[]> providerSupplier) {
        super(parent);
        this.providerSupplier = providerSupplier;
    }

    @Override
    AuthenticationConfiguration reparent(AuthenticationConfiguration newParent) {
        return new ProvidersAuthenticationConfiguration(newParent, this.providerSupplier);
    }

    @Override
    Supplier<Provider[]> getProviderSupplier() {
        return this.providerSupplier;
    }

    @Override
    boolean halfEqual(AuthenticationConfiguration other) {
        return Objects.equals(this.providerSupplier, other.getProviderSupplier()) && this.parentHalfEqual(other);
    }

    @Override
    int calcHashCode() {
        return HashMath.multiHashUnordered(this.parentHashCode(), 99251, Objects.hashCode(this.providerSupplier));
    }

    @Override
    StringBuilder asString(StringBuilder sb) {
        return this.parentAsString(sb).append("Providers,");
    }
}

