/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm;

import java.security.Principal;
import java.security.spec.AlgorithmParameterSpec;
import java.util.function.Consumer;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.realm.ElytronMessages;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.AlgorithmEvidence;
import org.wildfly.security.evidence.Evidence;

public class DistributedSecurityRealm
implements SecurityRealm {
    private final boolean ignoreUnavailableRealms;
    private final SecurityRealm[] securityRealms;
    private final Consumer<Integer> unavailableRealmCallback;

    public DistributedSecurityRealm(SecurityRealm ... securityRealms) {
        this(false, null, securityRealms);
    }

    public DistributedSecurityRealm(boolean ignoreUnavailableRealms, Consumer<Integer> unavailableRealmCallback, SecurityRealm ... securityRealms) {
        Assert.checkNotNullParam((String)"securityRealms", (Object)securityRealms);
        this.ignoreUnavailableRealms = ignoreUnavailableRealms;
        this.unavailableRealmCallback = unavailableRealmCallback;
        this.securityRealms = securityRealms;
    }

    public RealmIdentity getRealmIdentity(Evidence evidence) throws RealmUnavailableException {
        return new EvidenceDistributedIdentity(evidence);
    }

    public RealmIdentity getRealmIdentity(Principal principal) throws RealmUnavailableException {
        return new PrincipalDistributedIdentity(principal);
    }

    public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
        SupportLevel max = SupportLevel.UNSUPPORTED;
        for (SecurityRealm r : this.securityRealms) {
            max = SupportLevel.max((SupportLevel)max, (SupportLevel)r.getCredentialAcquireSupport(credentialType, algorithmName, parameterSpec));
        }
        return max;
    }

    public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
        SupportLevel max = SupportLevel.UNSUPPORTED;
        for (SecurityRealm r : this.securityRealms) {
            max = SupportLevel.max((SupportLevel)max, (SupportLevel)r.getEvidenceVerifySupport(evidenceType, algorithmName));
        }
        return max;
    }

    final class PrincipalDistributedIdentity
    implements RealmIdentity {
        private final Principal principal;
        private RealmIdentity currentIdentity = RealmIdentity.NON_EXISTENT;
        private int nextRealm = 0;

        PrincipalDistributedIdentity(Principal principal) throws RealmUnavailableException {
            this.principal = principal;
            this.nextIdentity();
        }

        private boolean nextIdentity() throws RealmUnavailableException {
            boolean doesIdentityExist;
            block5: {
                this.currentIdentity.dispose();
                if (this.nextRealm >= DistributedSecurityRealm.this.securityRealms.length) {
                    this.currentIdentity = RealmIdentity.NON_EXISTENT;
                    return false;
                }
                doesIdentityExist = false;
                try {
                    this.currentIdentity = DistributedSecurityRealm.this.securityRealms[this.nextRealm].getRealmIdentity(this.principal);
                    doesIdentityExist = this.currentIdentity.exists();
                }
                catch (RealmUnavailableException e) {
                    if (!DistributedSecurityRealm.this.ignoreUnavailableRealms) {
                        throw e;
                    }
                    ElytronMessages.log.realmIsNotAvailable((Exception)((Object)e));
                    if (DistributedSecurityRealm.this.unavailableRealmCallback == null) break block5;
                    DistributedSecurityRealm.this.unavailableRealmCallback.accept(this.nextRealm);
                }
            }
            ++this.nextRealm;
            if (!doesIdentityExist) {
                return this.nextIdentity();
            }
            return true;
        }

        public Principal getRealmIdentityPrincipal() {
            return this.currentIdentity.getRealmIdentityPrincipal();
        }

        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            return this.currentIdentity.getCredentialAcquireSupport(credentialType, algorithmName, parameterSpec);
        }

        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            return this.currentIdentity.getEvidenceVerifySupport(evidenceType, algorithmName);
        }

        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            do {
                Credential credential;
                if ((credential = this.currentIdentity.getCredential(credentialType, algorithmName, parameterSpec)) == null) continue;
                return (C)credential;
            } while (this.nextIdentity());
            return null;
        }

        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) throws RealmUnavailableException {
            do {
                Credential credential;
                if ((credential = this.currentIdentity.getCredential(credentialType, algorithmName)) == null) continue;
                return (C)credential;
            } while (this.nextIdentity());
            return null;
        }

        public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
            do {
                Credential credential;
                if ((credential = this.currentIdentity.getCredential(credentialType)) == null) continue;
                return (C)credential;
            } while (this.nextIdentity());
            return null;
        }

        public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            return this.currentIdentity.verifyEvidence(evidence);
        }

        public boolean exists() throws RealmUnavailableException {
            return this.currentIdentity.exists();
        }

        public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
            return this.currentIdentity.getAuthorizationIdentity();
        }

        public void dispose() {
            this.currentIdentity.dispose();
        }
    }

    final class EvidenceDistributedIdentity
    implements RealmIdentity {
        private final Evidence evidence;
        private final String evidenceAlgorithm;
        private RealmIdentity currentIdentity = RealmIdentity.NON_EXISTENT;
        private int nextRealm = 0;

        private EvidenceDistributedIdentity(Evidence evidence) throws RealmUnavailableException {
            this.evidence = evidence;
            this.evidenceAlgorithm = evidence instanceof AlgorithmEvidence ? ((AlgorithmEvidence)evidence).getAlgorithm() : null;
            this.nextIdentity();
        }

        private boolean nextIdentity() throws RealmUnavailableException {
            this.currentIdentity.dispose();
            if (this.nextRealm >= DistributedSecurityRealm.this.securityRealms.length) {
                this.currentIdentity = RealmIdentity.NON_EXISTENT;
                return false;
            }
            if (DistributedSecurityRealm.this.securityRealms[this.nextRealm].getEvidenceVerifySupport(this.evidence.getClass(), this.evidenceAlgorithm).mayBeSupported()) {
                this.currentIdentity = DistributedSecurityRealm.this.securityRealms[this.nextRealm].getRealmIdentity(this.evidence);
                ++this.nextRealm;
                if (this.currentIdentity.getEvidenceVerifySupport(this.evidence.getClass(), this.evidenceAlgorithm).isNotSupported()) {
                    return this.nextIdentity();
                }
            } else {
                ++this.nextRealm;
                return this.nextIdentity();
            }
            return true;
        }

        public Principal getRealmIdentityPrincipal() {
            return this.currentIdentity.getRealmIdentityPrincipal();
        }

        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            return SupportLevel.UNSUPPORTED;
        }

        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            return this.currentIdentity.getEvidenceVerifySupport(evidenceType, algorithmName);
        }

        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            return null;
        }

        public <C extends Credential> C getCredential(Class<C> credentialType, String algorithmName) throws RealmUnavailableException {
            return null;
        }

        public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
            return null;
        }

        public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
            do {
                if (!this.currentIdentity.verifyEvidence(evidence)) continue;
                return true;
            } while (this.nextIdentity());
            return false;
        }

        public boolean exists() throws RealmUnavailableException {
            return this.currentIdentity.exists();
        }

        public AuthorizationIdentity getAuthorizationIdentity() throws RealmUnavailableException {
            return this.currentIdentity.getAuthorizationIdentity();
        }

        public void dispose() {
            this.currentIdentity.dispose();
        }
    }
}

