/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.spnego;

import java.security.Provider;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.callback.CallbackHandler;
import org.wildfly.common.Assert;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpConstants;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;
import org.wildfly.security.http.spnego.ElytronMessages;
import org.wildfly.security.http.spnego.SpnegoAuthenticationMechanism;

public class SpnegoMechanismFactory
implements HttpServerAuthenticationMechanismFactory {
    private static final AtomicBoolean ID_CHANGE_LOGGED = new AtomicBoolean(false);

    public SpnegoMechanismFactory() {
    }

    public SpnegoMechanismFactory(Provider provider) {
    }

    public String[] getMechanismNames(Map<String, ?> properties) {
        return new String[]{"SPNEGO"};
    }

    public HttpServerAuthenticationMechanism createAuthenticationMechanism(String mechanismName, Map<String, ?> properties, CallbackHandler callbackHandler) throws HttpAuthenticationException {
        Assert.checkNotNullParam((String)"mechanismName", (Object)mechanismName);
        Assert.checkNotNullParam((String)"properties", properties);
        Assert.checkNotNullParam((String)"callbackHandler", (Object)callbackHandler);
        if ("SPNEGO".equals(mechanismName)) {
            if (Boolean.valueOf((String)properties.get(HttpConstants.DISABLE_SESSION_ID_CHANGE)).booleanValue() && !ID_CHANGE_LOGGED.getAndSet(true)) {
                ElytronMessages.log.sessionIdChangeDiabled();
            }
            return new SpnegoAuthenticationMechanism(callbackHandler, properties);
        }
        return null;
    }
}

