/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.oidc;

import java.io.IOException;
import org.wildfly.security.http.oidc.AccessAndIDTokenResponse;
import org.wildfly.security.http.oidc.AccessToken;
import org.wildfly.security.http.oidc.ElytronMessages;
import org.wildfly.security.http.oidc.IDToken;
import org.wildfly.security.http.oidc.Oidc;
import org.wildfly.security.http.oidc.OidcClientConfiguration;
import org.wildfly.security.http.oidc.OidcException;
import org.wildfly.security.http.oidc.OidcHttpFacade;
import org.wildfly.security.http.oidc.OidcSecurityContext;
import org.wildfly.security.http.oidc.OidcTokenStore;
import org.wildfly.security.http.oidc.ServerRequest;
import org.wildfly.security.http.oidc.TokenValidator;

public class RefreshableOidcSecurityContext
extends OidcSecurityContext {
    protected transient OidcClientConfiguration clientConfiguration;
    protected transient OidcTokenStore tokenStore;
    protected String refreshToken;
    protected transient OidcHttpFacade.Cookie cookie;

    public RefreshableOidcSecurityContext() {
    }

    public RefreshableOidcSecurityContext(OidcClientConfiguration clientConfiguration, OidcHttpFacade.Cookie cookie, OidcTokenStore tokenStore, String tokenString, AccessToken token, String idTokenString, IDToken idToken, String refreshToken) {
        super(tokenString, token, idTokenString, idToken);
        this.clientConfiguration = clientConfiguration;
        this.tokenStore = tokenStore;
        this.refreshToken = refreshToken;
        this.cookie = cookie;
    }

    @Override
    public AccessToken getToken() {
        this.refreshToken(true);
        return super.getToken();
    }

    @Override
    public String getTokenString() {
        this.refreshToken(true);
        return super.getTokenString();
    }

    @Override
    public IDToken getIDToken() {
        this.refreshToken(true);
        return super.getIDToken();
    }

    @Override
    public String getIDTokenString() {
        this.refreshToken(true);
        return super.getIDTokenString();
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void logout(OidcClientConfiguration clientConfiguration) {
        try {
            ServerRequest.invokeLogout(clientConfiguration, this.refreshToken);
        }
        catch (Exception e) {
            ElytronMessages.log.failedToInvokeRemoteLogout(e);
        }
    }

    public boolean isActive() {
        return this.token != null && this.token.isActive() && this.clientConfiguration != null && this.token.getIssuedAt() >= (long)this.clientConfiguration.getNotBefore();
    }

    public boolean isTokenTimeToLiveSufficient(AccessToken token) {
        return token != null && token.getExpiration() - (long)this.clientConfiguration.getTokenMinimumTimeToLive() > (long)Oidc.getCurrentTimeInSeconds();
    }

    public OidcClientConfiguration getOidcClientConfiguration() {
        return this.clientConfiguration;
    }

    public void setCurrentRequestInfo(OidcClientConfiguration clientConfiguration, OidcTokenStore tokenStore) {
        this.clientConfiguration = clientConfiguration;
        this.tokenStore = tokenStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean refreshToken(boolean checkActive) {
        if (checkActive) {
            if (ElytronMessages.log.isTraceEnabled()) {
                ElytronMessages.log.trace("checking whether to refresh.");
            }
            if (this.isActive() && this.isTokenTimeToLiveSufficient(this.token)) {
                return true;
            }
        }
        if (this.clientConfiguration == null || this.refreshToken == null) {
            return false;
        }
        if (ElytronMessages.log.isTraceEnabled()) {
            ElytronMessages.log.trace("Doing refresh");
        }
        RefreshableOidcSecurityContext refreshableOidcSecurityContext = this;
        synchronized (refreshableOidcSecurityContext) {
            AccessToken accessToken;
            IDToken idToken;
            AccessAndIDTokenResponse response;
            if (checkActive) {
                ElytronMessages.log.trace("Checking whether accessToken has been refreshed in another thread already.");
                if (this.isActive() && this.isTokenTimeToLiveSufficient(this.token)) {
                    return true;
                }
            }
            try {
                ElytronMessages.log.trace("Invoking token refresh");
                response = ServerRequest.invokeRefresh(this.clientConfiguration, this.refreshToken);
            }
            catch (IOException e) {
                ElytronMessages.log.refreshTokenFailure(e);
                return false;
            }
            catch (ServerRequest.HttpFailure httpFailure) {
                ElytronMessages.log.refreshTokenFailureStatus(httpFailure.getStatus(), httpFailure.getError());
                return false;
            }
            ElytronMessages.log.trace("Received refresh response");
            String accessTokenString = response.getAccessToken();
            String idTokenString = response.getIDToken();
            Oidc.logToken("\taccess_token", accessTokenString);
            Oidc.logToken("\tid_token", idTokenString);
            try {
                TokenValidator tokenValidator = TokenValidator.builder(this.clientConfiguration).build();
                TokenValidator.VerifiedTokens verifiedTokens = tokenValidator.parseAndVerifyToken(idTokenString, accessTokenString, this.cookie);
                idToken = verifiedTokens.getIdToken();
                accessToken = verifiedTokens.getAccessToken();
                ElytronMessages.log.debug("Token Verification succeeded!");
            }
            catch (OidcException e) {
                ElytronMessages.log.failedVerificationOfToken(e.getMessage());
                return false;
            }
            if (!this.isTokenTimeToLiveSufficient(accessToken)) {
                ElytronMessages.log.failedToRefreshTokenWithALongerTTLThanMin();
                return false;
            }
            if (idToken != null) {
                this.idToken = idToken;
                this.idTokenString = response.getIDToken();
            }
            this.token = accessToken;
            if (response.getRefreshToken() != null) {
                ElytronMessages.log.trace("Setup new refresh accessToken to the security context");
                this.refreshToken = response.getRefreshToken();
                Oidc.logToken("\trefresh_token", this.refreshToken);
            }
            this.tokenString = accessTokenString;
            if (this.tokenStore != null) {
                this.tokenStore.refreshCallback(this);
            }
        }
        return true;
    }
}

