/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.credential._private;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import javax.security.sasl.SaslException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="ELY", length=5)
public interface ElytronMessages
extends BasicLogger {
    public static final ElytronMessages log = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security");
    public static final ElytronMessages tls = (ElytronMessages)Logger.getMessageLogger(ElytronMessages.class, (String)"org.wildfly.security.tls");

    @Message(id=2, value="Parameter %s is empty")
    public IllegalArgumentException emptyParameter(String var1);

    @Message(id=4, value="Unrecognized algorithm \"%s\"")
    public IllegalArgumentException unrecognizedAlgorithm(String var1);

    @Message(id=1037, value="Certificate chain is empty")
    public IllegalArgumentException certificateChainIsEmpty();

    @Message(id=1053, value="Insufficient data to form a digest and a salt")
    public InvalidKeySpecException insufficientDataToFormDigestAndSalt();

    @Message(id=1054, value="Invalid salt \"%s%s\"")
    public IllegalArgumentException invalidSalt(char var1, char var2);

    @Message(id=1055, value="Invalid rounds \"%s%s%s%s\"")
    public IllegalArgumentException invalidRounds(char var1, char var2, char var3, char var4);

    @Message(id=1056, value="Invalid salt \"%s%s%s%s\"")
    public IllegalArgumentException invalidSalt(char var1, char var2, char var3, char var4);

    @Message(id=1059, value="Public and private key algorithm names are mismatched")
    public IllegalArgumentException mismatchedPublicPrivateKeyAlgorithms();

    @Message(id=1061, value="Public key is null")
    public IllegalArgumentException publicKeyIsNull();

    @Message(id=1063, value="Private key is null")
    public IllegalArgumentException privateKeyIsNull();

    @Message(id=2032, value="keySpec must be SecretKeySpect, given: [%s]")
    public InvalidKeySpecException keySpecMustBeSecretKeySpec(String var1);

    @Message(id=2033, value="key must implement SecretKeySpec and keySpec must be SecretKeySpec, given key, keySpec: [%s]")
    public InvalidKeySpecException keyMustImplementSecretKeySpecAndKeySpecMustBeSecretKeySpec(String var1);

    @Message(id=5151, value="Invalid OTP algorithm \"%s\"")
    public SaslException mechInvalidOTPAlgorithm(String var1);

    @Message(id=8001, value="Unrecognized key spec algorithm")
    public InvalidKeySpecException invalidKeySpecUnrecognizedKeySpecAlgorithm();

    @Message(id=8002, value="Password spec cannot be rendered as a string")
    public InvalidKeySpecException invalidKeySpecPasswordSpecCannotBeRenderedAsString();

    @Message(id=8003, value="Unknown crypt string algorithm")
    public InvalidKeySpecException invalidKeySpecUnknownCryptStringAlgorithm();

    @Message(id=8004, value="Invalid character encountered")
    public InvalidKeySpecException invalidKeySpecInvalidCharacterEncountered();

    @Message(id=8005, value="No iteration count terminator given")
    public InvalidKeySpecException invalidKeySpecNoIterationCountTerminatorGiven();

    @Message(id=8006, value="Unexpected end of input string")
    public InvalidKeySpecException invalidKeySpecUnexpectedEndOfInputString();

    @Message(id=8007, value="No salt terminator given")
    public InvalidKeySpecException invalidKeySpecNoSaltTerminatorGiven();

    @Message(id=8008, value="Invalid hash length")
    public IllegalArgumentException invalidHashLength();

    @Message(id=8009, value="Unexpected end of password string")
    public InvalidKeySpecException invalidKeySpecUnexpectedEndOfPasswordString();

    @Message(id=8010, value="Unexpected end of password string")
    public InvalidKeySpecException invalidKeySpecUnexpectedEndOfPasswordStringWithCause(@Cause Throwable var1);

    @Message(id=8011, value="Invalid minor version")
    public InvalidKeySpecException invalidKeySpecInvalidMinorVersion();

    @Message(id=8012, value="Invalid cost: must be a two digit integer")
    public InvalidKeySpecException invalidKeySpecCostMustBeTwoDigitInteger();

    @Message(id=8013, value="No such MessageDigest algorithm for \"%s\"")
    public InvalidKeySpecException invalidKeySpecNoSuchMessageDigestAlgorithm(String var1);

    @Message(id=8014, value="No such MessageDigest algorithm for \"%s\"")
    public InvalidKeyException invalidKeyNoSuchMessageDigestAlgorithm(String var1);

    @Message(id=8015, value="Cannot verify password")
    public InvalidKeyException invalidKeyCannotVerifyPassword(@Cause Throwable var1);

    @Message(id=8017, value="DES crypt password hash must be %d bytes")
    public InvalidKeyException invalidKeyDesCryptPasswordHashMustBeBytes(int var1);

    @Message(id=8018, value="Salt must be %d bytes (%d bits)")
    public InvalidParameterSpecException invalidParameterSpecSaltMustBeBytesBits(int var1, int var2);

    @Message(id=8020, value="Invalid number of rounds. Must be an integer between %d and %d, inclusive")
    public IllegalArgumentException invalidNumberOfRoundsMustBeIntBetween(int var1, int var2);

    @Message(id=8021, value="Invalid salt: must be %d bytes long")
    public IllegalArgumentException invalidSaltMustBeBytesLong(int var1);

    @Message(id=8022, value="BSD DES crypt password hash must be %d bytes")
    public InvalidKeySpecException invalidKeySpecBsdDesCryptPasswordHashMustBeBytes(int var1);

    @Message(id=8023, value="Salt must be %d bytes")
    public InvalidParameterSpecException invalidParameterSpecSaltMustBeBytes(int var1);

    @Message(id=8024, value="BSD DES crypt password hash must be %d bytes")
    public InvalidKeyException invalidKeyBsdDesCryptPasswordHashMustBeBytes(int var1);

    @Message(id=8025, value="Expected to get a \"%s\" as spec, got \"%s\"")
    public InvalidKeySpecException invalidKeySpecExpectedSpecGotSpec(String var1, String var2);

    @Message(id=8026, value="Unknown algorithm or incompatible PasswordSpec")
    public InvalidKeySpecException invalidKeySpecUnknownAlgorithmOrIncompatiblePasswordSpec();

    @Message(id=8027, value="Unknown password type or algorithm")
    public InvalidKeyException invalidKeyUnknownUnknownPasswordTypeOrAlgorithm();

    @Message(id=8028, value="Invalid algorithm \"%s\"")
    public NoSuchAlgorithmException noSuchAlgorithmInvalidAlgorithm(String var1);

    @Message(id=8029, value="Could not obtain key spec encoding identifier.")
    public IllegalArgumentException couldNotObtainKeySpecEncodingIdentifier();

    @Message(id=9000, value="Public and private key parameters are mismatched")
    public IllegalArgumentException mismatchedPublicPrivateKeyParameters();
}

