/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.interfaces;

import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import org.wildfly.common.Assert;
import org.wildfly.security.password.TwoWayPassword;
import org.wildfly.security.password.interfaces.RawMaskedPassword;
import org.wildfly.security.password.spec.IteratedPasswordAlgorithmSpec;
import org.wildfly.security.password.spec.IteratedSaltedPasswordAlgorithmSpec;
import org.wildfly.security.password.spec.MaskedPasswordAlgorithmSpec;
import org.wildfly.security.password.spec.SaltedPasswordAlgorithmSpec;

public interface MaskedPassword
extends TwoWayPassword {
    public static final String ALGORITHM_MASKED_MD5_DES = "masked-MD5-DES";
    public static final String ALGORITHM_MASKED_MD5_DES_CBC_PKCS5 = "masked-MD5-DES-CBC-PKCS5";
    public static final String ALGORITHM_MASKED_MD5_3DES = "masked-MD5-3DES";
    public static final String ALGORITHM_MASKED_MD5_3DES_CBC_PKCS5 = "masked-MD5-3DES-CBC-PKCS5";
    public static final String ALGORITHM_MASKED_SHA1_DES_EDE = "masked-SHA1-DES-EDE";
    public static final String ALGORITHM_MASKED_SHA1_DES_EDE_CBC_PKCS5 = "masked-SHA1-DES-EDE-CBC-PKCS5";
    public static final String ALGORITHM_MASKED_SHA1_RC2_40 = "masked-SHA1-RC2-40";
    public static final String ALGORITHM_MASKED_SHA1_RC2_40_CBC_PKCS5 = "masked-SHA1-RC2-40-CBC-PKCS5";
    public static final String ALGORITHM_MASKED_SHA1_RC2_128 = "masked-SHA1-RC2-128";
    public static final String ALGORITHM_MASKED_SHA1_RC2_128_CBC_PKCS5 = "masked-SHA1-RC2-128-CBC-PKCS5";
    public static final String ALGORITHM_MASKED_SHA1_RC4_40 = "masked-SHA1-RC4-40";
    public static final String ALGORITHM_MASKED_SHA1_RC4_40_ECB = "masked-SHA1-RC4-40-ECB";
    public static final String ALGORITHM_MASKED_SHA1_RC4_128 = "masked-SHA1-RC4-128";
    public static final String ALGORITHM_MASKED_SHA1_RC4_128_ECB = "masked-SHA1-RC4-128-ECB";
    public static final String ALGORITHM_MASKED_HMAC_SHA1_AES_128 = "masked-HMAC-SHA1-AES-128";
    public static final String ALGORITHM_MASKED_HMAC_SHA224_AES_128 = "masked-HMAC-SHA224-AES-128";
    public static final String ALGORITHM_MASKED_HMAC_SHA256_AES_128 = "masked-HMAC-SHA256-AES-128";
    public static final String ALGORITHM_MASKED_HMAC_SHA384_AES_128 = "masked-HMAC-SHA384-AES-128";
    public static final String ALGORITHM_MASKED_HMAC_SHA512_AES_128 = "masked-HMAC-SHA512-AES-128";
    public static final String ALGORITHM_MASKED_HMAC_SHA1_AES_256 = "masked-HMAC-SHA1-AES-256";
    public static final String ALGORITHM_MASKED_HMAC_SHA224_AES_256 = "masked-HMAC-SHA224-AES-256";
    public static final String ALGORITHM_MASKED_HMAC_SHA256_AES_256 = "masked-HMAC-SHA256-AES-256";
    public static final String ALGORITHM_MASKED_HMAC_SHA384_AES_256 = "masked-HMAC-SHA384-AES-256";
    public static final String ALGORITHM_MASKED_HMAC_SHA512_AES_256 = "masked-HMAC-SHA512-AES-256";
    public static final String ALGORITHM_MASKED_PBKDF_HMAC_SHA1 = "masked-PBKDF-HMAC-SHA1";
    public static final String ALGORITHM_MASKED_PBKDF_HMAC_SHA224 = "masked-PBKDF-HMAC-SHA224";
    public static final String ALGORITHM_MASKED_PBKDF_HMAC_SHA256 = "masked-PBKDF-HMAC-SHA256";
    public static final String ALGORITHM_MASKED_PBKDF_HMAC_SHA384 = "masked-PBKDF-HMAC-SHA384";
    public static final String ALGORITHM_MASKED_PBKDF_HMAC_SHA512 = "masked-PBKDF-HMAC-SHA512";

    public static boolean isMaskedAlgorithm(String name) {
        return MaskedPassword.getPBEName(name) != null;
    }

    public static String getPBEName(String name) {
        if (name == null) {
            return null;
        }
        switch (name) {
            case "masked-MD5-DES": {
                return "PBEWithMD5ANDdes";
            }
            case "masked-MD5-DES-CBC-PKCS5": {
                return "PBEWithMD5ANDtripledes";
            }
            case "masked-MD5-3DES": {
                return "PBEWithMD5ANDtripledes";
            }
            case "masked-MD5-3DES-CBC-PKCS5": {
                return "PBEWithMD5AndTRIPLEDES";
            }
            case "masked-SHA1-DES-EDE": {
                return "PBEwithSHA1AndDESede";
            }
            case "masked-SHA1-DES-EDE-CBC-PKCS5": {
                return "PBEwithSHA1AndDESede";
            }
            case "masked-SHA1-RC2-40": {
                return "PBEwithSHA1AndRC2_40";
            }
            case "masked-SHA1-RC2-40-CBC-PKCS5": {
                return "PBEwithSHA1Andrc2_40";
            }
            case "masked-SHA1-RC2-128": {
                return "PBEWithSHA1AndRC2_128";
            }
            case "masked-SHA1-RC2-128-CBC-PKCS5": {
                return "PBEWithSHA1andRC2_128";
            }
            case "masked-SHA1-RC4-40": {
                return "PBEWithSHA1AndRC4_40";
            }
            case "masked-SHA1-RC4-40-ECB": {
                return "PBEWithsha1AndRC4_40";
            }
            case "masked-SHA1-RC4-128": {
                return "PBEWithSHA1AndRC4_128";
            }
            case "masked-SHA1-RC4-128-ECB": {
                return "pbeWithSHA1AndRC4_128";
            }
            case "masked-HMAC-SHA1-AES-128": {
                return "PBEWithHmacSHA1AndAES_128";
            }
            case "masked-HMAC-SHA224-AES-128": {
                return "PBEWithHmacSHA224AndAES_128";
            }
            case "masked-HMAC-SHA256-AES-128": {
                return "PBEWithHmacSHA256AndAES_128";
            }
            case "masked-HMAC-SHA384-AES-128": {
                return "PBEWithHmacSHA384AndAES_128";
            }
            case "masked-HMAC-SHA512-AES-128": {
                return "PBEWithHmacSHA512AndAES_128";
            }
            case "masked-HMAC-SHA1-AES-256": {
                return "PBEWithHmacSHA1AndAES_256";
            }
            case "masked-HMAC-SHA224-AES-256": {
                return "PBEWithHmacSHA224AndAES_256";
            }
            case "masked-HMAC-SHA256-AES-256": {
                return "PBEWithHmacSHA256AndAES_256";
            }
            case "masked-HMAC-SHA384-AES-256": {
                return "PBEWithHmacSHA384AndAES_256";
            }
            case "masked-HMAC-SHA512-AES-256": {
                return "PBEWithHmacSHA512AndAES_256";
            }
            case "masked-PBKDF-HMAC-SHA1": {
                return "PBKDF2WithHmacSHA1";
            }
            case "masked-PBKDF-HMAC-SHA224": {
                return "PBKDF2WithHmacSHA224";
            }
            case "masked-PBKDF-HMAC-SHA256": {
                return "PBKDF2WithHmacSHA256";
            }
            case "masked-PBKDF-HMAC-SHA384": {
                return "PBKDF2WithHmacSHA384";
            }
            case "masked-PBKDF-HMAC-SHA512": {
                return "PBKDF2WithHmacSHA512";
            }
        }
        return null;
    }

    public char[] getInitialKeyMaterial();

    public int getIterationCount();

    public byte[] getSalt();

    public byte[] getMaskedPasswordBytes();

    @Override
    default public MaskedPasswordAlgorithmSpec getParameterSpec() {
        return new MaskedPasswordAlgorithmSpec(this.getInitialKeyMaterial(), this.getIterationCount(), this.getSalt());
    }

    @Override
    default public boolean impliesParameters(AlgorithmParameterSpec parameterSpec) {
        Assert.checkNotNullParam((String)"parameterSpec", (Object)parameterSpec);
        if (parameterSpec instanceof MaskedPasswordAlgorithmSpec) {
            MaskedPasswordAlgorithmSpec spec = (MaskedPasswordAlgorithmSpec)parameterSpec;
            return Arrays.equals(this.getInitialKeyMaterial(), spec.getInitialKeyMaterial()) && this.getIterationCount() <= spec.getIterationCount() && Arrays.equals(this.getSalt(), spec.getSalt());
        }
        if (parameterSpec instanceof SaltedPasswordAlgorithmSpec) {
            SaltedPasswordAlgorithmSpec spec = (SaltedPasswordAlgorithmSpec)parameterSpec;
            return Arrays.equals(this.getSalt(), spec.getSalt());
        }
        if (parameterSpec instanceof IteratedPasswordAlgorithmSpec) {
            IteratedPasswordAlgorithmSpec spec = (IteratedPasswordAlgorithmSpec)parameterSpec;
            return this.getIterationCount() <= spec.getIterationCount();
        }
        if (parameterSpec instanceof IteratedSaltedPasswordAlgorithmSpec) {
            IteratedSaltedPasswordAlgorithmSpec spec = (IteratedSaltedPasswordAlgorithmSpec)parameterSpec;
            return Arrays.equals(this.getSalt(), spec.getSalt()) && this.getIterationCount() <= spec.getIterationCount();
        }
        return false;
    }

    @Override
    public MaskedPassword clone();

    public static MaskedPassword createRaw(String algorithm, char[] initialKeyMaterial, int iterationCount, byte[] salt, byte[] maskedPasswordBytes) {
        Assert.checkNotNullParam((String)"algorithm", (Object)algorithm);
        Assert.checkNotNullParam((String)"initialKeyMaterial", (Object)initialKeyMaterial);
        Assert.checkNotNullParam((String)"salt", (Object)salt);
        Assert.checkNotNullParam((String)"maskedPasswordBytes", (Object)maskedPasswordBytes);
        return new RawMaskedPassword(algorithm, (char[])initialKeyMaterial.clone(), iterationCount, (byte[])salt.clone(), (byte[])maskedPasswordBytes.clone());
    }
}

