/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.net.URI;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.auth.client.MatchRule;

class MatchPathRule
extends MatchRule {
    private final String pathSpec;

    MatchPathRule(MatchRule parent, String pathSpec) {
        super(parent);
        this.pathSpec = pathSpec.endsWith("/") ? pathSpec : pathSpec + "/";
    }

    @Override
    public boolean matches(URI uri, String abstractType, String abstractTypeAuthority) {
        return uri.isAbsolute() && this.prefixes(uri.getPath()) && super.matches(uri, abstractType, abstractTypeAuthority);
    }

    @Override
    MatchRule reparent(MatchRule newParent) {
        return new MatchPathRule(newParent, this.pathSpec);
    }

    @Override
    boolean halfEqual(MatchRule other) {
        return this.pathSpec.equals(other.getMatchPath()) && this.parentHalfEqual(other);
    }

    @Override
    public String getMatchPath() {
        return this.pathSpec;
    }

    @Override
    public boolean isPathMatched() {
        return true;
    }

    @Override
    public int hashCode() {
        return HashMath.multiHashUnordered((int)this.parentHashCode(), (int)3923, (int)this.pathSpec.hashCode());
    }

    private boolean prefixes(String pathSpec) {
        if (pathSpec == null) {
            pathSpec = "/";
        }
        if (!((String)pathSpec).startsWith("/")) {
            pathSpec = "/" + (String)pathSpec;
        }
        if (!((String)pathSpec).endsWith("/")) {
            pathSpec = (String)pathSpec + "/";
        }
        return ((String)pathSpec).startsWith(this.pathSpec);
    }

    @Override
    StringBuilder asString(StringBuilder b) {
        return this.parentAsString(b).append("path=~").append(this.pathSpec).append(',');
    }
}

