/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.net.URI;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.auth.client.MatchRule;

class MatchSchemeSpecificPartRule
extends MatchRule {
    private final String name;

    MatchSchemeSpecificPartRule(MatchRule parent, String name) {
        super(parent);
        this.name = name;
    }

    @Override
    public boolean matches(URI uri, String abstractType, String abstractTypeAuthority) {
        String ssp;
        int idx;
        if (!uri.isOpaque()) {
            return false;
        }
        String scheme = uri.getScheme();
        String name = scheme.equals("domain") ? ((idx = (ssp = uri.getSchemeSpecificPart()).indexOf(64)) != -1 ? ssp.substring(idx + 1, ssp.length()) : ssp) : uri.getSchemeSpecificPart();
        return name.equals(this.name) && super.matches(uri, abstractType, abstractTypeAuthority);
    }

    @Override
    MatchRule reparent(MatchRule newParent) {
        return new MatchSchemeSpecificPartRule(newParent, this.name);
    }

    @Override
    boolean halfEqual(MatchRule other) {
        return this.name.equals(other.getMatchUrnName()) && this.parentHalfEqual(other);
    }

    @Override
    public int hashCode() {
        return HashMath.multiHashUnordered((int)this.parentHashCode(), (int)2143, (int)this.name.hashCode());
    }

    @Override
    StringBuilder asString(StringBuilder b) {
        return this.parentAsString(b).append("urn=").append(this.name).append(',');
    }
}

