/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.tools.client;

import java.io.Console;
import java.util.Arrays;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;

public class ClientCallbackHandler
implements CallbackHandler {
    private final Console console = System.console();
    private boolean promptShown = false;
    private String username;
    private char[] password;

    public ClientCallbackHandler() {
        this.username = null;
        this.password = null;
    }

    public ClientCallbackHandler(String username, String password) {
        this.username = username;
        if (password != null) {
            this.password = password.toCharArray();
        }
    }

    public ClientCallbackHandler(String username, char[] password) {
        this.username = username;
        if (password != null) {
            this.password = Arrays.copyOf(password, password.length);
        }
    }

    @Override
    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        if (callbacks.length == 1 && callbacks[0] instanceof NameCallback) {
            ((NameCallback)callbacks[0]).setName("anonymous demo user");
            return;
        }
        for (Callback current : callbacks) {
            if (current instanceof RealmCallback) {
                RealmCallback rcb = (RealmCallback)current;
                String defaultText = rcb.getDefaultText();
                rcb.setText(defaultText);
                this.prompt(defaultText);
                continue;
            }
            if (current instanceof RealmChoiceCallback) {
                throw new UnsupportedCallbackException(current, "Realm choice not currently supported.");
            }
            if (current instanceof NameCallback) {
                NameCallback ncb = (NameCallback)current;
                String userName = this.obtainUsername();
                ncb.setName(userName);
                continue;
            }
            if (current instanceof PasswordCallback) {
                PasswordCallback pcb = (PasswordCallback)current;
                char[] password = this.obtainPassword();
                pcb.setPassword(password);
                continue;
            }
            throw new UnsupportedCallbackException(current);
        }
    }

    private void prompt(String realm) {
        if (!this.promptShown) {
            this.promptShown = true;
        }
    }

    private String obtainUsername() {
        if (this.username == null) {
            this.checkConsole();
            this.username = this.console.readLine("Username:", new Object[0]);
        }
        return this.username;
    }

    private char[] obtainPassword() {
        if (this.password == null) {
            this.checkConsole();
            this.password = this.console.readPassword("Password:", new Object[0]);
        }
        return this.password;
    }

    private void checkConsole() {
        if (this.console == null) {
            throw new IllegalStateException("The environment does not have a usable console. Cannot prompt for user name and password");
        }
    }
}

