/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.provision;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoExecutionException;
import org.eclipse.aether.repository.RemoteRepository;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelManifestCoordinate;
import org.wildfly.channel.Repository;

public class ChannelConfiguration {
    private static final Pattern FILE_MATCHER = Pattern.compile("^(file:|http://|https://).*");
    private ChannelManifestCoordinate manifest;
    private boolean multipleManifest;
    private String name;

    public ChannelManifestCoordinate getManifest() {
        return this.manifest;
    }

    public void set(String channel) {
        if (FILE_MATCHER.matcher(channel).matches()) {
            try {
                this.manifest = new ChannelManifestCoordinate(new URL(channel));
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Failed to parse URL for " + channel, e);
            }
        } else {
            String[] coords = channel.split(":");
            if (coords.length > 2) {
                this.manifest = new ChannelManifestCoordinate(coords[0], coords[1], coords[2]);
            } else if (coords.length == 2) {
                this.manifest = new ChannelManifestCoordinate(coords[0], coords[1]);
            } else {
                throw new IllegalArgumentException("A channel must be a Maven GAV in the format groupId:artifactId:version. The groupId and artifactId are both required.");
            }
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setManifest(ChannelManifestCoordinate manifest) {
        if (this.manifest != null) {
            this.multipleManifest = true;
        }
        this.manifest = manifest;
    }

    private void validate() throws MojoExecutionException {
        if (this.getManifest() == null) {
            throw new MojoExecutionException("Invalid Channel. No manifest specified.");
        }
        if (this.multipleManifest) {
            throw new MojoExecutionException("Invalid Channel. More than one manifest has been set.");
        }
        ChannelManifestCoordinate coordinates = this.getManifest();
        if (coordinates.getUrl() == null && coordinates.getGroupId() == null && coordinates.getArtifactId() == null) {
            throw new MojoExecutionException("Invalid Channel. Manifest must contain a groupId, artifactId and (optional) version or an url.");
        }
        if (coordinates.getUrl() == null) {
            if (coordinates.getGroupId() == null) {
                throw new MojoExecutionException("Invalid Channel. Manifest groupId is null.");
            }
            if (coordinates.getArtifactId() == null) {
                throw new MojoExecutionException("Invalid Channel. Manifest artifactId is null.");
            }
        } else {
            if (coordinates.getGroupId() != null) {
                throw new MojoExecutionException("Invalid Channel. Manifest groupId is set although an URL is provided.");
            }
            if (coordinates.getArtifactId() != null) {
                throw new MojoExecutionException("Invalid Channel. Manifest artifactId is set although an URL is provided.");
            }
            if (coordinates.getVersion() != null) {
                throw new MojoExecutionException("Invalid Channel. Manifest version is set although an URL is provided.");
            }
        }
    }

    public Channel toChannel(List<RemoteRepository> repositories) throws MojoExecutionException {
        this.validate();
        ArrayList<Repository> repos = new ArrayList<Repository>();
        for (RemoteRepository r : repositories) {
            repos.add(new Repository(r.getId(), r.getUrl()));
        }
        return new Channel(this.name, null, null, repos, this.getManifest(), null, null);
    }
}

