/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.cli;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.galleon.maven.plugin.util.MavenArtifactRepositoryManager;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.wildfly.plugin.cli.CommandConfiguration;
import org.wildfly.plugin.cli.CommandExecutor;
import org.wildfly.plugin.common.AbstractServerConnection;
import org.wildfly.plugin.core.MavenRepositoriesEnricher;
import org.wildfly.plugin.tools.server.ServerManager;

@Mojo(name="execute-commands", threadSafe=true)
public class ExecuteCommandsMojo
extends AbstractServerConnection {
    @Parameter(defaultValue="false", property="wildfly.skip")
    private boolean skip;
    @Parameter(defaultValue="false", property="wildfly.batch")
    private boolean batch;
    @Parameter(alias="jboss-home", property="jboss-as.home")
    private String jbossHome;
    @Parameter(alias="system-properties")
    private Map<String, String> systemProperties;
    @Parameter
    private List<File> propertiesFiles = new ArrayList<File>();
    @Parameter(property="wildfly.commands")
    private List<String> commands = new ArrayList<String>();
    @Parameter(property="wildfly.scripts")
    private List<File> scripts = new ArrayList<File>();
    @Parameter(alias="fail-on-error", defaultValue="true", property="wildfly.failOnError")
    private boolean failOnError = true;
    @Parameter(defaultValue="false", property="wildfly.fork")
    private boolean fork;
    @Parameter(name="offline", defaultValue="false", property="wildfly.offline")
    private boolean offline = false;
    @Parameter(name="stdout", defaultValue="System.out", property="wildfly.stdout")
    private String stdout;
    @Parameter(alias="java-opts", property="wildfly.javaOpts")
    private String[] javaOpts;
    @Parameter(alias="auto-reload", defaultValue="true", property="wildfly.auto.reload")
    private boolean autoReload;
    @Inject
    RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    private RepositorySystemSession session;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    private List<RemoteRepository> repositories;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    MavenSession mavenSession;
    @Parameter(defaultValue="${project.build.directory}", readonly=true, required=true)
    private File buildDir;
    @Parameter(alias="resolve-expressions", defaultValue="false", property="wildfly.resolveExpressions")
    private boolean resolveExpressions;
    @Inject
    private CommandExecutor commandExecutor;
    private MavenRepoManager mavenRepoManager;

    @Override
    public String goal() {
        return "execute-commands";
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        block12: {
            if (this.skip) {
                this.getLog().debug((CharSequence)"Skipping commands execution");
                return;
            }
            MavenRepositoriesEnricher.enrich((MavenSession)this.mavenSession, (MavenProject)this.project, this.repositories);
            this.mavenRepoManager = new MavenArtifactRepositoryManager(this.repoSystem, this.session, this.repositories);
            CommandConfiguration.Builder cmdConfigBuilder = (CommandConfiguration.Builder)((CommandConfiguration.Builder)((CommandConfiguration.Builder)((CommandConfiguration.Builder)((CommandConfiguration.Builder)((CommandConfiguration.Builder)((CommandConfiguration.Builder)((CommandConfiguration.Builder)((CommandConfiguration.Builder)((CommandConfiguration.Builder)((CommandConfiguration.Builder)((CommandConfiguration.Builder)((CommandConfiguration.Builder)((CommandConfiguration.Builder)CommandConfiguration.of(() -> this.createClient(), () -> this.getClientConfiguration()).addCommands(this.commands)).addJvmOptions(this.javaOpts)).addPropertiesFiles(this.propertiesFiles)).addScripts(this.scripts)).addSystemProperties((Map)this.systemProperties)).setBatch(this.batch)).setFailOnError(this.failOnError)).setFork(this.fork)).setJBossHome(this.jbossHome)).setOffline(this.offline)).setAutoReload(this.autoReload)).setStdout(this.stdout)).setTimeout(this.timeout)).setResolveExpression(this.resolveExpressions);
            if (this.fork) {
                cmdConfigBuilder.setJBossHome(this.getInstallation(this.buildDir.toPath().resolve("server")));
            }
            this.commandExecutor.execute(cmdConfigBuilder.build(), this.mavenRepoManager);
            if (!this.offline) {
                try (ModelControllerClient client = this.createClient();){
                    String serverState = ((ServerManager)ServerManager.builder().client(client).build().get(this.timeout, TimeUnit.SECONDS)).serverState();
                    if (!"running".equals(serverState)) {
                        this.getLog().warn((CharSequence)String.format("The server may be in an unexpected state for further interaction. The current state is %s", serverState));
                    }
                }
                catch (IOException | InterruptedException | ExecutionException | TimeoutException e) {
                    Log log = this.getLog();
                    log.warn((CharSequence)String.format("Failed to determine the server-state. The server may be in an unexpected state. Failure: %s", e.getMessage()));
                    if (!log.isDebugEnabled()) break block12;
                    log.debug((Throwable)e);
                }
            }
        }
    }

    @Override
    protected int getManagementPort() {
        if (this.javaOpts != null) {
            for (String opt : this.javaOpts) {
                if (opt.startsWith("-Djboss.management.http.port=") || opt.startsWith("-Djboss.management.https.port=")) {
                    int equals = opt.indexOf(61);
                    return Integer.parseInt(opt.substring(equals + 1).trim());
                }
                if (!opt.startsWith("-Djboss.socket.binding.port-offset=")) continue;
                int equals = opt.indexOf(61);
                return super.getManagementPort() + Integer.parseInt(opt.substring(equals + 1).trim());
            }
        }
        return super.getManagementPort();
    }

    @Override
    protected String getManagementHostName() {
        if (this.javaOpts != null) {
            for (String opt : this.javaOpts) {
                if (!opt.startsWith("-Djboss.bind.address.management=")) continue;
                int equals = opt.indexOf(61);
                return opt.substring(equals + 1).trim();
            }
        }
        return super.getManagementHostName();
    }

    public void setJavaOpts(String value) {
        if (value != null) {
            this.javaOpts = value.split("\\s+");
        }
    }

    private Path getInstallation(Path installDir) throws MojoFailureException {
        if (this.jbossHome != null) {
            return Paths.get(this.jbossHome, new String[0]);
        }
        if (!Files.exists(installDir, new LinkOption[0])) {
            throw new MojoFailureException("No server installed.");
        }
        return installDir;
    }
}

