/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.openssl;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import org.wildfly.openssl.OpenSSLSessionStats;
import org.wildfly.openssl.OpenSSlSession;
import org.wildfly.openssl.SSL;

abstract class OpenSSLSessionContext
implements SSLSessionContext {
    private final Map<Key, OpenSSlSession> sessions = new ConcurrentHashMap<Key, OpenSSlSession>();
    private final OpenSSLSessionStats stats;
    final long context;

    OpenSSLSessionContext(long context) {
        this.context = context;
        this.stats = new OpenSSLSessionStats(context);
    }

    @Override
    public SSLSession getSession(byte[] bytes) {
        return this.sessions.get(new Key(bytes));
    }

    @Override
    public Enumeration<byte[]> getIds() {
        final Iterator<Key> keys = new HashSet<Key>(this.sessions.keySet()).iterator();
        return new Enumeration<byte[]>(){

            @Override
            public boolean hasMoreElements() {
                return keys.hasNext();
            }

            @Override
            public byte[] nextElement() {
                return ((Key)keys.next()).data;
            }
        };
    }

    public void setTicketKeys(byte[] keys) {
        if (keys == null) {
            throw new IllegalArgumentException("null ticket keys");
        }
        SSL.getInstance().setSessionTicketKeys(this.context, keys);
    }

    public OpenSSLSessionStats stats() {
        return this.stats;
    }

    void remove(byte[] session) {
        this.sessions.remove(new Key(session));
    }

    synchronized void sessionCreatedCallback(long ssl, long session, byte[] sessionId) {
        OpenSSlSession openSSlSession = new OpenSSlSession(true, this);
        openSSlSession.initialised(session, ssl, sessionId);
        this.sessions.put(new Key(sessionId), openSSlSession);
    }

    synchronized void sessionRemovedCallback(byte[] sessionId) {
        this.sessions.remove(new Key(sessionId));
    }

    public void mergeHandshakeSession(SSLSession handshakeSession, byte[] sessionId) {
        Key k = new Key(sessionId);
        OpenSSlSession session = this.sessions.get(k);
        if (session == null) {
            return;
        }
        for (String key : handshakeSession.getValueNames()) {
            session.putValue(key, handshakeSession.getValue(key));
        }
    }

    protected void clientSessionCreated(long ssl, long sessionPointer, byte[] sessionId) {
        Key key = new Key(sessionId);
        OpenSSlSession existing = this.sessions.get(key);
        if (existing != null) {
            return;
        }
        OpenSSlSession session = new OpenSSlSession(false, this);
        session.initialised(sessionPointer, ssl, sessionId);
        this.sessions.put(key, session);
    }

    private static class Key {
        private final byte[] data;

        private Key(byte[] data) {
            this.data = data;
        }

        public byte[] getData() {
            return this.data;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Arrays.equals(this.data, key.data);
        }

        public int hashCode() {
            return this.data != null ? Arrays.hashCode(this.data) : 0;
        }
    }
}

