/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.openssl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.wildfly.openssl.DefaultByteBufferPool;
import org.wildfly.openssl.OpenSSLEngine;
import org.wildfly.openssl.OpenSSLInputStream;
import org.wildfly.openssl.OpenSSLOutputStream;

public class OpenSSLSocket
extends SSLSocket {
    private final OpenSSLEngine sslEngine;
    private final List<HandshakeCompletedListener> handshakeCompletedListenerList = new ArrayList<HandshakeCompletedListener>();
    private final OpenSSLOutputStream sslOut;
    private final OpenSSLInputStream sslIn;
    private static final ByteBuffer EMPTY_DIRECT = ByteBuffer.allocateDirect(0);
    private DefaultByteBufferPool.PooledByteBuffer unwrappedData;
    private DefaultByteBufferPool.PooledByteBuffer dataToUnwrap;
    private boolean handshakeDone = false;
    private final Socket delegate;
    private final boolean autoclose;

    protected OpenSSLSocket(OpenSSLEngine sslEngine) {
        this.sslEngine = sslEngine;
        this.sslOut = new OpenSSLOutputStream(this);
        this.sslIn = new OpenSSLInputStream(this);
        this.delegate = this;
        this.autoclose = true;
    }

    protected OpenSSLSocket(String host, int port, OpenSSLEngine sslEngine) throws IOException, UnknownHostException {
        super(host, port);
        this.sslEngine = sslEngine;
        this.sslOut = new OpenSSLOutputStream(this);
        this.sslIn = new OpenSSLInputStream(this);
        this.delegate = this;
        this.autoclose = true;
    }

    protected OpenSSLSocket(InetAddress address, int port, OpenSSLEngine sslEngine) throws IOException {
        super(address, port);
        this.sslEngine = sslEngine;
        this.sslOut = new OpenSSLOutputStream(this);
        this.sslIn = new OpenSSLInputStream(this);
        this.delegate = this;
        this.autoclose = true;
    }

    protected OpenSSLSocket(String host, int port, InetAddress clientAddress, int clientPort, OpenSSLEngine sslEngine) throws IOException, UnknownHostException {
        super(host, port, clientAddress, clientPort);
        this.sslEngine = sslEngine;
        this.sslOut = new OpenSSLOutputStream(this);
        this.sslIn = new OpenSSLInputStream(this);
        this.delegate = this;
        this.autoclose = true;
    }

    protected OpenSSLSocket(InetAddress address, int port, InetAddress clientAddress, int clientPort, OpenSSLEngine sslEngine) throws IOException {
        super(address, port, clientAddress, clientPort);
        this.sslEngine = sslEngine;
        this.sslOut = new OpenSSLOutputStream(this);
        this.sslIn = new OpenSSLInputStream(this);
        this.delegate = this;
        this.autoclose = true;
    }

    protected OpenSSLSocket(Socket socket, boolean autoclose, OpenSSLEngine sslEngine) {
        this.sslEngine = sslEngine;
        this.sslOut = new OpenSSLOutputStream(this);
        this.sslIn = new OpenSSLInputStream(this);
        this.delegate = socket;
        this.autoclose = autoclose;
    }

    protected OpenSSLSocket(Socket socket, boolean autoclose, String host, int port, OpenSSLEngine sslEngine) throws IOException, UnknownHostException {
        super(host, port);
        this.sslEngine = sslEngine;
        this.sslOut = new OpenSSLOutputStream(this);
        this.sslIn = new OpenSSLInputStream(this);
        this.delegate = socket;
        this.autoclose = autoclose;
    }

    protected OpenSSLSocket(Socket socket, boolean autoclose, InetAddress address, int port, OpenSSLEngine sslEngine) throws IOException {
        super(address, port);
        this.sslEngine = sslEngine;
        this.sslOut = new OpenSSLOutputStream(this);
        this.sslIn = new OpenSSLInputStream(this);
        this.delegate = socket;
        this.autoclose = autoclose;
    }

    protected OpenSSLSocket(Socket socket, boolean autoclose, String host, int port, InetAddress clientAddress, int clientPort, OpenSSLEngine sslEngine) throws IOException, UnknownHostException {
        super(host, port, clientAddress, clientPort);
        this.sslEngine = sslEngine;
        this.sslOut = new OpenSSLOutputStream(this);
        this.sslIn = new OpenSSLInputStream(this);
        this.delegate = socket;
        this.autoclose = autoclose;
    }

    protected OpenSSLSocket(Socket socket, boolean autoclose, InetAddress address, int port, InetAddress clientAddress, int clientPort, OpenSSLEngine sslEngine) throws IOException {
        super(address, port, clientAddress, clientPort);
        this.sslEngine = sslEngine;
        this.sslOut = new OpenSSLOutputStream(this);
        this.sslIn = new OpenSSLInputStream(this);
        this.delegate = socket;
        this.autoclose = autoclose;
    }

    @Override
    public SSLSession getHandshakeSession() {
        return this.sslEngine.getHandshakeSession();
    }

    @Override
    public SSLParameters getSSLParameters() {
        return this.sslEngine.getSSLParameters();
    }

    @Override
    public void setSSLParameters(SSLParameters params) {
        this.sslEngine.setSSLParameters(params);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.sslIn;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.sslOut;
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.sslEngine.getSupportedCipherSuites();
    }

    @Override
    public String[] getEnabledCipherSuites() {
        return this.sslEngine.getEnabledCipherSuites();
    }

    @Override
    public void setEnabledCipherSuites(String[] suites) {
        this.sslEngine.setEnabledProtocols(suites);
    }

    @Override
    public String[] getSupportedProtocols() {
        return this.sslEngine.getSupportedProtocols();
    }

    @Override
    public String[] getEnabledProtocols() {
        return this.sslEngine.getEnabledProtocols();
    }

    @Override
    public void setEnabledProtocols(String[] protocols) {
        this.sslEngine.setEnabledProtocols(protocols);
    }

    @Override
    public SSLSession getSession() {
        return this.sslEngine.getSession();
    }

    @Override
    public void addHandshakeCompletedListener(HandshakeCompletedListener listener) {
        this.handshakeCompletedListenerList.add(listener);
    }

    @Override
    public void removeHandshakeCompletedListener(HandshakeCompletedListener listener) {
        this.handshakeCompletedListenerList.remove(listener);
    }

    @Override
    public void startHandshake() throws IOException {
        this.handshakeDone = false;
        this.sslEngine.beginHandshake();
        this.runHandshake();
    }

    @Override
    public void setUseClientMode(boolean mode) {
        this.sslEngine.setUseClientMode(mode);
    }

    @Override
    public boolean getUseClientMode() {
        return this.sslEngine.getUseClientMode();
    }

    @Override
    public void setNeedClientAuth(boolean need) {
        this.sslEngine.setNeedClientAuth(need);
    }

    @Override
    public boolean getNeedClientAuth() {
        return this.sslEngine.getNeedClientAuth();
    }

    @Override
    public void setWantClientAuth(boolean want) {
        this.sslEngine.setWantClientAuth(want);
    }

    @Override
    public boolean getWantClientAuth() {
        return this.sslEngine.getWantClientAuth();
    }

    @Override
    public void setEnableSessionCreation(boolean flag) {
        this.sslEngine.setEnableSessionCreation(flag);
    }

    @Override
    public boolean getEnableSessionCreation() {
        return this.sslEngine.getEnableSessionCreation();
    }

    private void invokeHandshakeListeners() {
        HandshakeCompletedEvent event = new HandshakeCompletedEvent(this, this.getSession());
        for (HandshakeCompletedListener listener : new ArrayList<HandshakeCompletedListener>(this.handshakeCompletedListenerList)) {
            listener.handshakeCompleted(event);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.unwrappedData != null) {
            this.unwrappedData.close();
            this.unwrappedData = null;
        }
        if (this.dataToUnwrap != null) {
            this.dataToUnwrap.close();
            this.dataToUnwrap = null;
        }
        if (this.delegate == this) {
            super.close();
        } else if (this.autoclose) {
            this.delegate.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runHandshake() throws IOException {
        if (this.handshakeDone) {
            return;
        }
        try (DefaultByteBufferPool.PooledByteBuffer directPooled = DefaultByteBufferPool.DIRECT_POOL.allocate();){
            ByteBuffer buffer = directPooled.getBuffer();
            boolean write = this.sslEngine.getUseClientMode();
            while (true) {
                Throwable throwable2;
                DefaultByteBufferPool.PooledByteBuffer indirectPooled;
                SSLEngineResult result;
                if (write) {
                    buffer.clear();
                    result = this.sslEngine.wrap(EMPTY_DIRECT, buffer);
                    if (result.bytesProduced() > 0) {
                        buffer.flip();
                        indirectPooled = DefaultByteBufferPool.INDIRECT_POOL.allocate();
                        throwable2 = null;
                        try {
                            ByteBuffer ind = indirectPooled.getBuffer();
                            ind.put(buffer);
                            ind.flip();
                            this.getDelegateOutputStream().write(ind.array(), ind.arrayOffset() + ind.position(), ind.remaining());
                        }
                        catch (Throwable ind) {
                            throwable2 = ind;
                            throw ind;
                        }
                        finally {
                            if (indirectPooled != null) {
                                if (throwable2 != null) {
                                    try {
                                        indirectPooled.close();
                                    }
                                    catch (Throwable ind) {
                                        throwable2.addSuppressed(ind);
                                    }
                                } else {
                                    indirectPooled.close();
                                }
                            }
                        }
                    }
                } else {
                    indirectPooled = DefaultByteBufferPool.INDIRECT_POOL.allocate();
                    throwable2 = null;
                    try {
                        int readOffset = 0;
                        do {
                            int read = this.getDelegateInputStream().read(indirectPooled.getBuffer().array(), indirectPooled.getBuffer().arrayOffset() + readOffset, indirectPooled.getBuffer().remaining());
                            readOffset += read;
                            if (read <= 0) {
                                this.close();
                                throw new SSLException("handshake failed: underlying connection was closed");
                            }
                            indirectPooled.getBuffer().limit(readOffset);
                            if (this.unwrappedData != null) {
                                throw new IllegalStateException("Running handshake with buffered unwrapped data");
                            }
                            this.unwrappedData = DefaultByteBufferPool.DIRECT_POOL.allocate();
                            buffer.clear();
                            buffer.put(indirectPooled.getBuffer());
                            buffer.flip();
                        } while ((result = this.sslEngine.unwrap(buffer, this.unwrappedData.getBuffer())).getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW);
                        if (this.unwrappedData.getBuffer().position() == 0) {
                            this.unwrappedData.close();
                            this.unwrappedData = null;
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (indirectPooled != null) {
                            if (throwable2 != null) {
                                try {
                                    indirectPooled.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                            } else {
                                indirectPooled.close();
                            }
                        }
                    }
                }
                if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
                    this.handshakeDone = true;
                    this.invokeHandshakeListeners();
                    return;
                }
                if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                    Runnable r;
                    while ((r = this.sslEngine.getDelegatedTask()) != null) {
                        r.run();
                    }
                    write = true;
                    continue;
                }
                if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                    write = false;
                    continue;
                }
                write = true;
                continue;
                break;
            }
        }
    }

    private InputStream getDelegateInputStream() throws IOException {
        if (this.delegate == this) {
            return super.getInputStream();
        }
        return this.delegate.getInputStream();
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        this.read(b);
        return b[0] & 0xFF;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.unwrappedData != null) {
            buf = this.unwrappedData.getBuffer();
            oldLimit = buf.limit();
            read = buf.remaining();
            if (len < buf.remaining()) {
                buf.limit(buf.position() + len);
                read = len;
            }
            buf.get(b, off, len);
            buf.limit(oldLimit);
            if (buf.hasRemaining() != false) return read;
            this.unwrappedData.close();
            this.unwrappedData = null;
            return read;
        }
        this.runHandshake();
        pooled = DefaultByteBufferPool.DIRECT_POOL.allocate();
        var5_7 = null;
        try {
            buffer = pooled.getBuffer();
            readOffset = 0;
            if (this.dataToUnwrap != null) {
                indirectPooled = this.dataToUnwrap;
                this.dataToUnwrap = null;
                readOffset = indirectPooled.getBuffer().limit();
            } else {
                indirectPooled = DefaultByteBufferPool.INDIRECT_POOL.allocate();
            }
            freeIndirect = true;
            this.unwrappedData = DefaultByteBufferPool.DIRECT_POOL.allocate();
            while ((readOffset += (read = this.getDelegateInputStream().read(indirectPooled.getBuffer().array(), indirectPooled.getBuffer().arrayOffset() + readOffset, indirectPooled.getBuffer().remaining()))) > 0) {
                indirectPooled.getBuffer().limit(readOffset);
                buffer.clear();
                buffer.put(indirectPooled.getBuffer());
                buffer.flip();
                result = this.sslEngine.unwrap(buffer, this.unwrappedData.getBuffer());
                this.unwrappedData.getBuffer().flip();
                if (result.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW || result.bytesProduced() == 0) continue;
                ret = Math.min(len, this.unwrappedData.getBuffer().remaining());
                this.unwrappedData.getBuffer().get(b, off, ret);
                if (buffer.hasRemaining()) {
                    freeIndirect = false;
                    indirectPooled.getBuffer().clear();
                    indirectPooled.getBuffer().put(buffer);
                    this.dataToUnwrap = indirectPooled;
                }
                var13_18 = ret;
                if (!freeIndirect) ** GOTO lbl73
                ** GOTO lbl72
            }
            ** GOTO lbl78
            {
                catch (IOException | RuntimeException e) {
                    if (this.unwrappedData == null) throw e;
                    this.unwrappedData.close();
                    this.unwrappedData = null;
                    throw e;
                }
                catch (Throwable var15_20) {
                    if (freeIndirect) {
                        indirectPooled.close();
                    }
                    if (this.unwrappedData == null) throw var15_20;
                    if (this.unwrappedData.getBuffer().position() != 0) throw var15_20;
                    this.unwrappedData.close();
                    this.unwrappedData = null;
                    throw var15_20;
                }
lbl72:
                // 1 sources

                indirectPooled.close();
lbl73:
                // 2 sources

                if (this.unwrappedData == null) return var13_18;
                if (this.unwrappedData.getBuffer().position() != 0) return var13_18;
                this.unwrappedData.close();
                this.unwrappedData = null;
                return var13_18;
lbl78:
                // 1 sources

                ** try [egrp 4[TRYBLOCK] [8 : 500->593)] { 
lbl-1000:
                // 1 sources

                {
                    this.close();
                    throw new SSLException("handshake failed: underlying connection was closed");
                }
            }
        }
lbl81:
        // 2 sources

        catch (Throwable var6_10) {
            var5_7 = var6_10;
            throw var6_10;
        }
        finally {
            if (pooled != null) {
                if (var5_7 != null) {
                    try {
                        pooled.close();
                    }
                    catch (Throwable var14_19) {
                        var5_7.addSuppressed(var14_19);
                    }
                } else {
                    pooled.close();
                }
            }
        }
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public void write(int b) throws IOException {
        byte[] data = new byte[]{(byte)(b & 0xFF)};
        this.write(data);
    }

    public void flush() throws IOException {
        this.getDelegateOutputStream().flush();
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.runHandshake();
        try (DefaultByteBufferPool.PooledByteBuffer uncompressedPooled = DefaultByteBufferPool.DIRECT_POOL.allocate();
             DefaultByteBufferPool.PooledByteBuffer compressedPooled = DefaultByteBufferPool.DIRECT_POOL.allocate();
             DefaultByteBufferPool.PooledByteBuffer indirectPooled = DefaultByteBufferPool.INDIRECT_POOL.allocate();){
            int written = 0;
            ByteBuffer buf = uncompressedPooled.getBuffer();
            buf.clear();
            int toWrite = len - written;
            buf.put(b, off + written, Math.min(toWrite, buf.remaining()));
            buf.flip();
            while (buf.hasRemaining()) {
                compressedPooled.getBuffer().clear();
                SSLEngineResult result = this.sslEngine.wrap(buf, compressedPooled.getBuffer());
                compressedPooled.getBuffer().flip();
                if (result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                    this.close();
                    throw new IOException("Buffer overflow");
                }
                if (result.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                    this.close();
                    throw new IOException("Buffer underflow");
                }
                int produced = result.bytesProduced();
                if (produced <= 0) continue;
                indirectPooled.getBuffer().clear();
                indirectPooled.getBuffer().put(compressedPooled.getBuffer());
                indirectPooled.getBuffer().flip();
                this.getDelegateOutputStream().write(indirectPooled.getBuffer().array(), indirectPooled.getBuffer().arrayOffset() + indirectPooled.getBuffer().position(), indirectPooled.getBuffer().remaining());
            }
        }
    }

    private OutputStream getDelegateOutputStream() throws IOException {
        if (this.delegate == this) {
            return super.getOutputStream();
        }
        return this.delegate.getOutputStream();
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        if (this.delegate == this) {
            super.connect(endpoint);
        } else {
            this.delegate.connect(endpoint);
        }
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        if (this.delegate == this) {
            super.connect(endpoint, timeout);
        } else {
            this.delegate.connect(endpoint, timeout);
        }
    }

    @Override
    public void bind(SocketAddress bindpoint) throws IOException {
        if (this.delegate == this) {
            super.bind(bindpoint);
        } else {
            this.delegate.bind(bindpoint);
        }
    }

    @Override
    public InetAddress getInetAddress() {
        if (this.delegate == this) {
            return super.getInetAddress();
        }
        return this.delegate.getInetAddress();
    }

    @Override
    public InetAddress getLocalAddress() {
        if (this.delegate == this) {
            return super.getLocalAddress();
        }
        return this.delegate.getLocalAddress();
    }

    @Override
    public int getPort() {
        if (this.delegate == this) {
            return super.getPort();
        }
        return this.delegate.getPort();
    }

    @Override
    public int getLocalPort() {
        if (this.delegate == this) {
            return super.getLocalPort();
        }
        return this.delegate.getLocalPort();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        if (this.delegate == this) {
            return super.getRemoteSocketAddress();
        }
        return this.delegate.getRemoteSocketAddress();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        if (this.delegate == this) {
            return super.getLocalSocketAddress();
        }
        return this.delegate.getLocalSocketAddress();
    }

    @Override
    public SocketChannel getChannel() {
        if (this.delegate == this) {
            return super.getChannel();
        }
        return this.delegate.getChannel();
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
        if (this.delegate == this) {
            super.setTcpNoDelay(on);
        } else {
            this.delegate.setTcpNoDelay(on);
        }
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        if (this.delegate == this) {
            return super.getTcpNoDelay();
        }
        return this.delegate.getTcpNoDelay();
    }

    @Override
    public void setSoLinger(boolean on, int linger) throws SocketException {
        if (this.delegate == this) {
            super.setSoLinger(on, linger);
        } else {
            this.delegate.setSoLinger(on, linger);
        }
    }

    @Override
    public int getSoLinger() throws SocketException {
        if (this.delegate == this) {
            return super.getSoLinger();
        }
        return this.delegate.getSoLinger();
    }

    @Override
    public void sendUrgentData(int data) throws IOException {
        if (this.delegate == this) {
            super.sendUrgentData(data);
        } else {
            this.delegate.sendUrgentData(data);
        }
    }

    @Override
    public void setOOBInline(boolean on) throws SocketException {
        if (this.delegate == this) {
            super.setOOBInline(on);
        } else {
            this.delegate.setOOBInline(on);
        }
    }

    @Override
    public boolean getOOBInline() throws SocketException {
        if (this.delegate == this) {
            return super.getOOBInline();
        }
        return this.delegate.getOOBInline();
    }

    @Override
    public synchronized void setSoTimeout(int timeout) throws SocketException {
        if (this.delegate == this) {
            super.setSoTimeout(timeout);
        } else {
            this.delegate.setSoTimeout(timeout);
        }
    }

    @Override
    public synchronized int getSoTimeout() throws SocketException {
        if (this.delegate == this) {
            return super.getSoTimeout();
        }
        return this.delegate.getSoTimeout();
    }

    @Override
    public synchronized void setSendBufferSize(int size) throws SocketException {
        if (this.delegate == this) {
            super.setSendBufferSize(size);
        } else {
            this.delegate.setSendBufferSize(size);
        }
    }

    @Override
    public synchronized int getSendBufferSize() throws SocketException {
        if (this.delegate == this) {
            return super.getSendBufferSize();
        }
        return this.delegate.getSendBufferSize();
    }

    @Override
    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        if (this.delegate == this) {
            super.setReceiveBufferSize(size);
        } else {
            this.delegate.setReceiveBufferSize(size);
        }
    }

    @Override
    public synchronized int getReceiveBufferSize() throws SocketException {
        if (this.delegate == this) {
            return super.getReceiveBufferSize();
        }
        return this.delegate.getReceiveBufferSize();
    }

    @Override
    public void setKeepAlive(boolean on) throws SocketException {
        if (this.delegate == this) {
            super.setKeepAlive(on);
        } else {
            this.delegate.setKeepAlive(on);
        }
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        if (this.delegate == this) {
            return super.getKeepAlive();
        }
        return this.delegate.getKeepAlive();
    }

    @Override
    public void setTrafficClass(int tc) throws SocketException {
        if (this.delegate == this) {
            super.setTrafficClass(tc);
        } else {
            this.delegate.setTrafficClass(tc);
        }
    }

    @Override
    public int getTrafficClass() throws SocketException {
        if (this.delegate == this) {
            return super.getTrafficClass();
        }
        return this.delegate.getTrafficClass();
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        if (this.delegate == this) {
            super.setReuseAddress(on);
        } else {
            this.delegate.setReuseAddress(on);
        }
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        if (this.delegate == this) {
            return super.getReuseAddress();
        }
        return this.delegate.getReuseAddress();
    }

    @Override
    public void shutdownInput() throws IOException {
        if (this.delegate == this) {
            super.shutdownInput();
        } else {
            this.delegate.shutdownInput();
        }
    }

    @Override
    public void shutdownOutput() throws IOException {
        if (this.delegate == this) {
            super.shutdownOutput();
        } else {
            this.delegate.shutdownOutput();
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " ]engine state: " + this.sslEngine + "]";
    }

    @Override
    public boolean isConnected() {
        if (this.delegate == this) {
            return super.isConnected();
        }
        return this.delegate.isConnected();
    }

    @Override
    public boolean isBound() {
        if (this.delegate == this) {
            return super.isBound();
        }
        return this.delegate.isBound();
    }

    @Override
    public boolean isClosed() {
        if (this.delegate == this) {
            return super.isClosed();
        }
        return this.delegate.isClosed();
    }

    @Override
    public boolean isInputShutdown() {
        if (this.delegate == this) {
            return super.isInputShutdown();
        }
        return this.delegate.isInputShutdown();
    }

    @Override
    public boolean isOutputShutdown() {
        if (this.delegate == this) {
            return super.isOutputShutdown();
        }
        return this.delegate.isOutputShutdown();
    }

    @Override
    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        if (this.delegate == this) {
            super.setPerformancePreferences(connectionTime, latency, bandwidth);
        } else {
            this.delegate.setPerformancePreferences(connectionTime, latency, bandwidth);
        }
    }

    public String getSelectedApplicationProtocol() {
        return this.sslEngine.getSelectedApplicationProtocol();
    }

    public String[] getApplicationProtocols() {
        return this.sslEngine.getApplicationProtocols();
    }

    public void setApplicationProtocols(String ... applicationProtocols) {
        this.sslEngine.setApplicationProtocols(applicationProtocols);
    }
}

