/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libsignal.protocol;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.whispersystems.libsignal.IdentityKey;
import org.whispersystems.libsignal.InvalidKeyException;
import org.whispersystems.libsignal.InvalidMessageException;
import org.whispersystems.libsignal.LegacyMessageException;
import org.whispersystems.libsignal.ecc.Curve;
import org.whispersystems.libsignal.ecc.ECPublicKey;
import org.whispersystems.libsignal.protocol.CiphertextMessage;
import org.whispersystems.libsignal.protocol.SignalProtos;
import org.whispersystems.libsignal.util.ByteUtil;

public class SignalMessage
implements CiphertextMessage {
    private static final int MAC_LENGTH = 8;
    private final int messageVersion;
    private final ECPublicKey senderRatchetKey;
    private final int counter;
    private final int previousCounter;
    private final byte[] ciphertext;
    private final byte[] serialized;

    public SignalMessage(byte[] serialized) throws InvalidMessageException, LegacyMessageException {
        try {
            byte[][] messageParts = ByteUtil.split(serialized, 1, serialized.length - 1 - 8, 8);
            byte version = messageParts[0][0];
            byte[] message = messageParts[1];
            byte[] mac = messageParts[2];
            if (ByteUtil.highBitsToInt(version) < 3) {
                throw new LegacyMessageException("Legacy message: " + ByteUtil.highBitsToInt(version));
            }
            if (ByteUtil.highBitsToInt(version) > 3) {
                throw new InvalidMessageException("Unknown version: " + ByteUtil.highBitsToInt(version));
            }
            SignalProtos.SignalMessage whisperMessage = SignalProtos.SignalMessage.parseFrom(message);
            if (!(whisperMessage.hasCiphertext() && whisperMessage.hasCounter() && whisperMessage.hasRatchetKey())) {
                throw new InvalidMessageException("Incomplete message.");
            }
            this.serialized = serialized;
            this.senderRatchetKey = Curve.decodePoint(whisperMessage.getRatchetKey().toByteArray(), 0);
            this.messageVersion = ByteUtil.highBitsToInt(version);
            this.counter = whisperMessage.getCounter();
            this.previousCounter = whisperMessage.getPreviousCounter();
            this.ciphertext = whisperMessage.getCiphertext().toByteArray();
        }
        catch (InvalidProtocolBufferException | ParseException | InvalidKeyException e) {
            throw new InvalidMessageException(e);
        }
    }

    public SignalMessage(int messageVersion, SecretKeySpec macKey, ECPublicKey senderRatchetKey, int counter, int previousCounter, byte[] ciphertext, IdentityKey senderIdentityKey, IdentityKey receiverIdentityKey) {
        byte[] version = new byte[]{ByteUtil.intsToByteHighAndLow(messageVersion, 3)};
        byte[] message = SignalProtos.SignalMessage.newBuilder().setRatchetKey(ByteString.copyFrom((byte[])senderRatchetKey.serialize())).setCounter(counter).setPreviousCounter(previousCounter).setCiphertext(ByteString.copyFrom((byte[])ciphertext)).build().toByteArray();
        byte[] mac = this.getMac(senderIdentityKey, receiverIdentityKey, macKey, ByteUtil.combine(version, message));
        this.serialized = ByteUtil.combine(version, message, mac);
        this.senderRatchetKey = senderRatchetKey;
        this.counter = counter;
        this.previousCounter = previousCounter;
        this.ciphertext = ciphertext;
        this.messageVersion = messageVersion;
    }

    public ECPublicKey getSenderRatchetKey() {
        return this.senderRatchetKey;
    }

    public int getMessageVersion() {
        return this.messageVersion;
    }

    public int getCounter() {
        return this.counter;
    }

    public byte[] getBody() {
        return this.ciphertext;
    }

    public void verifyMac(IdentityKey senderIdentityKey, IdentityKey receiverIdentityKey, SecretKeySpec macKey) throws InvalidMessageException {
        byte[] theirMac;
        byte[][] parts = ByteUtil.split(this.serialized, this.serialized.length - 8, 8);
        byte[] ourMac = this.getMac(senderIdentityKey, receiverIdentityKey, macKey, parts[0]);
        if (!MessageDigest.isEqual(ourMac, theirMac = parts[1])) {
            throw new InvalidMessageException("Bad Mac!");
        }
    }

    private byte[] getMac(IdentityKey senderIdentityKey, IdentityKey receiverIdentityKey, SecretKeySpec macKey, byte[] serialized) {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(macKey);
            mac.update(senderIdentityKey.getPublicKey().serialize());
            mac.update(receiverIdentityKey.getPublicKey().serialize());
            byte[] fullMac = mac.doFinal(serialized);
            return ByteUtil.trim(fullMac, 8);
        }
        catch (java.security.InvalidKeyException | NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public byte[] serialize() {
        return this.serialized;
    }

    @Override
    public int getType() {
        return 2;
    }

    public static boolean isLegacy(byte[] message) {
        return message != null && message.length >= 1 && ByteUtil.highBitsToInt(message[0]) != 3;
    }
}

