/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libsignal.kdf;

import java.text.ParseException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.whispersystems.libsignal.util.ByteUtil;

public class DerivedMessageSecrets {
    public static final int SIZE = 80;
    private static final int CIPHER_KEY_LENGTH = 32;
    private static final int MAC_KEY_LENGTH = 32;
    private static final int IV_LENGTH = 16;
    private final SecretKeySpec cipherKey;
    private final SecretKeySpec macKey;
    private final IvParameterSpec iv;

    public DerivedMessageSecrets(byte[] okm) {
        try {
            byte[][] keys = ByteUtil.split(okm, 32, 32, 16);
            this.cipherKey = new SecretKeySpec(keys[0], "AES");
            this.macKey = new SecretKeySpec(keys[1], "HmacSHA256");
            this.iv = new IvParameterSpec(keys[2]);
        }
        catch (ParseException e) {
            throw new AssertionError((Object)e);
        }
    }

    public SecretKeySpec getCipherKey() {
        return this.cipherKey;
    }

    public SecretKeySpec getMacKey() {
        return this.macKey;
    }

    public IvParameterSpec getIv() {
        return this.iv;
    }
}

