/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libsignal.groups.ratchet;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.whispersystems.libsignal.groups.ratchet.SenderMessageKey;

public class SenderChainKey {
    private static final byte[] MESSAGE_KEY_SEED = new byte[]{1};
    private static final byte[] CHAIN_KEY_SEED = new byte[]{2};
    private final int iteration;
    private final byte[] chainKey;

    public SenderChainKey(int iteration, byte[] chainKey) {
        this.iteration = iteration;
        this.chainKey = chainKey;
    }

    public int getIteration() {
        return this.iteration;
    }

    public SenderMessageKey getSenderMessageKey() {
        return new SenderMessageKey(this.iteration, this.getDerivative(MESSAGE_KEY_SEED, this.chainKey));
    }

    public SenderChainKey getNext() {
        return new SenderChainKey(this.iteration + 1, this.getDerivative(CHAIN_KEY_SEED, this.chainKey));
    }

    public byte[] getSeed() {
        return this.chainKey;
    }

    private byte[] getDerivative(byte[] seed, byte[] key) {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(key, "HmacSHA256"));
            return mac.doFinal(seed);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }
}

