/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.weex.plugin.loader.utils;

import com.taobao.weex.WXSDKManager;
import com.taobao.weex.adapter.IDrawableLoader;
import com.taobao.weex.adapter.IWXDebugAdapter;
import com.taobao.weex.adapter.IWXHttpAdapter;
import com.taobao.weex.adapter.IWXImgLoaderAdapter;
import com.taobao.weex.adapter.IWXJSExceptionAdapter;
import com.taobao.weex.adapter.IWXUserTrackAdapter;
import com.taobao.weex.adapter.URIAdapter;
import com.taobao.weex.appfram.storage.IWXStorageAdapter;
import com.taobao.weex.appfram.websocket.IWebSocketAdapterFactory;
import com.taobao.weex.bridge.WXModuleManager;
import com.taobao.weex.ui.WXComponentRegistry;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WeexSDKUtil {
    private static Map<String, String> adapters = new HashMap<String, String>(9);

    public static boolean containsModule(String name, boolean global) {
        if ("dom".equals(name)) {
            return true;
        }
        if (global) {
            try {
                Field sGlobalModuleMap = WXModuleManager.class.getDeclaredField("sGlobalModuleMap");
                sGlobalModuleMap.setAccessible(true);
                Object field = sGlobalModuleMap.get(null);
                if (field == null) {
                    return false;
                }
                if (field instanceof Map) {
                    Map globalModuleMap = (Map)field;
                    return globalModuleMap.containsKey(name);
                }
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        } else {
            try {
                Field sModuleFactoryMap = WXModuleManager.class.getDeclaredField("sModuleFactoryMap");
                sModuleFactoryMap.setAccessible(true);
                Object field = sModuleFactoryMap.get(null);
                if (field == null) {
                    return false;
                }
                if (field instanceof Map) {
                    Map moduleMap = (Map)field;
                    return moduleMap.containsKey(name);
                }
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static boolean containsComponent(List<String> names) {
        for (String name : names) {
            if (WXComponentRegistry.getComponent((String)name) == null) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAdapter(String adapterClassName) {
        WXSDKManager wxsdkManager = WXSDKManager.getInstance();
        String fieldName = adapters.get(adapterClassName);
        return WeexSDKUtil.isNull(wxsdkManager, fieldName);
    }

    public static boolean isValidAdapterType(String adapterClassName) {
        return adapters.containsKey(adapterClassName);
    }

    public static String getAdapterField(String adapterClassName) {
        return adapters.get(adapterClassName);
    }

    public static boolean isNull(Object object, String fieldName) {
        if (fieldName == null) {
            return false;
        }
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            Object value = field.get(object);
            return value == null;
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean containsDomObject(String name) {
        return false;
    }

    static {
        adapters.put(WeexAdapters.HTTP_ADAPTER, "mIWXHttpAdapter");
        adapters.put(WeexAdapters.DRAWABLE_LOADER, "mDrawableLoader");
        adapters.put(WeexAdapters.IMG_LOADER_ADAPTER, "mIWXImgLoaderAdapter");
        adapters.put(WeexAdapters.USER_TRACK_ADAPTER, "mIWXUserTrackAdapter");
        adapters.put(WeexAdapters.DEBUG_ADAPTER, "mIWXDebugAdapter");
        adapters.put(WeexAdapters.STORAGE_ADAPTER, "mIWXStorageAdapter");
        adapters.put(WeexAdapters.URI_ADAPTER, "mURIAdapter");
        adapters.put(WeexAdapters.WEBSOCKET_ADAPTER_FACTORY, "mIWebSocketAdapterFactory");
        adapters.put(WeexAdapters.JS_EXCEPTION_ADAPTER, "mIWXJSExceptionAdapter");
    }

    static interface WeexAdapters {
        public static final String HTTP_ADAPTER = IWXHttpAdapter.class.getCanonicalName();
        public static final String DRAWABLE_LOADER = IDrawableLoader.class.getCanonicalName();
        public static final String IMG_LOADER_ADAPTER = IWXImgLoaderAdapter.class.getCanonicalName();
        public static final String USER_TRACK_ADAPTER = IWXUserTrackAdapter.class.getCanonicalName();
        public static final String DEBUG_ADAPTER = IWXDebugAdapter.class.getCanonicalName();
        public static final String STORAGE_ADAPTER = IWXStorageAdapter.class.getCanonicalName();
        public static final String URI_ADAPTER = URIAdapter.class.getCanonicalName();
        public static final String WEBSOCKET_ADAPTER_FACTORY = IWebSocketAdapterFactory.class.getCanonicalName();
        public static final String JS_EXCEPTION_ADAPTER = IWXJSExceptionAdapter.class.getCanonicalName();
    }
}

