/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.weex.plugin.loader;

import android.content.Context;
import android.content.res.AssetManager;
import android.text.TextUtils;
import android.util.Log;
import com.alibaba.weex.plugin.loader.utils.WeexSDKUtil;
import com.taobao.weex.WXSDKEngine;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.common.WXException;
import com.taobao.weex.common.WXModule;
import com.taobao.weex.dom.WXDomObject;
import com.taobao.weex.ui.ComponentCreator;
import com.taobao.weex.ui.IFComponentHolder;
import com.taobao.weex.ui.SimpleComponentHolder;
import com.taobao.weex.ui.component.WXComponent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WeexPluginContainer {
    public static final String TAG = "WeexPluginContainer";
    private static final ClassLoader DEFAULT_CLASS_LOADER = WeexPluginContainer.class.getClassLoader();

    public static void loadAll(Context context, ClassLoader classLoader) {
        try {
            WeexPluginContainer.loadAdapters(context, classLoader);
            WeexPluginContainer.loadDomObjects(context, classLoader);
            WeexPluginContainer.loadComponents(context, classLoader);
            WeexPluginContainer.loadModules(context, classLoader);
        }
        catch (Throwable throwable) {
            Log.w((String)TAG, (String)"Unexpected throwable in loadAll", (Throwable)throwable);
        }
    }

    public static void loadAll(Context context) {
        WeexPluginContainer.loadAll(context, null);
    }

    public static void loadModules(Context context) {
        WeexPluginContainer.loadModules(context, null);
    }

    public static void loadModules(Context context, ClassLoader classLoader) {
        try {
            for (JSONObject spec : WeexPluginContainer.getPluginSpecs(context, "weex_plugin/module")) {
                String moduleName = spec.optString("name", null);
                String clazz = spec.optString("class", null);
                boolean canOverride = spec.optBoolean("canOverrideExisting", true);
                boolean globalRegistration = spec.optBoolean("globalRegistration", false);
                boolean lazyLoad = spec.optBoolean("lazyLoad", false);
                JSONArray functions = null;
                if (lazyLoad) {
                    functions = spec.optJSONArray("functions");
                }
                if (moduleName == null || clazz == null) {
                    Log.w((String)TAG, (String)"Module name or module class is null");
                    continue;
                }
                if (!canOverride && WeexSDKUtil.containsModule(moduleName, globalRegistration)) {
                    Log.w((String)TAG, (String)("Ignore duplicated module: " + moduleName));
                    continue;
                }
                try {
                    Class<?> moduleClass = WeexPluginContainer.loadClass(clazz, classLoader);
                    if (moduleClass == null) continue;
                    if (!WXModule.class.isAssignableFrom(moduleClass)) {
                        Log.e((String)TAG, (String)("Class " + clazz + " is not a subclass of WXModule"));
                        continue;
                    }
                    WXSDKEngine.registerModule((String)moduleName, moduleClass, (boolean)globalRegistration);
                    Log.d((String)TAG, (String)("Module plugin [" + moduleName + "][clazz:" + moduleClass + "][globalRegistration:" + globalRegistration + "][lazyLoad:" + lazyLoad + "][canOverride:" + canOverride + "]"));
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (WXException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Throwable throwable) {
            Log.w((String)TAG, (String)"Unexpected throwable in loadModules", (Throwable)throwable);
        }
    }

    public static void loadComponents(Context context) {
        WeexPluginContainer.loadModules(context, null);
    }

    public static void loadComponents(Context context, ClassLoader classLoader) {
        try {
            for (JSONObject spec : WeexPluginContainer.getPluginSpecs(context, "weex_plugin/component")) {
                ArrayList<String> names = new ArrayList<String>();
                JSONArray namesTemp = spec.optJSONArray("names");
                for (int i = 0; i < namesTemp.length(); ++i) {
                    String name = namesTemp.optString(i);
                    if (TextUtils.isEmpty((CharSequence)name)) continue;
                    names.add(name);
                }
                String[] namesArray = names.toArray(new String[names.size()]);
                String clazz = spec.optString("class");
                boolean appendTree = spec.optBoolean("appendTree", false);
                boolean usingHolder = spec.optBoolean("usingHolder", false);
                boolean canOverride = spec.optBoolean("canOverrideExisting", true);
                String creator = null;
                if (usingHolder) {
                    creator = spec.optString("creator", null);
                }
                if (names.size() == 0 || TextUtils.isEmpty((CharSequence)clazz)) {
                    Log.w((String)TAG, (String)"Component names or component class is null");
                    continue;
                }
                if (!canOverride && WeexSDKUtil.containsComponent(names)) {
                    Log.w((String)TAG, (String)("Ignore duplicated component: " + ((Object)names).toString()));
                    continue;
                }
                try {
                    Class<?> componentClass = WeexPluginContainer.loadClass(clazz, classLoader);
                    if (componentClass == null) continue;
                    if (!WXComponent.class.isAssignableFrom(componentClass)) {
                        Log.e((String)TAG, (String)("Class " + clazz + " is not a subclass of WXComponent"));
                        continue;
                    }
                    if (usingHolder) {
                        if (creator == null || !"NULL".equals(creator)) {
                            WXSDKEngine.registerComponent((IFComponentHolder)new SimpleComponentHolder(componentClass), (boolean)appendTree, (String[])namesArray);
                        } else {
                            Class<?> creatorClass = WeexPluginContainer.loadClass(creator, classLoader);
                            if (creatorClass == null) {
                                WXSDKEngine.registerComponent((IFComponentHolder)new SimpleComponentHolder(componentClass), (boolean)appendTree, (String[])namesArray);
                            } else {
                                ComponentCreator componentCreator = (ComponentCreator)creatorClass.newInstance();
                                WXSDKEngine.registerComponent((IFComponentHolder)new SimpleComponentHolder(componentClass, componentCreator), (boolean)appendTree, (String[])namesArray);
                            }
                        }
                    } else {
                        WXSDKEngine.registerComponent(componentClass, (boolean)appendTree, (String[])namesArray);
                    }
                    Log.d((String)TAG, (String)("Component plugin [" + names + "][clazz:" + componentClass + "][appendTree:" + appendTree + "][usingHolder:" + usingHolder + "][canOverride:" + canOverride + "][" + creator + "]"));
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (WXException e) {
                    e.printStackTrace();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Throwable throwable) {
            Log.w((String)TAG, (String)"Unexpected throwable in loadComponents", (Throwable)throwable);
        }
    }

    public static void loadAdapters(Context context) {
        WeexPluginContainer.loadAdapters(context, null);
    }

    public static void loadAdapters(Context context, ClassLoader classLoader) {
        try {
            for (JSONObject spec : WeexPluginContainer.getPluginSpecs(context, "weex_plugin/adapter")) {
                String type = spec.optString("type");
                String clazz = spec.optString("class");
                boolean canOverride = spec.optBoolean("canOverrideExisting", true);
                if (!WeexSDKUtil.isValidAdapterType(type)) {
                    Log.e((String)TAG, (String)("Invalid adapter type: " + type));
                    continue;
                }
                if (!canOverride && WeexSDKUtil.containsAdapter(type)) {
                    Log.w((String)TAG, (String)("Ignore duplicated adapter: " + clazz));
                    continue;
                }
                try {
                    Class<?> adapterClass = WeexPluginContainer.loadClass(clazz, classLoader);
                    if (adapterClass == null) continue;
                    try {
                        Object adapter = adapterClass.newInstance();
                        String fieldName = WeexSDKUtil.getAdapterField(type);
                        Field field = WXSDKManager.class.getDeclaredField(fieldName);
                        field.setAccessible(true);
                        field.set(WXSDKManager.getInstance(), adapter);
                        Log.d((String)TAG, (String)("Adapter plugin " + clazz + " registered."));
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (NoSuchFieldException e) {
                        e.printStackTrace();
                    }
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Throwable throwable) {
            Log.w((String)TAG, (String)"Unexpected throwable in loadAdapters", (Throwable)throwable);
        }
    }

    public static void loadDomObjects(Context context) {
        WeexPluginContainer.loadDomObjects(context, null);
    }

    public static void loadDomObjects(Context context, ClassLoader classLoader) {
        try {
            for (JSONObject spec : WeexPluginContainer.getPluginSpecs(context, "weex_plugin/domObject")) {
                String clazz = spec.optString("class");
                String type = spec.optString("type");
                boolean canOverride = spec.optBoolean("canOverrideExisting", false);
                if (TextUtils.isEmpty((CharSequence)clazz)) continue;
                try {
                    Class<?> domClass = WeexPluginContainer.loadClass(clazz, classLoader);
                    if (domClass == null) continue;
                    if (!WXDomObject.class.isAssignableFrom(domClass)) {
                        Log.e((String)TAG, (String)("Class " + clazz + " is not a subclass of WXDomObject"));
                        continue;
                    }
                    if (!WXDomObject.class.isAssignableFrom(domClass)) continue;
                    WXSDKEngine.registerDomObject((String)type, domClass);
                    Log.d((String)TAG, (String)("Dom object plugin " + type + " registered."));
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (WXException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Throwable throwable) {
            Log.w((String)TAG, (String)"Unexpected throwable in loadDomObjects", (Throwable)throwable);
        }
    }

    private static Class<?> loadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        if (classLoader == null) {
            classLoader = DEFAULT_CLASS_LOADER;
        }
        return classLoader.loadClass(className);
    }

    private static List<JSONObject> getPluginSpecs(Context context, String pathOnAssets) {
        AssetManager assetManager = context.getAssets();
        ArrayList<JSONObject> specs = new ArrayList<JSONObject>();
        try {
            String[] files = assetManager.list(pathOnAssets);
            if (files != null && files.length > 0) {
                for (String fileName : files) {
                    String line;
                    if (!fileName.endsWith(".json")) continue;
                    Log.d((String)TAG, (String)("Parse plugin meta info >>> " + fileName));
                    InputStream inputStream = assetManager.open(pathOnAssets + "/" + fileName);
                    BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                    StringBuffer stringBuffer = new StringBuffer();
                    while ((line = reader.readLine()) != null) {
                        stringBuffer.append(line);
                    }
                    JSONArray spec = new JSONArray(stringBuffer.toString());
                    for (int i = 0; i < spec.length(); ++i) {
                        JSONObject element = spec.optJSONObject(i);
                        if (element == null) continue;
                        specs.add(element);
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return specs;
    }
}

