/*
 * Decompiled with CFR 0.152.
 */
package org.weex.plugin.device;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.os.Vibrator;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Result;
import com.google.zxing.client.result.ParsedResult;
import com.mylhyl.zxing.scanner.OnScannerCompletionListener;
import com.mylhyl.zxing.scanner.ScannerOptions;
import com.mylhyl.zxing.scanner.ScannerView;
import com.mylhyl.zxing.scanner.camera.open.CameraFacing;
import com.squareup.picasso.Picasso;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.common.WXModule;
import com.uuzuche.lib_zxing.activity.CodeUtils;
import com.uuzuche.lib_zxing.activity.ZXingLibrary;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.weex.plugin.device.DeviceModule;
import org.weex.plugin.device.ImageUtil;
import org.weex.plugin.device.LoadingDialog;
import org.weex.plugin.device.R;
import org.weex.plugin.device.scanner.ScannerButton;

public class CaptureMyActivity
extends AppCompatActivity {
    public static final int REQUEST_IMAGE = 112;
    private ScannerView mScannerView;
    private Result mLastResult;
    private ImageView picture_left_back;
    private TextView picture_title;
    private TextView picture_right;
    private LinearLayout linear1;
    private ImageView im_button1;
    private TextView tv_content1;
    private LinearLayout linear2;
    private ImageView im_button2;
    private TextView tv_content2;
    private LinearLayout linear3;
    private ImageView im_button3;
    private TextView tv_content3;
    private LinearLayout linear4;
    private ImageView im_button4;
    private TextView tv_content4;
    private LinearLayout linear5;
    private ImageView im_button5;
    private TextView tv_content5;
    private ImageView im_flash_light;
    public LoadingDialog mProgressDialog;
    private ScannerOptions.LaserStyle laserStyle = ScannerOptions.LaserStyle.COLOR_LINE;
    private int laserLineColor;
    private int laserLineResId;
    private int laserLineHeight = 2;
    private int laserLineMoveSpeed = 6;
    private boolean laserMoveFullScreen = false;
    private int frameWidth = 220;
    private int frameHeight = 220;
    private int frameCornerColor;
    private int frameCornerLength = 15;
    private int frameCornerWidth = 2;
    private boolean frameCornerInside = true;
    private boolean frameCornerHide = false;
    private int frameTopMargin = 110;
    private boolean frameHide = false;
    private boolean viewfinderHide;
    private String tipText = "\u5c06\u4e8c\u7ef4\u7801/\u6761\u5f62\u7801\u653e\u5165\u6846\u5185\uff0c\u5373\u53ef\u81ea\u52a8\u626b\u63cf";
    private int tipTextColor;
    private int tipTextSize = 14;
    private boolean tipTextToFrameTop = false;
    private int tipTextToFrameMargin = 20;
    private int mediaResId;
    private Collection<BarcodeFormat> decodeFormats;
    private boolean createQrThumbnail;
    private boolean showQrThumbnail;
    private CameraFacing cameraFacing = CameraFacing.BACK;
    private boolean scanFullScreen = true;
    private boolean scanInvert = false;
    private double cameraZoomRatio = 2.0;
    private ScannerOptions.ViewfinderCallback viewfinderCallback;
    private int frameOutsideColor = 0x60000000;
    public static boolean isOpen = false;
    private List<ScannerButton> buttons = new ArrayList<ScannerButton>();
    private WXSDKInstance mInstance;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ZXingLibrary.initDisplayOpinion((Context)this);
        this.setContentView(R.layout.activity_capture_my);
        this.initView();
        this.init();
        this.mInstance = new WXSDKInstance((Context)this);
    }

    private void initView() {
        this.laserLineColor = this.getResources().getColor(R.color.scan_corner_color);
        this.frameCornerColor = this.getResources().getColor(R.color.scan_corner_color);
        this.tipTextColor = this.getResources().getColor(R.color.color_53);
        this.frameWidth = this.getIntent().getIntExtra("frameWidth", 220);
        this.frameHeight = this.getIntent().getIntExtra("frameHeight", 220);
        this.frameCornerColor = this.getIntent().getIntExtra("frameCornerColor", this.frameCornerColor);
        this.tipTextColor = this.getIntent().getIntExtra("tipTextColor", this.tipTextColor);
        this.frameHide = this.getIntent().getBooleanExtra("frameHide", false);
        this.laserMoveFullScreen = this.getIntent().getBooleanExtra("laserMoveFullScreen", false);
        this.tipText = this.getIntent().getStringExtra("tipText");
        this.buttons = (List)((Object)this.getIntent().getSerializableExtra("buttons"));
        this.mScannerView = (ScannerView)this.findViewById(R.id.scanner_view);
        this.picture_left_back = (ImageView)this.findViewById(R.id.picture_left_back);
        this.im_flash_light = (ImageView)this.findViewById(R.id.im_flash_light);
        this.picture_title = (TextView)this.findViewById(R.id.picture_title);
        this.picture_right = (TextView)this.findViewById(R.id.picture_right);
        for (int i = 0; i < this.buttons.size(); ++i) {
            TextView tv_content;
            ImageView im_button;
            LinearLayout linear;
            switch (i) {
                case 0: {
                    linear = (LinearLayout)this.findViewById(R.id.linear1);
                    im_button = (ImageView)this.findViewById(R.id.im_button1);
                    tv_content = (TextView)this.findViewById(R.id.tv_content1);
                    break;
                }
                case 1: {
                    linear = (LinearLayout)this.findViewById(R.id.linear2);
                    im_button = (ImageView)this.findViewById(R.id.im_button2);
                    tv_content = (TextView)this.findViewById(R.id.tv_content2);
                    break;
                }
                case 2: {
                    linear = (LinearLayout)this.findViewById(R.id.linear3);
                    im_button = (ImageView)this.findViewById(R.id.im_button3);
                    tv_content = (TextView)this.findViewById(R.id.tv_content3);
                    break;
                }
                case 3: {
                    linear = (LinearLayout)this.findViewById(R.id.linear4);
                    im_button = (ImageView)this.findViewById(R.id.im_button4);
                    tv_content = (TextView)this.findViewById(R.id.tv_content4);
                    break;
                }
                case 4: {
                    linear = (LinearLayout)this.findViewById(R.id.linear5);
                    im_button = (ImageView)this.findViewById(R.id.im_button5);
                    tv_content = (TextView)this.findViewById(R.id.tv_content5);
                    break;
                }
                default: {
                    linear = (LinearLayout)this.findViewById(R.id.linear1);
                    im_button = (ImageView)this.findViewById(R.id.im_button1);
                    tv_content = (TextView)this.findViewById(R.id.tv_content1);
                }
            }
            ScannerButton button = this.buttons.get(i);
            if (!"".equals(button.getText())) {
                linear.setVisibility(0);
                tv_content.setText((CharSequence)button.getText());
                Uri uri = Uri.parse((String)button.getIcon());
                Picasso.with((Context)this).load(uri).into(im_button);
            } else {
                linear.setVisibility(8);
            }
            linear.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    HashMap<String, Integer> map = new HashMap<String, Integer>();
                    map.put("name", 1);
                    CaptureMyActivity.this.mInstance.fireModuleEvent("button", (WXModule)new DeviceModule(), map);
                }
            });
        }
        this.picture_left_back.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CaptureMyActivity.this.finish();
            }
        });
        this.picture_right.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent intent = new Intent();
                intent.setAction("android.intent.action.PICK");
                intent.setType("image/*");
                CaptureMyActivity.this.startActivityForResult(intent, 112);
            }
        });
        this.im_flash_light.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!isOpen) {
                    CaptureMyActivity.this.mScannerView.toggleLight(true);
                    CaptureMyActivity.this.im_flash_light.setImageResource(R.mipmap.flashlight_on);
                    isOpen = true;
                } else {
                    CaptureMyActivity.this.mScannerView.toggleLight(false);
                    CaptureMyActivity.this.im_flash_light.setImageResource(R.mipmap.flashlight_off);
                    isOpen = false;
                }
            }
        });
    }

    private void showInputMethod() {
        InputMethodManager inputManager = (InputMethodManager)this.getApplication().getSystemService("input_method");
        inputManager.toggleSoftInput(0, 2);
    }

    private void init() {
        this.mScannerView.setOnScannerCompletionListener(new OnScannerCompletionListener(){

            public void onScannerCompletion(Result rawResult, ParsedResult parsedResult, Bitmap barcode) {
                Toast.makeText((Context)CaptureMyActivity.this, (CharSequence)rawResult.getText(), (int)0).show();
                CaptureMyActivity.this.vibrate();
                CaptureMyActivity.this.mScannerView.restartPreviewAfterDelay(0L);
                CaptureMyActivity.this.finish();
            }
        });
        ScannerOptions.Builder builder = new ScannerOptions.Builder();
        builder.setFrameSize(this.frameWidth, this.frameHeight).setLaserStyle(ScannerOptions.LaserStyle.RES_LINE, R.drawable.scan_image).setLaserMoveSpeed(this.laserLineMoveSpeed).setScanFullScreen(this.scanFullScreen).setFrameHide(this.frameHide).setLaserMoveFullScreen(this.laserMoveFullScreen).setFrameCornerColor(this.frameCornerColor).setFrameCornerLength(this.frameCornerLength).setFrameCornerWidth(this.frameCornerWidth).setFrameCornerInside(this.frameCornerInside).setFrameCornerHide(this.frameCornerHide).setFrameTopMargin(this.frameTopMargin).setViewfinderHide(false).setTipText(this.tipText).setTipTextColor(this.tipTextColor).setFrameOutsideColor(0x60000000).setTipTextSize(this.tipTextSize).setTipTextToFrameMargin(this.tipTextToFrameMargin).setTipTextToFrameTop(this.tipTextToFrameTop).setCameraFacing(this.cameraFacing).setScanInvert(this.scanInvert).setCameraZoomRatio(this.cameraZoomRatio);
        this.mScannerView.setScannerOptions(builder.build());
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 112 && data != null) {
            this.showProgressDialog("\u8bc6\u522b\u4e2d...");
            Uri uri = data.getData();
            try {
                CodeUtils.analyzeBitmap((String)ImageUtil.getImageAbsolutePath((Context)this, uri), (CodeUtils.AnalyzeCallback)new CodeUtils.AnalyzeCallback(){

                    public void onAnalyzeSuccess(Bitmap mBitmap, final String result) {
                        CaptureMyActivity.this.tv_content5.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                Toast.makeText((Context)CaptureMyActivity.this, (CharSequence)("\u89e3\u6790\u7ed3\u679c:" + result), (int)1).show();
                                CaptureMyActivity.this.vibrate();
                                CaptureMyActivity.this.dismissProgressDialog();
                                CaptureMyActivity.this.finish();
                            }
                        }, 2000L);
                    }

                    public void onAnalyzeFailed() {
                        CaptureMyActivity.this.tv_content5.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                Toast.makeText((Context)CaptureMyActivity.this, (CharSequence)"\u89e3\u6790\u4e8c\u7ef4\u7801\u5931\u8d25", (int)1).show();
                                CaptureMyActivity.this.dismissProgressDialog();
                            }
                        }, 2000L);
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void onResume() {
        this.mScannerView.onResume();
        this.resetStatusView();
        super.onResume();
    }

    protected void onPause() {
        this.mScannerView.onPause();
        super.onPause();
    }

    private void resetStatusView() {
        this.mLastResult = null;
    }

    private void vibrate() {
        Vibrator vibrator = (Vibrator)this.getSystemService("vibrator");
    }

    public void showProgressDialog(String content) {
        if (this.isProgressDialogShowing()) {
            return;
        }
        if (this.mProgressDialog == null) {
            this.mProgressDialog = new LoadingDialog((Context)this);
        }
        this.mProgressDialog.setContent(content);
        this.mProgressDialog.show();
    }

    public void dismissProgressDialog() {
        if (this.isProgressDialogShowing()) {
            this.mProgressDialog.dismiss();
            this.mProgressDialog = null;
        }
    }

    public boolean isProgressDialogShowing() {
        return null != this.mProgressDialog && this.mProgressDialog.isShowing();
    }

    public static enum LaserStyle {
        COLOR_LINE,
        RES_LINE,
        RES_GRID;

    }
}

