/*
 * Decompiled with CFR 0.152.
 */
package org.weex.plugin.weexactionsheet;

import android.support.v4.app.FragmentActivity;
import com.alibaba.weex.plugin.annotation.WeexModule;
import com.taobao.weex.WXSDKEngine;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.bridge.JSCallback;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.weex.plugin.weexactionsheet.WXActionSheet;

@WeexModule(name="actionSheet", lazyLoad=true)
public class WXActionSheetModule
extends WXSDKEngine.DestroyableModule {
    private WXActionSheet actionSheet;

    @JSMethod
    public void create(Map<String, Object> options, final JSCallback callback) {
        Object title = options.get("title");
        Object message = options.get("message");
        Object items = options.get("items");
        if (this.mWXSDKInstance.getContext() instanceof FragmentActivity) {
            WXActionSheet.Builder builder = WXActionSheet.createBuilder((FragmentActivity)this.mWXSDKInstance.getContext());
            if (title != null) {
                builder.setTitle(String.valueOf(title));
            }
            if (message != null) {
                builder.setMessage(String.valueOf(message));
            }
            if (items != null && items instanceof List) {
                builder.setItems((List)items);
            }
            builder.setListener(new WXActionSheet.ActionListener(){

                @Override
                public void onSelected(int index, String content) {
                    HashMap<String, Object> event = new HashMap<String, Object>(2);
                    event.put("index", index);
                    event.put("message", content);
                    HashMap<String, Object> ret = new HashMap<String, Object>(2);
                    ret.put("result", "success");
                    ret.put("data", event);
                    callback.invoke(ret);
                }

                @Override
                public void onCancel() {
                    HashMap<String, String> ret = new HashMap<String, String>(2);
                    ret.put("result", "cancel");
                    ret.put("data", null);
                    callback.invoke(ret);
                }

                @Override
                public void onError(String message) {
                    HashMap<String, String> ret = new HashMap<String, String>(2);
                    ret.put("result", "error");
                    ret.put("data", message);
                    callback.invoke(ret);
                }
            });
            this.actionSheet = builder.buildAndShow();
        }
    }

    public void destroy() {
        this.actionSheet.dismiss();
    }
}

