/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERSequenceGenerator;
import org.bouncycastle.asn1.DLSequence;
import org.web3j.crypto.ECDSASignature;

public class CryptoUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] toDerFormat(ECDSASignature signature) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            DERSequenceGenerator seq = new DERSequenceGenerator((OutputStream)baos);
            seq.addObject((ASN1Primitive)new ASN1Integer(signature.r));
            seq.addObject((ASN1Primitive)new ASN1Integer(signature.s));
            seq.close();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException ex) {
            return new byte[0];
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ECDSASignature fromDerFormat(byte[] bytes) {
        try (ASN1InputStream decoder = new ASN1InputStream(bytes);){
            ASN1Integer s;
            ASN1Integer r;
            DLSequence seq = (DLSequence)decoder.readObject();
            if (seq == null) {
                throw new RuntimeException("Reached past end of ASN.1 stream.");
            }
            try {
                r = (ASN1Integer)seq.getObjectAt(0);
                s = (ASN1Integer)seq.getObjectAt(1);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(e);
            }
            ECDSASignature eCDSASignature = new ECDSASignature(r.getPositiveValue(), s.getPositiveValue());
            return eCDSASignature;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

