/*
 * Decompiled with CFR 0.152.
 */
package org.linkeddatafragments.util;

import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResourceFactory;
import org.linkeddatafragments.util.CommonResources;
import org.linkeddatafragments.util.TriplePatternElementParser;

public class TriplePatternElementParserForJena
extends TriplePatternElementParser<RDFNode, String, String> {
    private static TriplePatternElementParserForJena instance = null;

    public static TriplePatternElementParserForJena getInstance() {
        if (instance == null) {
            instance = new TriplePatternElementParserForJena();
        }
        return instance;
    }

    protected TriplePatternElementParserForJena() {
    }

    @Override
    public String createNamedVariable(String varName) {
        return varName;
    }

    @Override
    public String createAnonymousVariable(String label) {
        return label;
    }

    @Override
    public RDFNode createBlankNode(String label) {
        return ResourceFactory.createResource();
    }

    @Override
    public RDFNode createURI(String uri) {
        return ResourceFactory.createResource((String)uri);
    }

    @Override
    public RDFNode createTypedLiteral(String label, String typeURI) {
        RDFDatatype dt = TypeMapper.getInstance().getSafeTypeByName(typeURI);
        return ResourceFactory.createTypedLiteral((String)label, (RDFDatatype)dt);
    }

    @Override
    public RDFNode createLanguageLiteral(String label, String languageTag) {
        return ResourceFactory.createLangLiteral((String)label, (String)languageTag);
    }

    @Override
    public RDFNode createPlainLiteral(String label) {
        return ResourceFactory.createPlainLiteral((String)label);
    }

    @Override
    public RDFNode handleUnparsableParameter(String parameter) {
        return CommonResources.INVALID_URI;
    }
}

