/*
 * Decompiled with CFR 0.152.
 */
package org.linkeddatafragments.datasource.tdb;

import java.io.File;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.tdb.TDBFactory;
import org.linkeddatafragments.datasource.AbstractRequestProcessorForTriplePatterns;
import org.linkeddatafragments.fragments.ILinkedDataFragment;
import org.linkeddatafragments.fragments.tpf.ITriplePatternElement;
import org.linkeddatafragments.fragments.tpf.ITriplePatternFragmentRequest;

public class JenaTDBBasedRequestProcessorForTPFs
extends AbstractRequestProcessorForTriplePatterns<RDFNode, String, String> {
    private final Dataset tdb;
    private final String sparql = "CONSTRUCT WHERE { ?s ?p ?o } ORDER BY ?s ?p ?o";
    private final String count = "SELECT (COUNT(?s) AS ?count) WHERE { ?s ?p ?o }";
    private final Query query = QueryFactory.create((String)"CONSTRUCT WHERE { ?s ?p ?o } ORDER BY ?s ?p ?o", (Syntax)Syntax.syntaxSPARQL_11);
    private final Query countQuery = QueryFactory.create((String)"SELECT (COUNT(?s) AS ?count) WHERE { ?s ?p ?o }", (Syntax)Syntax.syntaxSPARQL_11);

    protected Worker getTPFSpecificWorker(ITriplePatternFragmentRequest<RDFNode, String, String> request) throws IllegalArgumentException {
        return new Worker(request);
    }

    public JenaTDBBasedRequestProcessorForTPFs(File tdbdir) {
        this.tdb = TDBFactory.createDataset((String)tdbdir.getAbsolutePath());
    }

    protected class Worker
    extends AbstractRequestProcessorForTriplePatterns.Worker<RDFNode, String, String> {
        public Worker(ITriplePatternFragmentRequest<RDFNode, String, String> req) {
            super(req);
        }

        @Override
        protected ILinkedDataFragment createFragment(ITriplePatternElement<RDFNode, String, String> subject, ITriplePatternElement<RDFNode, String, String> predicate, ITriplePatternElement<RDFNode, String, String> object, long offset, long limit) {
            Model model = JenaTDBBasedRequestProcessorForTPFs.this.tdb.getDefaultModel();
            QuerySolutionMap map = new QuerySolutionMap();
            if (!subject.isVariable()) {
                map.add("s", subject.asConstantTerm());
            }
            if (!predicate.isVariable()) {
                map.add("p", predicate.asConstantTerm());
            }
            if (!object.isVariable()) {
                map.add("o", object.asConstantTerm());
            }
            JenaTDBBasedRequestProcessorForTPFs.this.query.setOffset(offset);
            JenaTDBBasedRequestProcessorForTPFs.this.query.setLimit(limit);
            Model triples = ModelFactory.createDefaultModel();
            try (QueryExecution qexec = QueryExecutionFactory.create((Query)JenaTDBBasedRequestProcessorForTPFs.this.query, (Model)model, (QuerySolution)map);){
                qexec.execConstruct(triples);
            }
            if (triples.isEmpty()) {
                return this.createEmptyTriplePatternFragment();
            }
            long size = triples.size();
            long estimate = -1L;
            try (QueryExecution qexec = QueryExecutionFactory.create((Query)JenaTDBBasedRequestProcessorForTPFs.this.countQuery, (Model)model, (QuerySolution)map);){
                ResultSet results = qexec.execSelect();
                if (results.hasNext()) {
                    QuerySolution soln = results.nextSolution();
                    Literal literal = soln.getLiteral("count");
                    estimate = literal.getLong();
                }
            }
            if (estimate < offset + size) {
                estimate = size == limit ? offset + size + 1L : offset + size;
            }
            boolean isLastPage = estimate < offset + limit;
            return this.createTriplePatternFragment(triples, estimate, isLastPage);
        }
    }
}

