/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual;

import edu.cornell.mannlib.vitro.webapp.auth.policy.PolicyHelper;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.AuthorizationRequest;
import edu.cornell.mannlib.vitro.webapp.auth.requestedAction.propstmt.EditDataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatementImpl;
import edu.cornell.mannlib.vitro.webapp.beans.IndividualImpl;
import edu.cornell.mannlib.vitro.webapp.beans.Property;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.controller.freemarker.UrlBuilder;
import edu.cornell.mannlib.vitro.webapp.dao.IndividualDao;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.edit.EditLiteral;
import edu.cornell.mannlib.vitro.webapp.edit.n3editing.VTwo.RdfLiteralHash;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.PropertyStatementTemplateModel;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.rdf.model.Literal;

public class NameStatementTemplateModel
extends PropertyStatementTemplateModel {
    private static final Log log = LogFactory.getLog(NameStatementTemplateModel.class);
    private final String stringValue;
    private final String editUrl;

    NameStatementTemplateModel(String subjectUri, VitroRequest vreq) {
        super(subjectUri, new Property("http://www.w3.org/2000/01/rdf-schema#label"), vreq);
        WebappDaoFactory wdf = vreq.getWebappDaoFactory();
        IndividualDao iDao = wdf.getIndividualDao();
        EditLiteral literal = iDao.getLabelEditLiteral(subjectUri);
        if (literal == null) {
            IndividualImpl uri = new IndividualImpl(subjectUri);
            this.stringValue = uri.getLocalName();
            this.editUrl = "";
        } else {
            this.stringValue = this.cleanTextForDisplay(literal.getLexicalForm());
            this.editUrl = this.makeEditUrl(literal);
        }
    }

    private String makeEditUrl(Literal literal) {
        DataPropertyStatement dps = this.makeStatement(literal);
        EditDataPropertyStatement action = new EditDataPropertyStatement(this.vreq.getJenaOntModel(), dps);
        if (!PolicyHelper.isAuthorizedForActions((HttpServletRequest)this.vreq, new AuthorizationRequest[]{action})) {
            return "";
        }
        UrlBuilder.ParamMap params = new UrlBuilder.ParamMap("subjectUri", this.subjectUri, "predicateUri", this.property.getURI(), "datapropKey", this.makeHash(dps), "deleteProhibited", "prohibited");
        params.putAll(UrlBuilder.getModelParams(this.vreq));
        return UrlBuilder.getUrl("editRequestDispatch", params);
    }

    private DataPropertyStatement makeStatement(Literal literalValue) {
        DataPropertyStatementImpl dps = new DataPropertyStatementImpl(this.subjectUri, this.property.getURI(), literalValue.getLexicalForm());
        dps.setLanguage(literalValue.getLanguage());
        dps.setDatatypeURI(literalValue.getDatatypeURI());
        return dps;
    }

    private String makeHash(DataPropertyStatement dps) {
        return String.valueOf(RdfLiteralHash.makeRdfLiteralHash(dps));
    }

    public String getValue() {
        return this.stringValue;
    }

    @Override
    public String getDeleteUrl() {
        return "";
    }

    @Override
    public String getEditUrl() {
        return this.editUrl;
    }
}

