/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual;

import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectProperty;
import edu.cornell.mannlib.vitro.webapp.beans.Property;
import edu.cornell.mannlib.vitro.webapp.beans.PropertyGroup;
import edu.cornell.mannlib.vitro.webapp.beans.PropertyInstance;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.DataPropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.ObjectPropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.PropertyDao;
import edu.cornell.mannlib.vitro.webapp.dao.PropertyGroupDao;
import edu.cornell.mannlib.vitro.webapp.dao.PropertyInstanceDao;
import edu.cornell.mannlib.vitro.webapp.dao.WebappDaoFactory;
import edu.cornell.mannlib.vitro.webapp.utils.ApplicationConfigurationOntologyUtils;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.BaseTemplateModel;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.FauxDataPropertyWrapper;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.FauxObjectPropertyWrapper;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.ObjectPropertyTemplateModel;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.PropertyGroupTemplateModel;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.PropertyTemplateModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.vocabulary.OWL;

public class GroupedPropertyList
extends BaseTemplateModel {
    private static final Log log = LogFactory.getLog(GroupedPropertyList.class);
    private static final int MAX_GROUP_DISPLAY_RANK = 99;
    protected static final List<String> VITRO_PROPS_TO_ADD_TO_LIST = new ArrayList<String>(){
        {
            this.add("http://vitro.mannlib.cornell.edu/ns/vitro/public#mainImage");
        }
    };
    private final Individual subject;
    private final VitroRequest vreq;
    private final WebappDaoFactory wdf;
    private List<PropertyGroupTemplateModel> groups;

    GroupedPropertyList(Individual subject, VitroRequest vreq, boolean editing) {
        this.vreq = vreq;
        this.subject = subject;
        this.wdf = vreq.getWebappDaoFactory();
        ArrayList<Property> allProperties = new ArrayList<Property>();
        List<ObjectProperty> populatedOPs = subject.getPopulatedObjectPropertyList();
        Map<String, List<String>> populatedObjTypes = this.makePopulatedObjTypeMap(populatedOPs);
        populatedOPs = this.dedupe(populatedOPs);
        List<FauxObjectPropertyWrapper> populatedFauxOPs = ApplicationConfigurationOntologyUtils.getPopulatedFauxOPs(populatedOPs, subject, vreq);
        populatedFauxOPs = this.filterAdditions(populatedFauxOPs, populatedObjTypes);
        if (log.isDebugEnabled()) {
            for (ObjectProperty objectProperty : populatedFauxOPs) {
                log.debug((Object)("faux object property: " + objectProperty));
            }
            log.debug((Object)("Added " + populatedFauxOPs.size() + " faux object properties due to application configuration ontology"));
        }
        if (editing) {
            List<Property> possibleFauxProps = ApplicationConfigurationOntologyUtils.getPossibleFauxProps(populatedFauxOPs, subject, vreq, false);
            allProperties.addAll(possibleFauxProps);
        }
        populatedOPs.addAll(populatedFauxOPs);
        allProperties.addAll(populatedOPs);
        if (editing) {
            List<Property> possibleOPs = this.getPossibleOPs(populatedOPs, allProperties, subject);
            allProperties.addAll(possibleOPs);
        }
        List<DataProperty> populatedDPs = subject.getPopulatedDataPropertyList();
        if (editing) {
            List<Property> list = this.getPossibleDPs(populatedDPs, allProperties);
            allProperties.addAll(list);
        }
        List<FauxDataPropertyWrapper> list = ApplicationConfigurationOntologyUtils.getPopulatedFauxDPs(populatedDPs, subject, vreq);
        if (editing) {
            List<Property> possibleFauxProps = ApplicationConfigurationOntologyUtils.getPossibleFauxProps(list, subject, vreq, true);
            allProperties.addAll(possibleFauxProps);
        }
        populatedDPs.addAll(list);
        allProperties.addAll(populatedDPs);
        this.sort(allProperties);
        List<PropertyGroup> propertyGroups = this.addPropertiesToGroups(allProperties);
        this.groups = new ArrayList<PropertyGroupTemplateModel>(propertyGroups.size());
        for (PropertyGroup propertyGroup : propertyGroups) {
            this.groups.add(new PropertyGroupTemplateModel(vreq, propertyGroup, subject, editing, populatedDPs, populatedOPs));
        }
        if (!editing) {
            this.pruneEmptyProperties();
        }
    }

    private Map<String, List<String>> makePopulatedObjTypeMap(List<ObjectProperty> props) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (ObjectProperty prop : props) {
            if (prop.getRangeVClassURI() == null) continue;
            ArrayList<String> typeList = (ArrayList<String>)map.get(prop.getURI());
            if (typeList == null) {
                typeList = new ArrayList<String>();
                map.put(prop.getURI(), typeList);
            }
            typeList.add(prop.getRangeVClassURI());
        }
        return map;
    }

    private List<FauxObjectPropertyWrapper> filterAdditions(List<FauxObjectPropertyWrapper> populatedFauxOPs, Map<String, List<String>> populatedObjTypes) {
        ArrayList<FauxObjectPropertyWrapper> filteredAdditions = new ArrayList<FauxObjectPropertyWrapper>();
        for (FauxObjectPropertyWrapper prop : populatedFauxOPs) {
            List<String> allowedTypes = populatedObjTypes.get(prop.getURI());
            if (allowedTypes == null) continue;
            String rangeVClassURI = prop.getRangeVClassURI();
            String rangeEntityURI = prop.getRangeEntityURI();
            if (allowedTypes.contains(rangeVClassURI)) {
                filteredAdditions.add(prop);
                continue;
            }
            if (!allowedTypes.contains(rangeEntityURI)) continue;
            filteredAdditions.add(prop);
        }
        return filteredAdditions;
    }

    private void pruneEmptyProperties() {
        Iterator<PropertyGroupTemplateModel> iGroups = this.groups.iterator();
        while (iGroups.hasNext()) {
            PropertyGroupTemplateModel pgtm = iGroups.next();
            Iterator<PropertyTemplateModel> iProperties = pgtm.getProperties().iterator();
            while (iProperties.hasNext()) {
                PropertyTemplateModel property = iProperties.next();
                if (!(property instanceof ObjectPropertyTemplateModel) || !((ObjectPropertyTemplateModel)property).isEmpty()) continue;
                iProperties.remove();
            }
            if (!pgtm.isEmpty()) continue;
            iGroups.remove();
        }
    }

    protected List<ObjectProperty> dedupe(List<ObjectProperty> propList) {
        ArrayList<ObjectProperty> dedupedList = new ArrayList<ObjectProperty>();
        String uriRegister = "";
        for (ObjectProperty prop : propList) {
            if (uriRegister.equals(prop.getURI())) continue;
            uriRegister = prop.getURI();
            dedupedList.add(prop);
        }
        return dedupedList;
    }

    protected void sort(List<Property> propertyList) {
        try {
            propertyList.sort(new PropertyRanker(this.vreq));
        }
        catch (Exception ex) {
            log.error((Object)("Exception sorting merged property list: " + ex.getMessage()));
        }
    }

    private List<Property> getPossibleOPs(List<ObjectProperty> populatedOPs, List<Property> allProperties, Individual subject) {
        WebappDaoFactory wadf = this.vreq.getLanguageNeutralWebappDaoFactory();
        PropertyInstanceDao piDao = wadf.getPropertyInstanceDao();
        ObjectPropertyDao opDao = wadf.getObjectPropertyDao();
        HashMap<String, ObjectProperty> possiblePropertiesMap = new HashMap<String, ObjectProperty>();
        Collection<PropertyInstance> allPossiblePI = piDao.getAllPossiblePropInstForIndividual(subject.getURI());
        if (allPossiblePI != null) {
            for (PropertyInstance possiblePI : allPossiblePI) {
                if (possiblePI != null) {
                    ObjectProperty possibleOP = opDao.getObjectPropertyByURI(possiblePI.getPropertyURI());
                    if (possibleOP == null || this.isInPopulatedOPs(populatedOPs, possibleOP)) continue;
                    possiblePropertiesMap.put(possibleOP.getURI(), possibleOP);
                    continue;
                }
                log.error((Object)"a property instance in the Collection created by PropertyInstanceDao.getAllPossiblePropInstForIndividual() is unexpectedly null");
            }
        } else {
            log.error((Object)"a null Collection is returned from PropertyInstanceDao.getAllPossiblePropInstForIndividual()");
        }
        ArrayList<Property> possibleProperties = new ArrayList<Property>(possiblePropertiesMap.values());
        for (String propertyUri : VITRO_PROPS_TO_ADD_TO_LIST) {
            if (this.alreadyOnPropertyList(possibleProperties, propertyUri) || this.alreadyOnPropertyList(allProperties, propertyUri)) continue;
            this.addObjectPropertyToPropertyList(propertyUri, null, null, possibleProperties);
        }
        return possibleProperties;
    }

    private boolean isInPopulatedOPs(List<ObjectProperty> populatedOPs, ObjectProperty possibleOP) {
        for (ObjectProperty populatedOP : populatedOPs) {
            if (!this.redundant(populatedOP, possibleOP)) continue;
            return true;
        }
        return false;
    }

    private boolean redundant(ObjectProperty populatedOP, ObjectProperty possibleOP) {
        if (new PropertyDao.FullPropertyKey(populatedOP).equals(new PropertyDao.FullPropertyKey(possibleOP))) {
            return true;
        }
        if (new PropertyDao.FullPropertyKey(this.fudgeBlankNodeInDomain(populatedOP.getDomainVClassURI()), populatedOP.getURI(), populatedOP.getRangeVClassURI()).equals(new PropertyDao.FullPropertyKey(this.fudgeBlankNodeInDomain(possibleOP.getDomainVClassURI()), possibleOP.getURI(), possibleOP.getRangeVClassURI()))) {
            return true;
        }
        if (new PropertyDao.FullPropertyKey(populatedOP.getDomainVClassURI(), populatedOP.getURI(), this.fudgeBlankNodeInRange(populatedOP.getRangeVClassURI())).equals(new PropertyDao.FullPropertyKey(possibleOP.getDomainVClassURI(), possibleOP.getURI(), this.fudgeBlankNodeInRange(possibleOP.getRangeVClassURI())))) {
            return true;
        }
        return !(possibleOP instanceof FauxObjectPropertyWrapper) && populatedOP.getURI().equals(possibleOP.getURI());
    }

    private String fudgeBlankNodeInDomain(String rawDomainUri) {
        if (rawDomainUri == null) {
            return null;
        }
        if (rawDomainUri.contains("http://vitro.mannlib.cornell.edu/ns/bnode#")) {
            return OWL.Thing.getURI();
        }
        return rawDomainUri;
    }

    private String fudgeBlankNodeInRange(String rawRangeUri) {
        if (rawRangeUri == null) {
            return null;
        }
        if (rawRangeUri.contains("http://vitro.mannlib.cornell.edu/ns/bnode#")) {
            return "http://vitro.mannlib.cornell.edu/ns/bnode#-deadbeef";
        }
        return rawRangeUri;
    }

    private void addObjectPropertyToPropertyList(String propertyUri, String domainUri, String rangeUri, List<Property> propertyList) {
        ObjectPropertyDao opDao = this.wdf.getObjectPropertyDao();
        ObjectProperty op = opDao.getObjectPropertyByURIs(propertyUri, domainUri, rangeUri);
        if (op == null) {
            log.error((Object)("ObjectProperty op returned null from opDao.getObjectPropertyByURI(" + propertyUri + ")"));
        } else if (op.getURI() == null) {
            log.error((Object)"ObjectProperty op returned with null propertyURI from opDao.getObjectPropertyByURI()");
        } else {
            propertyList.add(op);
        }
    }

    protected List<Property> getPossibleDPs(List<DataProperty> populatedDPs, List<Property> allProperties) {
        DataPropertyDao dpDao = this.vreq.getLanguageNeutralWebappDaoFactory().getDataPropertyDao();
        ArrayList<Property> possibleProperties = new ArrayList<Property>();
        Collection<DataProperty> allDatapropColl = dpDao.getAllPossibleDatapropsForIndividual(this.subject.getURI());
        if (allDatapropColl != null) {
            for (DataProperty dp : allDatapropColl) {
                if (dp != null) {
                    if (dp.getURI() == null) {
                        log.error((Object)"DataProperty dp returned with null propertyURI from dpDao.getAllPossibleDatapropsForIndividual()");
                        continue;
                    }
                    if (this.alreadyOnPropertyList(allProperties, dp) || this.alreadyOnPropertyList(populatedDPs, dp)) continue;
                    possibleProperties.add(dp);
                    continue;
                }
                log.error((Object)"a data property in the Collection created in DataPropertyDao.getAllPossibleDatapropsForIndividual() is unexpectedly null)");
            }
        } else {
            log.error((Object)"a null Collection is returned from DataPropertyDao.getAllPossibleDatapropsForIndividual())");
        }
        return possibleProperties;
    }

    private boolean alreadyOnPropertyList(List<? extends Property> propertyList, Property p) {
        if (p.getURI() == null) {
            log.error((Object)"Property p has no propertyURI in alreadyOnPropertyList()");
            return true;
        }
        return this.alreadyOnPropertyList(propertyList, p.getURI());
    }

    private boolean alreadyOnPropertyList(List<? extends Property> propertyList, String propertyUri) {
        for (Property property : propertyList) {
            String uri = property.getURI();
            if (uri == null || !uri.equals(propertyUri)) continue;
            return true;
        }
        return false;
    }

    private List<PropertyGroup> addPropertiesToGroups(List<Property> propertyList) {
        PropertyGroupDao pgDao = this.wdf.getPropertyGroupDao();
        long start = System.currentTimeMillis();
        List<PropertyGroup> groupList = pgDao.getPublicGroups(false);
        start = System.currentTimeMillis();
        int groupCount = groupList.size();
        if (groupCount == 0) {
            log.warn((Object)"groupList has no groups on entering addPropertiesToGroups(); creating a dummy group");
            PropertyGroup dummyGroup = pgDao.createDummyPropertyGroup(null, 1);
            dummyGroup.getPropertyList().addAll(propertyList);
            groupList.add(dummyGroup);
            return groupList;
        }
        PropertyGroup groupForUnassignedProperties = pgDao.createDummyPropertyGroup("", 99);
        if (groupCount > 1) {
            try {
                Collections.sort(groupList);
            }
            catch (Exception ex) {
                log.error((Object)"Exception on sorting groupList in addPropertiesToGroups()");
            }
        }
        this.populateGroupListWithProperties(groupList, groupForUnassignedProperties, propertyList);
        try {
            int removedCount = pgDao.removeUnpopulatedGroups(groupList);
            if (removedCount == 0) {
                log.warn((Object)("Of " + groupCount + " groups, none removed by removeUnpopulatedGroups"));
            }
            groupCount -= removedCount;
        }
        catch (Exception ex) {
            log.error((Object)("Exception on trying to prune unpopulated groups from group list: " + ex.getMessage()));
        }
        log.debug((Object)(System.currentTimeMillis() - start + " to remove unpopulated groups"));
        if (groupForUnassignedProperties.getPropertyList().size() > 0) {
            groupList.add(groupForUnassignedProperties);
            if (groupCount == 0) {
                groupForUnassignedProperties.setName(null);
            }
        }
        return groupList;
    }

    private void populateGroupListWithProperties(List<PropertyGroup> groupList, PropertyGroup groupForUnassignedProperties, List<Property> propertyList) {
        for (PropertyGroup pg : groupList) {
            if (pg.getPropertyList() == null) {
                pg.setPropertyList(new ArrayList<Property>());
                continue;
            }
            if (pg.getPropertyList().size() <= 0) continue;
            pg.getPropertyList().clear();
        }
        for (Property p : propertyList) {
            if (p.getURI() == null) {
                log.error((Object)"Property p has null URI in populateGroupListWithProperties()");
                continue;
            }
            String groupUriForProperty = p.getGroupURI();
            boolean assignedToGroup = false;
            if (groupUriForProperty != null) {
                for (PropertyGroup pg : groupList) {
                    String groupUri = pg.getURI();
                    if (!groupUriForProperty.equals(groupUri)) continue;
                    pg.getPropertyList().add(p);
                    assignedToGroup = true;
                    break;
                }
            }
            if (assignedToGroup || groupForUnassignedProperties == null) continue;
            groupForUnassignedProperties.getPropertyList().add(p);
            log.debug((Object)("adding property " + this.getLabel(p) + " to group for unassigned properties"));
        }
    }

    private String getLabel(Property property) {
        String label = property.getLabel();
        if (label == null) {
            label = property.getLocalName();
        }
        return label;
    }

    public List<PropertyGroupTemplateModel> getAll() {
        return this.groups;
    }

    public PropertyTemplateModel getProperty(String propertyUri) {
        for (PropertyGroupTemplateModel pgtm : this.groups) {
            List<PropertyTemplateModel> properties = pgtm.getProperties();
            for (PropertyTemplateModel ptm : properties) {
                if (!propertyUri.equals(ptm.getUri())) continue;
                return ptm;
            }
        }
        return null;
    }

    public PropertyTemplateModel getProperty(String propertyUri, String rangeUri) {
        for (PropertyGroupTemplateModel pgtm : this.groups) {
            List<PropertyTemplateModel> properties = pgtm.getProperties();
            for (PropertyTemplateModel ptm : properties) {
                if (!propertyUri.equals(ptm.getUri()) || !rangeUri.equals(ptm.getRangeUri())) continue;
                return ptm;
            }
        }
        return null;
    }

    public PropertyTemplateModel pullProperty(String propertyUri) {
        return this.pullProperty(propertyUri, null);
    }

    public PropertyTemplateModel pullProperty(String propertyUri, String rangeUri) {
        for (PropertyGroupTemplateModel pgtm : this.groups) {
            List<PropertyTemplateModel> properties = pgtm.getProperties();
            for (PropertyTemplateModel ptm : properties) {
                if (!propertyUri.equals(ptm.getUri()) || rangeUri != null && !rangeUri.equals(ptm.getRangeUri())) continue;
                properties.remove(ptm);
                if (properties.size() == 0) {
                    this.groups.remove(pgtm);
                }
                return ptm;
            }
        }
        return null;
    }

    public PropertyGroupTemplateModel pullPropertyGroup(String groupName) {
        for (PropertyGroupTemplateModel group : this.groups) {
            if (!groupName.equals(group.getName())) continue;
            this.groups.remove(group);
            return group;
        }
        return null;
    }

    private class PropertyRanker
    implements Comparator<Property> {
        WebappDaoFactory wdf;
        PropertyGroupDao pgDao;

        private PropertyRanker(VitroRequest vreq) {
            this.wdf = vreq.getWebappDaoFactory();
            this.pgDao = this.wdf.getPropertyGroupDao();
        }

        @Override
        public int compare(Property p1, Property p2) {
            int diff = this.determineDisplayRank(p1) - this.determineDisplayRank(p2);
            if (diff == 0) {
                return GroupedPropertyList.this.getLabel(p1).compareTo(GroupedPropertyList.this.getLabel(p2));
            }
            return diff;
        }

        private int determineDisplayRank(Property p) {
            if (p instanceof DataProperty) {
                DataProperty dp = (DataProperty)p;
                return dp.getDisplayTier();
            }
            if (p instanceof ObjectProperty) {
                ObjectProperty op = (ObjectProperty)p;
                return op.getDomainDisplayTier();
            }
            log.error((Object)"Property is of unknown class in PropertyRanker()");
            return 0;
        }
    }
}

