/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual;

import edu.cornell.mannlib.vitro.webapp.beans.DataProperty;
import edu.cornell.mannlib.vitro.webapp.beans.DataPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.FauxProperty;
import edu.cornell.mannlib.vitro.webapp.web.templatemodels.individual.FauxPropertyWrapper;
import java.util.List;
import java.util.Objects;
import org.apache.jena.rdf.model.ResourceFactory;

public class FauxDataPropertyWrapper
extends DataProperty
implements FauxPropertyWrapper {
    private final DataProperty innerDP;
    private final FauxProperty faux;

    public FauxDataPropertyWrapper(DataProperty inner, FauxProperty faux) {
        this.innerDP = inner;
        this.faux = faux;
    }

    @Override
    public String getGroupURI() {
        String uri = this.faux.getGroupURI();
        if (uri != null) {
            return uri;
        }
        return this.innerDP.getGroupURI();
    }

    @Override
    public void setGroupURI(String groupUri) {
        this.faux.setGroupURI(groupUri);
        this.innerDP.setGroupURI(groupUri);
    }

    @Override
    public String getDomainVClassURI() {
        String uri = this.faux.getDomainVClassURI();
        if (uri != null) {
            return uri;
        }
        return this.innerDP.getDomainVClassURI();
    }

    @Override
    public void setDomainVClassURI(String domainClassURI) {
        this.faux.setDomainURI(domainClassURI);
        this.innerDP.setDomainVClassURI(domainClassURI);
    }

    @Override
    public String getRangeVClassURI() {
        String uri = this.faux.getRangeVClassURI();
        if (uri != null) {
            return uri;
        }
        return this.innerDP.getRangeVClassURI();
    }

    @Override
    public void setRangeVClassURI(String rangeClassURI) {
        this.faux.setRangeURI(rangeClassURI);
        this.innerDP.setRangeVClassURI(rangeClassURI);
    }

    @Override
    public String getCustomEntryForm() {
        String s = this.faux.getCustomEntryForm();
        if (s != null) {
            return s;
        }
        return this.innerDP.getCustomEntryForm();
    }

    @Override
    public void setCustomEntryForm(String s) {
        this.faux.setCustomEntryForm(s);
        this.innerDP.setCustomEntryForm(s);
    }

    @Override
    public String getPublicDescription() {
        String s = this.faux.getPublicDescription();
        if (s != null) {
            return s;
        }
        return this.innerDP.getPublicDescription();
    }

    @Override
    public void setPublicDescription(String s) {
        this.faux.setPublicDescription(s);
        this.innerDP.setPublicDescription(s);
    }

    @Override
    public String getPickListName() {
        String name = this.faux.getDisplayName();
        if (name != null) {
            return name;
        }
        return this.innerDP.getPickListName();
    }

    @Override
    public void setPickListName(String pickListName) {
        this.faux.setDisplayName(pickListName);
        this.innerDP.setPickListName(pickListName);
    }

    @Override
    public String getLabel() {
        return this.innerDP.getLabel();
    }

    @Override
    public String getDescription() {
        return this.innerDP.getDescription();
    }

    @Override
    public void setDescription(String description) {
        this.innerDP.setDescription(description);
    }

    @Override
    public String getExample() {
        return this.innerDP.getExample();
    }

    @Override
    public void setExample(String example) {
        this.innerDP.setExample(example);
    }

    @Override
    public int getDisplayTier() {
        return this.faux.getDisplayTier();
    }

    @Override
    public boolean getFunctional() {
        return this.innerDP.getFunctional();
    }

    @Override
    public void setFunctional(boolean functional) {
        this.innerDP.setFunctional(functional);
    }

    @Override
    public void setLabel(String label) {
        this.innerDP.setLabel(label);
    }

    @Override
    public boolean isSubjectSide() {
        return this.innerDP.isSubjectSide();
    }

    @Override
    public boolean isEditLinkSuppressed() {
        return this.innerDP.isEditLinkSuppressed();
    }

    @Override
    public boolean isAddLinkSuppressed() {
        return this.innerDP.isAddLinkSuppressed();
    }

    @Override
    public boolean isDeleteLinkSuppressed() {
        return this.innerDP.isDeleteLinkSuppressed();
    }

    @Override
    public void setEditLinkSuppressed(boolean editLinkSuppressed) {
        this.innerDP.setEditLinkSuppressed(editLinkSuppressed);
    }

    @Override
    public void setAddLinkSuppressed(boolean addLinkSuppressed) {
        this.innerDP.setAddLinkSuppressed(addLinkSuppressed);
    }

    @Override
    public void setDeleteLinkSuppressed(boolean deleteLinkSuppressed) {
        this.innerDP.setDeleteLinkSuppressed(deleteLinkSuppressed);
    }

    @Override
    public boolean isAnonymous() {
        return this.innerDP.isAnonymous();
    }

    @Override
    public String getURI() {
        return this.innerDP.getURI();
    }

    @Override
    public void setURI(String URI2) {
        this.innerDP.setURI(URI2);
    }

    @Override
    public String getNamespace() {
        return this.innerDP.getNamespace();
    }

    @Override
    public void setNamespace(String namespace) {
        this.innerDP.setNamespace(namespace);
    }

    @Override
    public String getLocalName() {
        return this.innerDP.getLocalName();
    }

    @Override
    public void setLocalName(String localName) {
        this.innerDP.setLocalName(localName);
    }

    @Override
    public String getLocalNameWithPrefix() {
        return this.innerDP.getLocalNameWithPrefix();
    }

    @Override
    public void setLocalNameWithPrefix(String prefixedLocalName) {
        this.innerDP.setLocalNameWithPrefix(prefixedLocalName);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.faux == null ? 0 : this.faux.hashCode());
        result = 31 * result + (this.innerDP == null ? 0 : this.innerDP.hashCode());
        return Objects.hash(this.innerDP, this.faux);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FauxDataPropertyWrapper that = (FauxDataPropertyWrapper)obj;
        return Objects.equals(this.innerDP, that.innerDP) && Objects.equals(this.faux, that.faux);
    }

    @Override
    public List<DataPropertyStatement> getDataPropertyStatements() {
        return this.innerDP.getDataPropertyStatements();
    }

    @Override
    public String toString() {
        return String.format("FauxDataPropertyWrapper[ %s ==> %s ==> %s, statementCount=%d, group=%s, customEntryForm=%s ]", this.localName(this.getDomainVClassURI()), this.localName(this.getURI()), this.localName(this.getRangeVClassURI()), this.getDataPropertyStatements() == null ? 0 : this.getDataPropertyStatements().size(), this.localName(this.getGroupURI()), this.simpleName(this.getCustomEntryForm()));
    }

    private Object simpleName(String classname) {
        if (classname == null) {
            return null;
        }
        return classname.substring(classname.lastIndexOf(".") + 1);
    }

    private Object localName(String uri) {
        if (uri == null) {
            return null;
        }
        return ResourceFactory.createResource((String)uri).getLocalName();
    }

    @Override
    public FauxProperty getFauxProperty() {
        return this.faux;
    }

    @Override
    public String getContextUri() {
        return this.faux.getContextUri();
    }
}

