/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web;

import edu.cornell.mannlib.vitro.webapp.beans.Individual;
import edu.cornell.mannlib.vitro.webapp.beans.ObjectPropertyStatement;
import edu.cornell.mannlib.vitro.webapp.beans.VClass;
import edu.cornell.mannlib.vitro.webapp.controller.VitroRequest;
import edu.cornell.mannlib.vitro.webapp.dao.VClassDao;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.impl.ModelCom;

public class MiscWebUtils {
    private static final Log log = LogFactory.getLog((String)MiscWebUtils.class.getName());

    public static Properties loadPropertiesFromRequest(Properties current, ServletRequest req) {
        if (req == null || current == null) {
            log.error((Object)"UtilBean.loadPropertiesFromRequest() exiting because of null input");
            return current;
        }
        Enumeration names = req.getParameterNames();
        String value = null;
        String name = null;
        while (names.hasMoreElements()) {
            name = (String)names.nextElement();
            value = req.getParameter(name);
            if (value == null) continue;
            current.setProperty(name, value);
        }
        return current;
    }

    public static String writeAttribute(HttpServletRequest request, String attribute) throws JspException {
        Object contentObj = request.getAttribute(attribute);
        if (contentObj == null) {
            throw new JspException("Attribute " + attribute + " in request attributes was null.");
        }
        if (!(contentObj instanceof String)) {
            String className = contentObj.getClass().getName();
            throw new JspException("Class of " + attribute + " is " + className + ", it should be String");
        }
        return (String)contentObj;
    }

    public static String getCustomShortView(HttpServletRequest request) {
        Individual object = ((ObjectPropertyStatement)request.getAttribute("opStmt")).getObject();
        return MiscWebUtils.getCustomShortView(object, request);
    }

    public static String getCustomShortView(Individual individual, HttpServletRequest request) {
        if (individual == null) {
            return null;
        }
        VitroRequest vreq = new VitroRequest(request);
        VClassDao vcDao = vreq.getWebappDaoFactory().getVClassDao();
        log.debug((Object)("searching for custom short view for " + individual.getURI()));
        String customShortView = null;
        List<VClass> vclasses = individual.getVClasses(true);
        HashSet<String> superClasses = new HashSet<String>();
        for (VClass vclass : vclasses) {
            log.debug((Object)vclass.getURI());
            customShortView = vclass.getCustomShortView();
            if (customShortView != null) {
                log.debug((Object)customShortView);
                return customShortView;
            }
            String vclassUri = vclass.getURI();
            superClasses.addAll(vcDao.getAllSuperClassURIs(vclassUri));
        }
        log.debug((Object)"checking superclasses for custom short view");
        for (String superClassUri : superClasses) {
            VClass vc = vcDao.getVClassByURI(superClassUri);
            customShortView = vc.getCustomShortView();
            log.debug((Object)vc.getURI());
            if (customShortView == null) continue;
            log.debug((Object)customShortView);
            return customShortView;
        }
        return null;
    }

    public static String getRequestAttributes(HttpServletRequest req) {
        StringBuilder val = new StringBuilder("<table>");
        Enumeration names = req.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            val.append("\n\t<tr><td>").append(name).append("</td><td><pre>");
            String value = null;
            try {
                Object obj = req.getAttribute(name);
                value = obj instanceof Model || obj instanceof ModelCom ? "[Jena model object]" : (obj == null ? "[null]" : StringEscapeUtils.ESCAPE_HTML4.translate((CharSequence)obj.toString()));
            }
            catch (Throwable th) {
                value = "unable to get value";
            }
            val.append(value).append("</pre></td></tr>\n");
        }
        return val.append("</table>").toString();
    }

    public static String getRequestParam(HttpServletRequest req) {
        StringBuilder val = new StringBuilder("<table>");
        Enumeration names = req.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            val.append("\n\t<tr><td><h3>").append(name).append("</h3><td><pre>");
            String value = null;
            try {
                String obj = req.getParameter(name);
                value = obj == null ? "[null]" : StringEscapeUtils.ESCAPE_HTML4.translate((CharSequence)obj.toString());
            }
            catch (Throwable th) {
                value = "unable to get value";
            }
            val.append(value).append("</pre><td></tr>\n");
        }
        return val.append("</table>").toString();
    }

    public static String getSessionAttributes(HttpServletRequest req) {
        StringBuilder val = new StringBuilder("<table>");
        Enumeration names = req.getSession().getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            val.append("\n\t<tr><td><h3>").append(name).append("</h3><td><pre>");
            String value = null;
            try {
                Object obj = req.getSession().getAttribute(name);
                value = obj instanceof Model || obj instanceof ModelCom ? "[Jena model object]" : (obj == null ? "[null]" : StringEscapeUtils.ESCAPE_HTML4.translate((CharSequence)obj.toString()));
            }
            catch (Throwable th) {
                value = "unable to get value";
            }
            val.append(value).append("</pre></td></tr>\n");
        }
        return val.append("</table>").toString();
    }

    public static String getReqInfo(HttpServletRequest req) {
        String rv = null;
        try {
            rv = "<table><tr><td><h2>Request Attributes:</h2></td></tr><tr><td>" + MiscWebUtils.getRequestAttributes(req) + "</td></tr><tr><td>--------------------------</td></tr><tr><td><h2>Request Parameters:</h2></td></tr><tr><td>" + MiscWebUtils.getRequestParam(req) + "</td></tr><tr><td>---------------------------</td></td><tr><td><h2>Session Attributes:</h2></td></tr><tr><td>" + MiscWebUtils.getSessionAttributes(req) + "</td></tr></table>";
        }
        catch (Throwable t) {
            rv = "MiscWebUtils.getRequestParam() Error :\n" + t;
            t.printStackTrace();
        }
        return rv;
    }

    public static void debugPrintHeaders(HttpServletRequest req) {
        Enumeration hnames = req.getHeaderNames();
        while (hnames.hasMoreElements()) {
            String name = (String)hnames.nextElement();
            log.debug((Object)("header " + name));
            String value = req.getHeader(name);
            log.debug((Object)("    " + value));
            Enumeration values = req.getHeaders(name);
            if (values == null) {
                log.debug((Object)"    enumeration was null");
                continue;
            }
            log.debug((Object)"    enumeration values");
            while (values.hasMoreElements()) {
                String val = (String)values.nextElement();
                log.debug((Object)("    " + value));
            }
        }
    }

    public static String escape(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        block10: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                case '/': {
                    sb.append("\\/");
                    continue block10;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f') {
                        String ss = Integer.toHexString(ch);
                        sb.append("\\u");
                        for (int k = 0; k < 4 - ss.length(); ++k) {
                            sb.append('0');
                        }
                        sb.append(ss.toUpperCase());
                        continue block10;
                    }
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }
}

