/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.web;

import java.net.URL;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.owasp.validator.html.AntiSamy;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.Policy;
import org.owasp.validator.html.PolicyException;
import org.owasp.validator.html.ScanException;

public class AntiScript {
    private static final Log log = LogFactory.getLog(AntiScript.class);
    private static Policy policy;
    private static AntiSamy antiSamy;
    private static final String ANTI_SCRIPT_SCANNER = "ANTI_SCRIPT_SCANNER";
    private static String ANTI_SCRIPT_POLICY_FILE;

    public static String cleanText(String dirtyInput) {
        if (dirtyInput == null) {
            return null;
        }
        AntiSamy as = AntiScript.getAntiSamyScanner();
        try {
            CleanResults cr = as.scan(dirtyInput);
            return cr.getCleanHTML();
        }
        catch (PolicyException | ScanException e) {
            log.error((Object)"Error while scanning HTML", e);
            return "AntiScript: HTML caused scan error.";
        }
    }

    public static String cleanURI(String dirtyInput) {
        return AntiScript.cleanText(dirtyInput);
    }

    public static <T> void cleanMapValues(Map<T, String> map) {
        for (T key : map.keySet()) {
            map.put(key, AntiScript.cleanText(map.get(key)));
        }
    }

    protected static Policy getAntiScriptPolicy() {
        if (policy == null) {
            try {
                String url = ANTI_SCRIPT_POLICY_FILE;
                URL policyFile = AntiScript.class.getResource(url);
                Policy newPolicy = Policy.getInstance((URL)policyFile);
                log.debug((Object)"anti-script policy loaded successfully");
                policy = newPolicy;
            }
            catch (Throwable e) {
                log.error((Object)"Anti-Script policy not setup.", e);
                return null;
            }
        }
        return policy;
    }

    public static AntiSamy getAntiSamyScanner() {
        if (antiSamy == null) {
            antiSamy = new AntiSamy(AntiScript.getAntiScriptPolicy());
            log.debug((Object)"anti-script scanner loaded successfully");
        }
        return antiSamy;
    }

    static {
        ANTI_SCRIPT_POLICY_FILE = "/edu/cornell/mannlib/vitro/webapp/web/antisamy-vitro-1.4.4.xml";
    }
}

