/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner;

import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner.ModelConstructQueryContext;
import edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner.ModelSelectQueryContext;
import edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner.QueryHolder;
import edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner.RdfServiceConstructQueryContext;
import edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner.RdfServiceSelectQueryContext;
import edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner.ResultSetParser;
import edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner.StringResultsMapping;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.rdf.model.Model;

public final class SparqlQueryRunner {
    private static final Log log = LogFactory.getLog(SparqlQueryRunner.class);

    private SparqlQueryRunner() {
    }

    public static QueryHolder queryHolder(String queryString) {
        return new QueryHolder(queryString);
    }

    public static SelectQueryContext createSelectQueryContext(RDFService rdfService, String queryString) {
        return SparqlQueryRunner.createSelectQueryContext(rdfService, SparqlQueryRunner.queryHolder(queryString));
    }

    public static SelectQueryContext createSelectQueryContext(RDFService rdfService, QueryHolder query) {
        return new RdfServiceSelectQueryContext(rdfService, query);
    }

    public static SelectQueryContext createSelectQueryContext(Model model, String queryString) {
        return SparqlQueryRunner.createSelectQueryContext(model, SparqlQueryRunner.queryHolder(queryString));
    }

    public static SelectQueryContext createSelectQueryContext(Model model, QueryHolder query) {
        return new ModelSelectQueryContext(model, query);
    }

    public static ConstructQueryContext createConstructQueryContext(RDFService rdfService, String queryString) {
        return SparqlQueryRunner.createConstructQueryContext(rdfService, SparqlQueryRunner.queryHolder(queryString));
    }

    public static ConstructQueryContext createConstructQueryContext(RDFService rdfService, QueryHolder query) {
        return new RdfServiceConstructQueryContext(rdfService, query);
    }

    public static ConstructQueryContext createConstructQueryContext(Model model, String queryString) {
        return SparqlQueryRunner.createConstructQueryContext(model, SparqlQueryRunner.queryHolder(queryString));
    }

    public static ConstructQueryContext createConstructQueryContext(Model model, QueryHolder query) {
        return new ModelConstructQueryContext(model, query);
    }

    public static interface ExecutingConstructQueryContext {
        public Model toModel();
    }

    public static interface ConstructQueryContext {
        public ConstructQueryContext bindVariableToUri(String var1, String var2);

        public ConstructQueryContext bindVariableToPlainLiteral(String var1, String var2);

        public ExecutingConstructQueryContext execute();
    }

    public static interface ExecutingSelectQueryContext {
        public StringResultsMapping toStringFields(String ... var1);

        public <T> T parse(ResultSetParser<T> var1);

        public void writeToOutput(OutputStream var1);
    }

    public static interface SelectQueryContext {
        public SelectQueryContext bindVariableToUri(String var1, String var2);

        public SelectQueryContext bindVariableToPlainLiteral(String var1, String var2);

        public ExecutingSelectQueryContext execute();
    }
}

