/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner;

import edu.cornell.mannlib.vitro.webapp.rdfservice.RDFService;
import edu.cornell.mannlib.vitro.webapp.rdfservice.impl.RDFServiceUtils;
import edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner.QueryHolder;
import edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner.SparqlQueryRunner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.rdf.model.Model;

public class RdfServiceConstructQueryContext
implements SparqlQueryRunner.ConstructQueryContext {
    private static final Log log = LogFactory.getLog(RdfServiceConstructQueryContext.class);
    private final RDFService rdfService;
    private final QueryHolder query;

    public RdfServiceConstructQueryContext(RDFService rdfService, QueryHolder query) {
        this.rdfService = rdfService;
        this.query = query;
    }

    @Override
    public SparqlQueryRunner.ConstructQueryContext bindVariableToUri(String name, String uri) {
        return new RdfServiceConstructQueryContext(this.rdfService, this.query.bindToUri(name, uri));
    }

    @Override
    public SparqlQueryRunner.ConstructQueryContext bindVariableToPlainLiteral(String name, String value) {
        return new RdfServiceConstructQueryContext(this.rdfService, this.query.bindToPlainLiteral(name, value));
    }

    @Override
    public SparqlQueryRunner.ExecutingConstructQueryContext execute() {
        return new RdfServiceExecutingConstructQueryContext(this.rdfService, this.query);
    }

    public String toString() {
        return "RdfServiceConstructQueryContext[query=" + this.query + "]";
    }

    static /* synthetic */ Log access$000() {
        return log;
    }

    private static class RdfServiceExecutingConstructQueryContext
    implements SparqlQueryRunner.ExecutingConstructQueryContext {
        private final RDFService rdfService;
        private final QueryHolder query;

        public RdfServiceExecutingConstructQueryContext(RDFService rdfService, QueryHolder query) {
            this.rdfService = rdfService;
            this.query = query;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Model toModel() {
            try (Object qe = null;){
                Model model = RDFServiceUtils.parseModel(this.rdfService.sparqlConstructQuery(this.query.getQueryString(), RDFService.ModelSerializationFormat.NTRIPLE), RDFService.ModelSerializationFormat.NTRIPLE);
                return model;
            }
        }
    }
}

