/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner;

import edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner.QueryHolder;
import edu.cornell.mannlib.vitro.webapp.utils.sparqlrunner.SparqlQueryRunner;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.Syntax;
import org.apache.jena.rdf.model.Model;

public class ModelConstructQueryContext
implements SparqlQueryRunner.ConstructQueryContext {
    private static final Log log = LogFactory.getLog(ModelConstructQueryContext.class);
    private static final Syntax SYNTAX = Syntax.syntaxARQ;
    private final Model model;
    private final QueryHolder query;

    public ModelConstructQueryContext(Model model, QueryHolder query) {
        this.model = model;
        this.query = query;
    }

    @Override
    public SparqlQueryRunner.ConstructQueryContext bindVariableToUri(String name, String uri) {
        return new ModelConstructQueryContext(this.model, this.query.bindToUri(name, uri));
    }

    @Override
    public SparqlQueryRunner.ConstructQueryContext bindVariableToPlainLiteral(String name, String value) {
        return new ModelConstructQueryContext(this.model, this.query.bindToPlainLiteral(name, value));
    }

    public String toString() {
        return "ModelConstructQueryContext[query=" + this.query + "]";
    }

    @Override
    public SparqlQueryRunner.ExecutingConstructQueryContext execute() {
        return new ModelExecutingConstructQueryContext(this.model, this.query);
    }

    static /* synthetic */ Log access$100() {
        return log;
    }

    private static class ModelExecutingConstructQueryContext
    implements SparqlQueryRunner.ExecutingConstructQueryContext {
        private final Model model;
        private final QueryHolder query;

        public ModelExecutingConstructQueryContext(Model model, QueryHolder query) {
            this.model = model;
            this.query = query;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Model toModel() {
            try (QueryExecution qe = null;){
                Query q = QueryFactory.create((String)this.query.getQueryString(), (Syntax)SYNTAX);
                qe = QueryExecutionFactory.create((Query)q, (Model)this.model);
                Model model = qe.execConstruct();
                return model;
            }
        }
    }
}

