/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.http;

import edu.cornell.mannlib.vitro.webapp.utils.http.AcceptHeaderParsingException;
import edu.cornell.mannlib.vitro.webapp.utils.http.NotAcceptableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicHeaderValueParser;

public class ContentTypeUtil {
    public static String bestContentType(String acceptHeader, Collection<String> availableTypeNames) throws AcceptHeaderParsingException, NotAcceptableException {
        if (availableTypeNames == null) {
            throw new NotAcceptableException("availableTypeNames may not be null.");
        }
        Set<AcceptableType> acceptableTypes = ContentTypeUtil.parseAcceptHeader(acceptHeader);
        List<MatchCriteria> availableTypes = ContentTypeUtil.convertToMatchCriteria(availableTypeNames);
        float bestFitQuality = 0.0f;
        MatchCriteria bestMatch = null;
        for (AcceptableType acceptableType : acceptableTypes) {
            for (MatchCriteria availableType : availableTypes) {
                float fitQuality = acceptableType.fitQuality(availableType);
                if (!(fitQuality > bestFitQuality)) continue;
                bestFitQuality = fitQuality;
                bestMatch = availableType;
            }
        }
        if (bestMatch == null) {
            throw new NotAcceptableException("No available type matches the Accept header: '" + acceptHeader + "'; available types are " + availableTypeNames);
        }
        return bestMatch.getName();
    }

    public static Set<AcceptableType> parseAcceptHeader(String acceptHeader) throws AcceptHeaderParsingException {
        if (acceptHeader == null || acceptHeader.trim().isEmpty()) {
            return Collections.singleton(new AcceptableType("*/*", "1.0"));
        }
        HeaderElement[] elements = BasicHeaderValueParser.parseElements((String)acceptHeader, null);
        HashSet<AcceptableType> acceptableTypes = new HashSet<AcceptableType>();
        for (HeaderElement he : elements) {
            String name = he.getName();
            NameValuePair qPair = he.getParameterByName("q");
            String qString = qPair == null ? "1.0" : qPair.getValue();
            acceptableTypes.add(new AcceptableType(name, qString));
        }
        return acceptableTypes;
    }

    private static List<MatchCriteria> convertToMatchCriteria(Collection<String> availableTypes) {
        ArrayList<MatchCriteria> availableMatches = new ArrayList<MatchCriteria>();
        for (String availableType : availableTypes) {
            availableMatches.add(new MatchCriteria(availableType));
        }
        return availableMatches;
    }

    static class MatchCriteria {
        private final String name;
        private final String type;
        private final String subtype;

        MatchCriteria(String name) {
            if (name == null) {
                name = "";
            }
            this.name = name;
            int slashHere = name.indexOf(47);
            if (name.isEmpty()) {
                this.type = "*";
                this.subtype = "*";
            } else if (slashHere == -1) {
                this.type = name;
                this.subtype = "*";
            } else if (slashHere == name.length() - 1) {
                this.type = name.substring(0, slashHere);
                this.subtype = "*";
            } else {
                this.type = name.substring(0, slashHere);
                this.subtype = name.substring(slashHere + 1);
            }
        }

        public int matchQuality(MatchCriteria that) {
            boolean subtypeWild;
            boolean typeMatch = this.type.equals(that.type);
            boolean typeWild = this.type.equals("*") || that.type.equals("*");
            boolean subtypeMatch = this.subtype.equals(that.subtype);
            boolean bl = subtypeWild = this.subtype.equals("*") || that.subtype.equals("*");
            if (typeWild) {
                return 1;
            }
            if (typeMatch && subtypeWild) {
                return 2;
            }
            if (typeMatch && subtypeMatch) {
                return 3;
            }
            return 0;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getSubtype() {
            return this.subtype;
        }
    }

    static class AcceptableType {
        private final MatchCriteria matchCriteria;
        private final float q;

        public AcceptableType(String name, String qString) throws AcceptHeaderParsingException {
            this.matchCriteria = new MatchCriteria(name);
            this.q = this.parseQValue(qString);
        }

        private float parseQValue(String qString) throws AcceptHeaderParsingException {
            float qValue = 0.0f;
            if (qString == null || qString.trim().isEmpty()) {
                qString = "1";
            }
            try {
                qValue = Float.parseFloat(qString);
            }
            catch (Exception e) {
                throw new AcceptHeaderParsingException("invalid q value: '" + qString + "'");
            }
            if (qValue > 1.0f || qValue <= 0.0f) {
                throw new AcceptHeaderParsingException("q value out of range: " + qString);
            }
            return qValue;
        }

        public float fitQuality(MatchCriteria availableType) {
            int matchQuality = this.matchCriteria.matchQuality(availableType);
            if (matchQuality == 0) {
                return 0.0f;
            }
            return (float)matchQuality + 1.0f + this.q;
        }

        public String getName() {
            return this.matchCriteria.getName();
        }

        public float getQ() {
            return this.q;
        }
    }
}

