/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.mannlib.vitro.webapp.utils.configuration;

import edu.cornell.mannlib.vitro.webapp.config.ConfigurationProperties;
import edu.cornell.mannlib.vitro.webapp.modelaccess.ModelAccess;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.ConfigurationBeanLoader;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.ConfigurationBeanLoaderException;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.ConfigurationReader;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.ContextModelsUser;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.PropertyType;
import edu.cornell.mannlib.vitro.webapp.utils.configuration.RequestModelsUser;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class WrappedInstance<T> {
    private final T instance;
    private final Map<String, PropertyType.PropertyMethod> propertyMethods;
    private final Set<Method> validationMethods;

    public WrappedInstance(T instance, Map<String, PropertyType.PropertyMethod> propertyMethods, Set<Method> validationMethods) {
        this.instance = instance;
        this.propertyMethods = propertyMethods;
        this.validationMethods = validationMethods;
    }

    public void satisfyInterfaces(ServletContext ctx, HttpServletRequest req) throws ResourceUnavailableException {
        if (this.instance instanceof ContextModelsUser) {
            if (ctx == null) {
                throw new ResourceUnavailableException("Cannot satisfy ContextModelsUser interface: context not available.");
            }
            ContextModelsUser cmu = (ContextModelsUser)this.instance;
            cmu.setContextModels(ModelAccess.on(ctx));
        }
        if (this.instance instanceof RequestModelsUser) {
            if (req == null) {
                throw new ResourceUnavailableException("Cannot satisfy RequestModelsUser interface: request not available.");
            }
            RequestModelsUser rmu = (RequestModelsUser)this.instance;
            rmu.setRequestModels(ModelAccess.on(req));
        }
        if (this.instance instanceof ConfigurationReader) {
            if (ctx == null) {
                throw new ResourceUnavailableException("Cannot satisfy ConfigurationReader interface: context not available.");
            }
            ConfigurationReader cr = (ConfigurationReader)this.instance;
            cr.setConfigurationProperties(ConfigurationProperties.getBean(ctx));
        }
    }

    public void checkCardinality(Set<PropertyType.PropertyStatement> propertyStatements) throws CardinalityException {
        Map<String, Integer> statementCounts = this.countPropertyStatementsByPredicateUri(propertyStatements);
        for (PropertyType.PropertyMethod pm : this.propertyMethods.values()) {
            int count;
            Integer c = statementCounts.get(pm.getPropertyUri());
            int n = count = c == null ? 0 : c;
            if (count < pm.getMinOccurs()) {
                throw new CardinalityException("Expecting at least " + pm.getMinOccurs() + " values for '" + pm.getPropertyUri() + "', but found " + count + ".");
            }
            if (count <= pm.getMaxOccurs()) continue;
            throw new CardinalityException("Expecting no more than " + pm.getMaxOccurs() + " values for '" + pm.getPropertyUri() + "', but found " + count + ".");
        }
        statementCounts.hashCode();
    }

    private Map<String, Integer> countPropertyStatementsByPredicateUri(Set<PropertyType.PropertyStatement> propertyStatements) {
        HashMap<String, Integer> statementCounts = new HashMap<String, Integer>();
        for (String pmPredicateUri : this.propertyMethods.keySet()) {
            int count = 0;
            for (PropertyType.PropertyStatement ps : propertyStatements) {
                if (!ps.getPredicateUri().equals(pmPredicateUri)) continue;
                ++count;
            }
            statementCounts.put(pmPredicateUri, count);
        }
        return statementCounts;
    }

    public void setProperties(ConfigurationBeanLoader loader, Collection<PropertyType.PropertyStatement> propertyStatements) throws PropertyType.PropertyTypeException, ConfigurationBeanLoaderException {
        for (PropertyType.PropertyStatement ps : propertyStatements) {
            PropertyType.PropertyMethod pm = this.propertyMethods.get(ps.getPredicateUri());
            if (pm == null) continue;
            pm.confirmCompatible(ps);
            if (ps instanceof PropertyType.ResourcePropertyStatement) {
                PropertyType.ResourcePropertyStatement rps = (PropertyType.ResourcePropertyStatement)ps;
                Object subordinate = loader.loadInstance(rps.getValue(), pm.getParameterType());
                pm.invoke(this.instance, subordinate);
                continue;
            }
            pm.invoke(this.instance, ps.getValue());
        }
    }

    public void validate() throws ValidationFailedException {
        for (Method method : this.validationMethods) {
            try {
                method.invoke(this.instance, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new ValidationFailedException("Error executing validation method '" + method + "'", e);
            }
        }
    }

    public T getInstance() {
        return this.instance;
    }

    public static class CardinalityException
    extends Exception {
        public CardinalityException(String message) {
            super(message);
        }
    }

    public static class ValidationFailedException
    extends Exception {
        public ValidationFailedException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class ResourceUnavailableException
    extends Exception {
        public ResourceUnavailableException(String message) {
            super(message);
        }
    }
}

